/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.annotation.TargetApi;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.transition.AutoTransitionPort;
import android.support.transition.ScenePort;
import android.support.transition.TransitionPort;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

@RequiresApi(value=14)
@TargetApi(value=14)
class TransitionManagerPort {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static String LOG_TAG = "TransitionManager";
    private static TransitionPort sDefaultTransition = new AutoTransitionPort();
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<TransitionPort>>>> sRunningTransitions = new ThreadLocal();
    static ArrayList<ViewGroup> sPendingTransitions = new ArrayList();
    ArrayMap<ScenePort, TransitionPort> mSceneTransitions = new ArrayMap();
    ArrayMap<ScenePort, ArrayMap<ScenePort, TransitionPort>> mScenePairTransitions = new ArrayMap();
    ArrayMap<ScenePort, ArrayMap<String, TransitionPort>> mSceneNameTransitions = new ArrayMap();
    ArrayMap<String, ArrayMap<ScenePort, TransitionPort>> mNameSceneTransitions = new ArrayMap();

    TransitionManagerPort() {
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static TransitionPort getDefaultTransition() {
        return sDefaultTransition;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setDefaultTransition(TransitionPort transition) {
        sDefaultTransition = transition;
    }

    private static void changeScene(ScenePort scene, TransitionPort transition) {
        ScenePort oldScene;
        ViewGroup sceneRoot = scene.getSceneRoot();
        TransitionPort transitionClone = null;
        if (transition != null) {
            transitionClone = transition.clone();
            transitionClone.setSceneRoot(sceneRoot);
        }
        if ((oldScene = ScenePort.getCurrentScene((View)sceneRoot)) != null && oldScene.isCreatedFromLayoutResource()) {
            transitionClone.setCanRemoveViews(true);
        }
        TransitionManagerPort.sceneChangeSetup(sceneRoot, transitionClone);
        scene.enter();
        TransitionManagerPort.sceneChangeRunTransition(sceneRoot, transitionClone);
    }

    static ArrayMap<ViewGroup, ArrayList<TransitionPort>> getRunningTransitions() {
        WeakReference<ArrayMap<ViewGroup, ArrayList<TransitionPort>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions == null || runningTransitions.get() == null) {
            ArrayMap transitions = new ArrayMap();
            runningTransitions = new WeakReference<ArrayMap>(transitions);
            sRunningTransitions.set(runningTransitions);
        }
        return (ArrayMap)runningTransitions.get();
    }

    private static void sceneChangeRunTransition(ViewGroup sceneRoot, TransitionPort transition) {
        if (transition != null && sceneRoot != null) {
            MultiListener listener = new MultiListener(transition, sceneRoot);
            sceneRoot.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
            sceneRoot.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, TransitionPort transition) {
        ScenePort previousScene;
        ArrayList runningTransitions = (ArrayList)TransitionManagerPort.getRunningTransitions().get((Object)sceneRoot);
        if (runningTransitions != null && runningTransitions.size() > 0) {
            for (TransitionPort runningTransition : runningTransitions) {
                runningTransition.pause((View)sceneRoot);
            }
        }
        if (transition != null) {
            transition.captureValues(sceneRoot, true);
        }
        if ((previousScene = ScenePort.getCurrentScene((View)sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public static void go(ScenePort scene) {
        TransitionManagerPort.changeScene(scene, sDefaultTransition);
    }

    public static void go(ScenePort scene, TransitionPort transition) {
        TransitionManagerPort.changeScene(scene, transition);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot) {
        TransitionManagerPort.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(ViewGroup sceneRoot, TransitionPort transition) {
        if (!sPendingTransitions.contains(sceneRoot) && ViewCompat.isLaidOut((View)sceneRoot)) {
            sPendingTransitions.add(sceneRoot);
            if (transition == null) {
                transition = sDefaultTransition;
            }
            TransitionPort transitionClone = transition.clone();
            TransitionManagerPort.sceneChangeSetup(sceneRoot, transitionClone);
            ScenePort.setCurrentScene((View)sceneRoot, null);
            TransitionManagerPort.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }

    public void setTransition(ScenePort scene, TransitionPort transition) {
        this.mSceneTransitions.put((Object)scene, (Object)transition);
    }

    public void setTransition(ScenePort fromScene, ScenePort toScene, TransitionPort transition) {
        ArrayMap sceneTransitionMap = (ArrayMap)this.mScenePairTransitions.get((Object)toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put((Object)toScene, (Object)sceneTransitionMap);
        }
        sceneTransitionMap.put((Object)fromScene, (Object)transition);
    }

    private TransitionPort getTransition(ScenePort scene) {
        TransitionPort transition;
        ArrayMap sceneTransitionMap;
        ScenePort currScene;
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (sceneRoot != null && (currScene = ScenePort.getCurrentScene((View)sceneRoot)) != null && (sceneTransitionMap = (ArrayMap)this.mScenePairTransitions.get((Object)scene)) != null && (transition = (TransitionPort)sceneTransitionMap.get((Object)currScene)) != null) {
            return transition;
        }
        transition = (TransitionPort)this.mSceneTransitions.get((Object)scene);
        return transition != null ? transition : sDefaultTransition;
    }

    public TransitionPort getNamedTransition(String fromName, ScenePort toScene) {
        ArrayMap m = (ArrayMap)this.mNameSceneTransitions.get((Object)fromName);
        if (m != null) {
            return (TransitionPort)m.get((Object)toScene);
        }
        return null;
    }

    public TransitionPort getNamedTransition(ScenePort fromScene, String toName) {
        ArrayMap m = (ArrayMap)this.mSceneNameTransitions.get((Object)fromScene);
        if (m != null) {
            return (TransitionPort)m.get((Object)toName);
        }
        return null;
    }

    public String[] getTargetSceneNames(ScenePort fromScene) {
        ArrayMap m = (ArrayMap)this.mSceneNameTransitions.get((Object)fromScene);
        if (m == null) {
            return EMPTY_STRINGS;
        }
        int count = m.size();
        String[] result = new String[count];
        for (int i = 0; i < count; ++i) {
            result[i] = (String)m.keyAt(i);
        }
        return result;
    }

    public void setTransition(ScenePort fromScene, String toName, TransitionPort transition) {
        ArrayMap m = (ArrayMap)this.mSceneNameTransitions.get((Object)fromScene);
        if (m == null) {
            m = new ArrayMap();
            this.mSceneNameTransitions.put((Object)fromScene, (Object)m);
        }
        m.put((Object)toName, (Object)transition);
    }

    public void setTransition(String fromName, ScenePort toScene, TransitionPort transition) {
        ArrayMap m = (ArrayMap)this.mNameSceneTransitions.get((Object)fromName);
        if (m == null) {
            m = new ArrayMap();
            this.mNameSceneTransitions.put((Object)fromName, (Object)m);
        }
        m.put((Object)toScene, (Object)transition);
    }

    public void transitionTo(ScenePort scene) {
        TransitionManagerPort.changeScene(scene, this.getTransition(scene));
    }

    private static class MultiListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        TransitionPort mTransition;
        ViewGroup mSceneRoot;

        MultiListener(TransitionPort transition, ViewGroup sceneRoot) {
            this.mTransition = transition;
            this.mSceneRoot = sceneRoot;
        }

        private void removeListeners() {
            this.mSceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.mSceneRoot.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            ArrayList runningTransitions = (ArrayList)TransitionManagerPort.getRunningTransitions().get((Object)this.mSceneRoot);
            if (runningTransitions != null && runningTransitions.size() > 0) {
                for (TransitionPort runningTransition : runningTransitions) {
                    runningTransition.resume((View)this.mSceneRoot);
                }
            }
            this.mTransition.clearValues(true);
        }

        public boolean onPreDraw() {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            final ArrayMap<ViewGroup, ArrayList<TransitionPort>> runningTransitions = TransitionManagerPort.getRunningTransitions();
            ArrayList<TransitionPort> currentTransitions = (ArrayList<TransitionPort>)runningTransitions.get((Object)this.mSceneRoot);
            ArrayList previousRunningTransitions = null;
            if (currentTransitions == null) {
                currentTransitions = new ArrayList<TransitionPort>();
                runningTransitions.put((Object)this.mSceneRoot, currentTransitions);
            } else if (currentTransitions.size() > 0) {
                previousRunningTransitions = new ArrayList(currentTransitions);
            }
            currentTransitions.add(this.mTransition);
            this.mTransition.addListener(new TransitionPort.TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(TransitionPort transition) {
                    ArrayList currentTransitions = (ArrayList)runningTransitions.get((Object)MultiListener.this.mSceneRoot);
                    currentTransitions.remove(transition);
                }
            });
            this.mTransition.captureValues(this.mSceneRoot, false);
            if (previousRunningTransitions != null) {
                for (TransitionPort runningTransition : previousRunningTransitions) {
                    runningTransition.resume((View)this.mSceneRoot);
                }
            }
            this.mTransition.playTransition(this.mSceneRoot);
            return true;
        }
    }
}

