/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.transition.AutoTransition;
import android.support.transition.Scene;
import android.support.transition.Transition;
import android.support.transition.TransitionListenerAdapter;
import android.support.v4.util.ArrayMap;
import android.support.v4.view.ViewCompat;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TransitionManager {
    private static final String LOG_TAG = "TransitionManager";
    private static Transition sDefaultTransition = new AutoTransition();
    private ArrayMap<Scene, Transition> mSceneTransitions = new ArrayMap();
    private ArrayMap<Scene, ArrayMap<Scene, Transition>> mScenePairTransitions = new ArrayMap();
    private static ThreadLocal<WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>>> sRunningTransitions = new ThreadLocal();
    private static ArrayList<ViewGroup> sPendingTransitions = new ArrayList();

    public void setTransition(@NonNull Scene scene, @Nullable Transition transition) {
        this.mSceneTransitions.put((Object)scene, (Object)transition);
    }

    public void setTransition(@NonNull Scene fromScene, @NonNull Scene toScene, @Nullable Transition transition) {
        ArrayMap sceneTransitionMap = (ArrayMap)this.mScenePairTransitions.get((Object)toScene);
        if (sceneTransitionMap == null) {
            sceneTransitionMap = new ArrayMap();
            this.mScenePairTransitions.put((Object)toScene, (Object)sceneTransitionMap);
        }
        sceneTransitionMap.put((Object)fromScene, (Object)transition);
    }

    private Transition getTransition(Scene scene) {
        Transition transition;
        ArrayMap sceneTransitionMap;
        Scene currScene;
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (sceneRoot != null && (currScene = Scene.getCurrentScene((View)sceneRoot)) != null && (sceneTransitionMap = (ArrayMap)this.mScenePairTransitions.get((Object)scene)) != null && (transition = (Transition)sceneTransitionMap.get((Object)currScene)) != null) {
            return transition;
        }
        transition = (Transition)this.mSceneTransitions.get((Object)scene);
        return transition != null ? transition : sDefaultTransition;
    }

    private static void changeScene(Scene scene, Transition transition) {
        ViewGroup sceneRoot = scene.getSceneRoot();
        if (!sPendingTransitions.contains(sceneRoot)) {
            if (transition == null) {
                scene.enter();
            } else {
                sPendingTransitions.add(sceneRoot);
                Transition transitionClone = transition.clone();
                transitionClone.setSceneRoot(sceneRoot);
                Scene oldScene = Scene.getCurrentScene((View)sceneRoot);
                if (oldScene != null && oldScene.isCreatedFromLayoutResource()) {
                    transitionClone.setCanRemoveViews(true);
                }
                TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
                scene.enter();
                TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
            }
        }
    }

    static ArrayMap<ViewGroup, ArrayList<Transition>> getRunningTransitions() {
        WeakReference<ArrayMap<ViewGroup, ArrayList<Transition>>> runningTransitions = sRunningTransitions.get();
        if (runningTransitions == null || runningTransitions.get() == null) {
            ArrayMap transitions = new ArrayMap();
            runningTransitions = new WeakReference<ArrayMap>(transitions);
            sRunningTransitions.set(runningTransitions);
        }
        return (ArrayMap)runningTransitions.get();
    }

    private static void sceneChangeRunTransition(ViewGroup sceneRoot, Transition transition) {
        if (transition != null && sceneRoot != null) {
            MultiListener listener = new MultiListener(transition, sceneRoot);
            sceneRoot.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
            sceneRoot.getViewTreeObserver().addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)listener);
        }
    }

    private static void sceneChangeSetup(ViewGroup sceneRoot, Transition transition) {
        Scene previousScene;
        ArrayList runningTransitions = (ArrayList)TransitionManager.getRunningTransitions().get((Object)sceneRoot);
        if (runningTransitions != null && runningTransitions.size() > 0) {
            for (Transition runningTransition : runningTransitions) {
                runningTransition.pause((View)sceneRoot);
            }
        }
        if (transition != null) {
            transition.captureValues(sceneRoot, true);
        }
        if ((previousScene = Scene.getCurrentScene((View)sceneRoot)) != null) {
            previousScene.exit();
        }
    }

    public void transitionTo(@NonNull Scene scene) {
        TransitionManager.changeScene(scene, this.getTransition(scene));
    }

    public static void go(@NonNull Scene scene) {
        TransitionManager.changeScene(scene, sDefaultTransition);
    }

    public static void go(@NonNull Scene scene, @Nullable Transition transition) {
        TransitionManager.changeScene(scene, transition);
    }

    public static void beginDelayedTransition(@NonNull ViewGroup sceneRoot) {
        TransitionManager.beginDelayedTransition(sceneRoot, null);
    }

    public static void beginDelayedTransition(@NonNull ViewGroup sceneRoot, @Nullable Transition transition) {
        if (!sPendingTransitions.contains(sceneRoot) && ViewCompat.isLaidOut((View)sceneRoot)) {
            sPendingTransitions.add(sceneRoot);
            if (transition == null) {
                transition = sDefaultTransition;
            }
            Transition transitionClone = transition.clone();
            TransitionManager.sceneChangeSetup(sceneRoot, transitionClone);
            Scene.setCurrentScene((View)sceneRoot, null);
            TransitionManager.sceneChangeRunTransition(sceneRoot, transitionClone);
        }
    }

    public static void endTransitions(ViewGroup sceneRoot) {
        sPendingTransitions.remove(sceneRoot);
        ArrayList runningTransitions = (ArrayList)TransitionManager.getRunningTransitions().get((Object)sceneRoot);
        if (runningTransitions != null && !runningTransitions.isEmpty()) {
            ArrayList copy = new ArrayList(runningTransitions);
            for (int i = copy.size() - 1; i >= 0; --i) {
                Transition transition = (Transition)copy.get(i);
                transition.forceToEnd(sceneRoot);
            }
        }
    }

    private static class MultiListener
    implements ViewTreeObserver.OnPreDrawListener,
    View.OnAttachStateChangeListener {
        Transition mTransition;
        ViewGroup mSceneRoot;

        MultiListener(Transition transition, ViewGroup sceneRoot) {
            this.mTransition = transition;
            this.mSceneRoot = sceneRoot;
        }

        private void removeListeners() {
            this.mSceneRoot.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
            this.mSceneRoot.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            this.removeListeners();
            sPendingTransitions.remove(this.mSceneRoot);
            ArrayList runningTransitions = (ArrayList)TransitionManager.getRunningTransitions().get((Object)this.mSceneRoot);
            if (runningTransitions != null && runningTransitions.size() > 0) {
                for (Transition runningTransition : runningTransitions) {
                    runningTransition.resume((View)this.mSceneRoot);
                }
            }
            this.mTransition.clearValues(true);
        }

        public boolean onPreDraw() {
            this.removeListeners();
            if (!sPendingTransitions.remove(this.mSceneRoot)) {
                return true;
            }
            final ArrayMap<ViewGroup, ArrayList<Transition>> runningTransitions = TransitionManager.getRunningTransitions();
            ArrayList<Transition> currentTransitions = (ArrayList<Transition>)runningTransitions.get((Object)this.mSceneRoot);
            ArrayList previousRunningTransitions = null;
            if (currentTransitions == null) {
                currentTransitions = new ArrayList<Transition>();
                runningTransitions.put((Object)this.mSceneRoot, currentTransitions);
            } else if (currentTransitions.size() > 0) {
                previousRunningTransitions = new ArrayList(currentTransitions);
            }
            currentTransitions.add(this.mTransition);
            this.mTransition.addListener(new TransitionListenerAdapter(){

                @Override
                public void onTransitionEnd(@NonNull Transition transition) {
                    ArrayList currentTransitions = (ArrayList)runningTransitions.get((Object)MultiListener.this.mSceneRoot);
                    currentTransitions.remove(transition);
                }
            });
            this.mTransition.captureValues(this.mSceneRoot, false);
            if (previousRunningTransitions != null) {
                for (Transition runningTransition : previousRunningTransitions) {
                    runningTransition.resume((View)this.mSceneRoot);
                }
            }
            this.mTransition.playTransition(this.mSceneRoot);
            return true;
        }
    }
}

