/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.graphics.Matrix;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.transition.R;
import android.support.transition.ViewOverlayApi14;
import android.support.transition.ViewOverlayImpl;
import android.support.transition.ViewUtilsImpl;
import android.support.transition.WindowIdApi14;
import android.support.transition.WindowIdImpl;
import android.view.View;
import android.view.ViewParent;

@RequiresApi(value=14)
class ViewUtilsApi14
implements ViewUtilsImpl {
    private float[] mMatrixValues;

    ViewUtilsApi14() {
    }

    @Override
    public ViewOverlayImpl getOverlay(@NonNull View view) {
        return ViewOverlayApi14.createFrom(view);
    }

    @Override
    public WindowIdImpl getWindowId(@NonNull View view) {
        return new WindowIdApi14(view.getWindowToken());
    }

    @Override
    public void setTransitionAlpha(@NonNull View view, float alpha) {
        Float savedAlpha = (Float)view.getTag(R.id.save_non_transition_alpha);
        if (savedAlpha != null) {
            view.setAlpha(savedAlpha.floatValue() * alpha);
        } else {
            view.setAlpha(alpha);
        }
    }

    @Override
    public float getTransitionAlpha(@NonNull View view) {
        Float savedAlpha = (Float)view.getTag(R.id.save_non_transition_alpha);
        if (savedAlpha != null) {
            return view.getAlpha() / savedAlpha.floatValue();
        }
        return view.getAlpha();
    }

    @Override
    public void saveNonTransitionAlpha(@NonNull View view) {
        if (view.getTag(R.id.save_non_transition_alpha) == null) {
            view.setTag(R.id.save_non_transition_alpha, (Object)Float.valueOf(view.getAlpha()));
        }
    }

    @Override
    public void clearNonTransitionAlpha(@NonNull View view) {
        if (view.getVisibility() == 0) {
            view.setTag(R.id.save_non_transition_alpha, null);
        }
    }

    @Override
    public void transformMatrixToGlobal(@NonNull View view, @NonNull Matrix matrix) {
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View vp = (View)parent;
            this.transformMatrixToGlobal(vp, matrix);
            matrix.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
        }
        matrix.preTranslate((float)view.getLeft(), (float)view.getTop());
        Matrix vm = view.getMatrix();
        if (!vm.isIdentity()) {
            matrix.preConcat(vm);
        }
    }

    @Override
    public void transformMatrixToLocal(@NonNull View view, @NonNull Matrix matrix) {
        Matrix inverted;
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View vp = (View)parent;
            this.transformMatrixToLocal(vp, matrix);
            matrix.postTranslate((float)vp.getScrollX(), (float)vp.getScrollY());
        }
        matrix.postTranslate((float)view.getLeft(), (float)view.getTop());
        Matrix vm = view.getMatrix();
        if (!vm.isIdentity() && vm.invert(inverted = new Matrix())) {
            matrix.postConcat(inverted);
        }
    }

    @Override
    public void setAnimationMatrix(@NonNull View view, Matrix matrix) {
        if (matrix == null || matrix.isIdentity()) {
            view.setPivotX((float)(view.getWidth() / 2));
            view.setPivotY((float)(view.getHeight() / 2));
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
            view.setRotation(0.0f);
        } else {
            float[] values = this.mMatrixValues;
            if (values == null) {
                this.mMatrixValues = values = new float[9];
            }
            matrix.getValues(values);
            float sin = values[3];
            float cos = (float)Math.sqrt(1.0f - sin * sin) * (float)(values[0] < 0.0f ? -1 : 1);
            float rotation = (float)Math.toDegrees(Math.atan2(sin, cos));
            float scaleX = values[0] / cos;
            float scaleY = values[4] / cos;
            float dx = values[2];
            float dy = values[5];
            view.setPivotX(0.0f);
            view.setPivotY(0.0f);
            view.setTranslationX(dx);
            view.setTranslationY(dy);
            view.setRotation(rotation);
            view.setScaleX(scaleX);
            view.setScaleY(scaleY);
        }
    }

    @Override
    public void setLeftTopRightBottom(View v, int left, int top, int right, int bottom) {
        v.setLeft(left);
        v.setTop(top);
        v.setRight(right);
        v.setBottom(bottom);
    }
}

