/*
 * Decompiled with CFR 0.152.
 */
package android.support.transition;

import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.transition.ViewGroupOverlayApi18;
import android.support.transition.ViewGroupOverlayImpl;
import android.support.transition.ViewGroupUtilsApi14;
import android.util.Log;
import android.view.ViewGroup;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RequiresApi(value=18)
class ViewGroupUtilsApi18
extends ViewGroupUtilsApi14 {
    private static final String TAG = "ViewUtilsApi18";
    private static Method sSuppressLayoutMethod;
    private static boolean sSuppressLayoutMethodFetched;

    ViewGroupUtilsApi18() {
    }

    @Override
    public ViewGroupOverlayImpl getOverlay(@NonNull ViewGroup group) {
        return new ViewGroupOverlayApi18(group);
    }

    @Override
    public void suppressLayout(@NonNull ViewGroup group, boolean suppress) {
        this.fetchSuppressLayoutMethod();
        if (sSuppressLayoutMethod != null) {
            try {
                sSuppressLayoutMethod.invoke((Object)group, suppress);
            }
            catch (IllegalAccessException e) {
                Log.i((String)TAG, (String)"Failed to invoke suppressLayout method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.i((String)TAG, (String)"Error invoking suppressLayout method", (Throwable)e);
            }
        }
    }

    private void fetchSuppressLayoutMethod() {
        if (!sSuppressLayoutMethodFetched) {
            try {
                sSuppressLayoutMethod = ViewGroup.class.getDeclaredMethod("suppressLayout", Boolean.TYPE);
                sSuppressLayoutMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve suppressLayout method", (Throwable)e);
            }
            sSuppressLayoutMethodFetched = true;
        }
    }
}

