/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.apkzlib.utils;

import com.android.apksig.internal.apk.ApkSigningBlockUtils;
import com.android.apksig.internal.util.Pair;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public final class SigningBlockUtils {
    private static final int MAGIC_NUM_BYTES = 16;
    private static final int BLOCK_LENGTH_NUM_BYTES = 8;
    static final int SIZE_OF_BLOCK_NUM_BYTES = 8;
    static final int BLOCK_ID_NUM_BYTES = 4;
    static final int ANDROID_COMMON_PAGE_ALIGNMENT_NUM_BYTES = 4096;
    static final int VERITY_PADDING_BLOCK_ID = 1114793335;

    public static byte[] addToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        if (blockValue == null || blockValue.length == 0) {
            return signingBlock;
        }
        if (signingBlock == null || signingBlock.length == 0) {
            return SigningBlockUtils.createSigningBlock(blockValue, blockId);
        }
        return SigningBlockUtils.appendToSigningBlock(signingBlock, blockValue, blockId);
    }

    private static byte[] appendToSigningBlock(byte[] signingBlock, byte[] blockValue, int blockId) throws IOException {
        ImmutableList entries = ImmutableList.builder().addAll(SigningBlockUtils.extractAllSigners(DataSources.asDataSource((ByteBuffer)ByteBuffer.wrap(signingBlock)))).add((Object)Pair.of((Object)blockValue, (Object)blockId)).build();
        return ApkSigningBlockUtils.generateApkSigningBlock((List)entries);
    }

    private static byte[] createSigningBlock(byte[] blockValue, int blockId) {
        return ApkSigningBlockUtils.generateApkSigningBlock((List)ImmutableList.of((Object)Pair.of((Object)blockValue, (Object)blockId)));
    }

    private static ImmutableList<Pair<byte[], Integer>> extractAllSigners(DataSource signingBlock) throws IOException {
        long wholeBlockSize = signingBlock.size();
        DataSource lengthPrefixedIdValuePairsSource = signingBlock.slice(8L, wholeBlockSize - 16L - 16L);
        int lengthAndIdByteCount = 12;
        ByteBuffer lengthAndId = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        ImmutableList.Builder idValuePairs = ImmutableList.builder();
        int index = 0;
        while ((long)index <= lengthPrefixedIdValuePairsSource.size() - 12L) {
            lengthPrefixedIdValuePairsSource.copyTo((long)index, 12, lengthAndId);
            lengthAndId.flip();
            int blockLength = Ints.checkedCast((long)lengthAndId.getLong());
            int id = lengthAndId.getInt();
            lengthAndId.clear();
            if (id != 1114793335) {
                int blockValueSize = blockLength - 4;
                ByteBuffer blockValue = ByteBuffer.allocate(blockValueSize);
                lengthPrefixedIdValuePairsSource.copyTo((long)(index + 8 + 4), blockValueSize, blockValue);
                idValuePairs.add((Object)Pair.of((Object)blockValue.array(), (Object)id));
            }
            index += blockLength + 8;
        }
        return idValuePairs.build();
    }

    private SigningBlockUtils() {
    }
}

