/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.internal.CommandLineRunner;
import com.android.ide.common.internal.LoggedErrorException;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ApkInfoParser {
    private static final Pattern PATTERN = Pattern.compile("^package: name='([^']+)' versionCode='([0-9]*)' versionName='([^']*)'.*$");
    @NonNull
    private final File mAaptFile;
    @NonNull
    private final CommandLineRunner mCommandLineRunner;

    public ApkInfoParser(@NonNull File aaptFile, @NonNull CommandLineRunner commandLineRunner) {
        this.mAaptFile = aaptFile;
        this.mCommandLineRunner = commandLineRunner;
    }

    @NonNull
    public ApkInfo parseApk(@NonNull File apkFile) throws InterruptedException, LoggedErrorException, IOException {
        if (!this.mAaptFile.isFile()) {
            throw new IllegalStateException("aapt is missing from location: " + this.mAaptFile.getAbsolutePath());
        }
        return ApkInfoParser.getApkInfo(this.getAaptOutput(apkFile));
    }

    @NonNull
    static ApkInfo getApkInfo(@NonNull List<String> aaptOutput) {
        int intVersionCode;
        String pkgName = null;
        String versionCode = null;
        String versionName = null;
        for (String line : aaptOutput) {
            Matcher m = PATTERN.matcher(line);
            if (!m.matches()) continue;
            pkgName = m.group(1);
            versionCode = m.group(2);
            versionName = m.group(3);
            break;
        }
        if (pkgName == null) {
            throw new RuntimeException("Failed to find apk information with aapt");
        }
        try {
            intVersionCode = Integer.parseInt(versionCode);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(String.format("Invalid versionCode specified '%1$s'", versionCode));
        }
        return new ApkInfo(pkgName, intVersionCode, versionName);
    }

    @NonNull
    private List<String> getAaptOutput(@NonNull File apkFile) throws IOException, InterruptedException, LoggedErrorException {
        ArrayList command = Lists.newArrayList();
        command.add(this.mAaptFile.getAbsolutePath());
        command.add("dump");
        command.add("badging");
        command.add(apkFile.getPath());
        final ArrayList aaptOutput = Lists.newArrayList();
        this.mCommandLineRunner.runCmdLine((List)command, new CommandLineRunner.CommandLineOutput(){

            public void out(@Nullable String line) {
                if (line != null) {
                    aaptOutput.add(line);
                }
            }

            public void err(@Nullable String line) {
                super.err(line);
            }
        }, null);
        return aaptOutput;
    }

    public static final class ApkInfo {
        @NonNull
        private final String mPackageName;
        @Nullable
        private final Integer mVersionCode;
        @Nullable
        private final String mVersionName;

        private ApkInfo(@NonNull String packageName, int versionCode, String versionName) {
            this.mPackageName = packageName;
            this.mVersionCode = versionCode;
            this.mVersionName = versionName;
        }

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        @Nullable
        public Integer getVersionCode() {
            return this.mVersionCode;
        }

        @Nullable
        public String getVersionName() {
            return this.mVersionName;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("packageName", (Object)this.mPackageName).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).toString();
        }
    }
}

