/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.core;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.builder.internal.BaseConfigImpl;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.BaseConfig;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.SigningConfig;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class DefaultProductFlavor
extends BaseConfigImpl
implements ProductFlavor {
    private static final long serialVersionUID = 1L;
    private final String mName;
    private ApiVersion mMinSdkVersion;
    private ApiVersion mTargetSdkVersion;
    private Integer mMaxSdkVersion;
    private Integer mRenderscriptTargetApi;
    private Boolean mRenderscriptSupportModeEnabled;
    private Boolean mRenderscriptNdkModeEnabled;
    private Integer mVersionCode;
    private String mVersionName;
    private String mApplicationId;
    private String mTestApplicationId;
    private String mTestInstrumentationRunner;
    private Boolean mTestHandleProfiling;
    private Boolean mTestFunctionalTest;
    private SigningConfig mSigningConfig;
    private Set<String> mResourceConfiguration;

    public DefaultProductFlavor(@NonNull String name) {
        this.mName = name;
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    @NonNull
    public ProductFlavor setApplicationId(String applicationId) {
        this.mApplicationId = applicationId;
        return this;
    }

    @Nullable
    public String getApplicationId() {
        return this.mApplicationId;
    }

    @NonNull
    public ProductFlavor setVersionCode(Integer versionCode) {
        this.mVersionCode = versionCode;
        return this;
    }

    @Nullable
    public Integer getVersionCode() {
        return this.mVersionCode;
    }

    @NonNull
    public ProductFlavor setVersionName(String versionName) {
        this.mVersionName = versionName;
        return this;
    }

    @Nullable
    public String getVersionName() {
        return this.mVersionName;
    }

    @NonNull
    public ProductFlavor setMinSdkVersion(ApiVersion minSdkVersion) {
        this.mMinSdkVersion = minSdkVersion;
        return this;
    }

    public ApiVersion getMinSdkVersion() {
        return this.mMinSdkVersion;
    }

    @NonNull
    public ProductFlavor setTargetSdkVersion(ApiVersion targetSdkVersion) {
        this.mTargetSdkVersion = targetSdkVersion;
        return this;
    }

    public ApiVersion getTargetSdkVersion() {
        return this.mTargetSdkVersion;
    }

    @NonNull
    public ProductFlavor setMaxSdkVersion(Integer maxSdkVersion) {
        this.mMaxSdkVersion = maxSdkVersion;
        return this;
    }

    public Integer getMaxSdkVersion() {
        return this.mMaxSdkVersion;
    }

    @Nullable
    public Integer getRenderscriptTargetApi() {
        return this.mRenderscriptTargetApi;
    }

    public void setRenderscriptTargetApi(Integer renderscriptTargetApi) {
        this.mRenderscriptTargetApi = renderscriptTargetApi;
    }

    @Nullable
    public Boolean getRenderscriptSupportModeEnabled() {
        return this.mRenderscriptSupportModeEnabled;
    }

    public ProductFlavor setRenderscriptSupportModeEnabled(Boolean renderscriptSupportMode) {
        this.mRenderscriptSupportModeEnabled = renderscriptSupportMode;
        return this;
    }

    @Nullable
    public Boolean getRenderscriptNdkModeEnabled() {
        return this.mRenderscriptNdkModeEnabled;
    }

    public ProductFlavor setRenderscriptNdkModeEnabled(Boolean renderscriptNdkMode) {
        this.mRenderscriptNdkModeEnabled = renderscriptNdkMode;
        return this;
    }

    @NonNull
    public ProductFlavor setTestApplicationId(String applicationId) {
        this.mTestApplicationId = applicationId;
        return this;
    }

    @Nullable
    public String getTestApplicationId() {
        return this.mTestApplicationId;
    }

    @NonNull
    public ProductFlavor setTestInstrumentationRunner(String testInstrumentationRunner) {
        this.mTestInstrumentationRunner = testInstrumentationRunner;
        return this;
    }

    @Nullable
    public String getTestInstrumentationRunner() {
        return this.mTestInstrumentationRunner;
    }

    @Nullable
    public Boolean getTestHandleProfiling() {
        return this.mTestHandleProfiling;
    }

    @NonNull
    public ProductFlavor setTestHandleProfiling(boolean handleProfiling) {
        this.mTestHandleProfiling = handleProfiling;
        return this;
    }

    @Nullable
    public Boolean getTestFunctionalTest() {
        return this.mTestFunctionalTest;
    }

    @NonNull
    public ProductFlavor setTestFunctionalTest(boolean functionalTest) {
        this.mTestFunctionalTest = functionalTest;
        return this;
    }

    @Nullable
    public SigningConfig getSigningConfig() {
        return this.mSigningConfig;
    }

    @NonNull
    public ProductFlavor setSigningConfig(SigningConfig signingConfig) {
        this.mSigningConfig = signingConfig;
        return this;
    }

    public void addResourceConfiguration(@NonNull String configuration) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.add(configuration);
    }

    public void addResourceConfigurations(String ... configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(Arrays.asList(configurations));
    }

    public void addResourceConfigurations(@NonNull Collection<String> configurations) {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        this.mResourceConfiguration.addAll(configurations);
    }

    @NonNull
    public Collection<String> getResourceConfigurations() {
        if (this.mResourceConfiguration == null) {
            this.mResourceConfiguration = Sets.newHashSet();
        }
        return this.mResourceConfiguration;
    }

    @NonNull
    static ProductFlavor mergeFlavors(@NonNull ProductFlavor base, @NonNull ProductFlavor overlay) {
        DefaultProductFlavor flavor = new DefaultProductFlavor("");
        flavor.mMinSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMinSdkVersion(), base.getMinSdkVersion());
        flavor.mTargetSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getTargetSdkVersion(), base.getTargetSdkVersion());
        flavor.mMaxSdkVersion = DefaultProductFlavor.chooseNotNull(overlay.getMaxSdkVersion(), base.getMaxSdkVersion());
        flavor.mRenderscriptTargetApi = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptTargetApi(), base.getRenderscriptTargetApi());
        flavor.mRenderscriptSupportModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptSupportModeEnabled(), base.getRenderscriptSupportModeEnabled());
        flavor.mRenderscriptNdkModeEnabled = DefaultProductFlavor.chooseNotNull(overlay.getRenderscriptNdkModeEnabled(), base.getRenderscriptNdkModeEnabled());
        flavor.mVersionCode = DefaultProductFlavor.chooseNotNull(overlay.getVersionCode(), base.getVersionCode());
        flavor.mVersionName = DefaultProductFlavor.chooseNotNull(overlay.getVersionName(), base.getVersionName());
        flavor.mApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getApplicationId(), base.getApplicationId());
        flavor.mTestApplicationId = DefaultProductFlavor.chooseNotNull(overlay.getTestApplicationId(), base.getTestApplicationId());
        flavor.mTestInstrumentationRunner = DefaultProductFlavor.chooseNotNull(overlay.getTestInstrumentationRunner(), base.getTestInstrumentationRunner());
        flavor.mTestHandleProfiling = DefaultProductFlavor.chooseNotNull(overlay.getTestHandleProfiling(), base.getTestHandleProfiling());
        flavor.mTestFunctionalTest = DefaultProductFlavor.chooseNotNull(overlay.getTestFunctionalTest(), base.getTestFunctionalTest());
        flavor.mSigningConfig = DefaultProductFlavor.chooseNotNull(overlay.getSigningConfig(), base.getSigningConfig());
        flavor.addResourceConfigurations(base.getResourceConfigurations());
        flavor.addResourceConfigurations(overlay.getResourceConfigurations());
        flavor.addManifestPlaceHolders(base.getManifestPlaceholders());
        flavor.addManifestPlaceHolders(overlay.getManifestPlaceholders());
        flavor.addResValues(base.getResValues());
        flavor.addResValues(overlay.getResValues());
        flavor.addBuildConfigFields(base.getBuildConfigFields());
        flavor.addBuildConfigFields(overlay.getBuildConfigFields());
        flavor.setMultiDexEnabled(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexEnabled(), base.getMultiDexEnabled()));
        flavor.setMultiDexKeepFile(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepFile(), base.getMultiDexKeepFile()));
        flavor.setMultiDexKeepProguard(DefaultProductFlavor.chooseNotNull(overlay.getMultiDexKeepProguard(), base.getMultiDexKeepProguard()));
        return flavor;
    }

    @NonNull
    static ProductFlavor clone(@NonNull ProductFlavor productFlavor) {
        DefaultProductFlavor flavor = new DefaultProductFlavor(productFlavor.getName());
        flavor._initWith((BaseConfig)productFlavor);
        flavor.mMinSdkVersion = productFlavor.getMinSdkVersion();
        flavor.mTargetSdkVersion = productFlavor.getTargetSdkVersion();
        flavor.mMaxSdkVersion = productFlavor.getMaxSdkVersion();
        flavor.mRenderscriptTargetApi = productFlavor.getRenderscriptTargetApi();
        flavor.mRenderscriptSupportModeEnabled = productFlavor.getRenderscriptSupportModeEnabled();
        flavor.mRenderscriptNdkModeEnabled = productFlavor.getRenderscriptNdkModeEnabled();
        flavor.mVersionCode = productFlavor.getVersionCode();
        flavor.mVersionName = productFlavor.getVersionName();
        flavor.mApplicationId = productFlavor.getApplicationId();
        flavor.mTestApplicationId = productFlavor.getTestApplicationId();
        flavor.mTestInstrumentationRunner = productFlavor.getTestInstrumentationRunner();
        flavor.mTestHandleProfiling = productFlavor.getTestHandleProfiling();
        flavor.mTestFunctionalTest = productFlavor.getTestFunctionalTest();
        flavor.mSigningConfig = productFlavor.getSigningConfig();
        flavor.addResourceConfigurations(productFlavor.getResourceConfigurations());
        flavor.addManifestPlaceHolders(productFlavor.getManifestPlaceholders());
        flavor.addResValues(productFlavor.getResValues());
        flavor.addBuildConfigFields(productFlavor.getBuildConfigFields());
        flavor.setMultiDexEnabled(productFlavor.getMultiDexEnabled());
        flavor.setMultiDexKeepFile(productFlavor.getMultiDexKeepFile());
        flavor.setMultiDexKeepProguard(productFlavor.getMultiDexKeepProguard());
        return flavor;
    }

    private static <T> T chooseNotNull(T overlay, T base) {
        return overlay != null ? overlay : base;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultProductFlavor that = (DefaultProductFlavor)o;
        if (this.mApplicationId != null ? !this.mApplicationId.equals(that.mApplicationId) : that.mApplicationId != null) {
            return false;
        }
        if (this.mMaxSdkVersion != null ? !this.mMaxSdkVersion.equals(that.mMaxSdkVersion) : that.mMaxSdkVersion != null) {
            return false;
        }
        if (this.mMinSdkVersion != null ? !this.mMinSdkVersion.equals(that.mMinSdkVersion) : that.mMinSdkVersion != null) {
            return false;
        }
        if (!this.mName.equals(that.mName)) {
            return false;
        }
        if (this.mRenderscriptNdkModeEnabled != null ? !this.mRenderscriptNdkModeEnabled.equals(that.mRenderscriptNdkModeEnabled) : that.mRenderscriptNdkModeEnabled != null) {
            return false;
        }
        if (this.mRenderscriptSupportModeEnabled != null ? !this.mRenderscriptSupportModeEnabled.equals(that.mRenderscriptSupportModeEnabled) : that.mRenderscriptSupportModeEnabled != null) {
            return false;
        }
        if (this.mRenderscriptTargetApi != null ? !this.mRenderscriptTargetApi.equals(that.mRenderscriptTargetApi) : that.mRenderscriptTargetApi != null) {
            return false;
        }
        if (this.mResourceConfiguration != null ? !((Object)this.mResourceConfiguration).equals(that.mResourceConfiguration) : that.mResourceConfiguration != null) {
            return false;
        }
        if (this.mSigningConfig != null ? !this.mSigningConfig.equals(that.mSigningConfig) : that.mSigningConfig != null) {
            return false;
        }
        if (this.mTargetSdkVersion != null ? !this.mTargetSdkVersion.equals(that.mTargetSdkVersion) : that.mTargetSdkVersion != null) {
            return false;
        }
        if (this.mTestApplicationId != null ? !this.mTestApplicationId.equals(that.mTestApplicationId) : that.mTestApplicationId != null) {
            return false;
        }
        if (this.mTestFunctionalTest != null ? !this.mTestFunctionalTest.equals(that.mTestFunctionalTest) : that.mTestFunctionalTest != null) {
            return false;
        }
        if (this.mTestHandleProfiling != null ? !this.mTestHandleProfiling.equals(that.mTestHandleProfiling) : that.mTestHandleProfiling != null) {
            return false;
        }
        if (this.mTestInstrumentationRunner != null ? !this.mTestInstrumentationRunner.equals(that.mTestInstrumentationRunner) : that.mTestInstrumentationRunner != null) {
            return false;
        }
        if (this.mVersionCode != null ? !this.mVersionCode.equals(that.mVersionCode) : that.mVersionCode != null) {
            return false;
        }
        return !(this.mVersionName != null ? !this.mVersionName.equals(that.mVersionName) : that.mVersionName != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + (this.mMinSdkVersion != null ? this.mMinSdkVersion.hashCode() : 0);
        result = 31 * result + (this.mTargetSdkVersion != null ? this.mTargetSdkVersion.hashCode() : 0);
        result = 31 * result + (this.mMaxSdkVersion != null ? this.mMaxSdkVersion.hashCode() : 0);
        result = 31 * result + (this.mRenderscriptTargetApi != null ? this.mRenderscriptTargetApi.hashCode() : 0);
        result = 31 * result + (this.mRenderscriptSupportModeEnabled != null ? this.mRenderscriptSupportModeEnabled.hashCode() : 0);
        result = 31 * result + (this.mRenderscriptNdkModeEnabled != null ? this.mRenderscriptNdkModeEnabled.hashCode() : 0);
        result = 31 * result + (this.mVersionCode != null ? this.mVersionCode.hashCode() : 0);
        result = 31 * result + (this.mVersionName != null ? this.mVersionName.hashCode() : 0);
        result = 31 * result + (this.mApplicationId != null ? this.mApplicationId.hashCode() : 0);
        result = 31 * result + (this.mTestApplicationId != null ? this.mTestApplicationId.hashCode() : 0);
        result = 31 * result + (this.mTestInstrumentationRunner != null ? this.mTestInstrumentationRunner.hashCode() : 0);
        result = 31 * result + (this.mTestHandleProfiling != null ? this.mTestHandleProfiling.hashCode() : 0);
        result = 31 * result + (this.mTestFunctionalTest != null ? this.mTestFunctionalTest.hashCode() : 0);
        result = 31 * result + (this.mSigningConfig != null ? this.mSigningConfig.hashCode() : 0);
        result = 31 * result + (this.mResourceConfiguration != null ? ((Object)this.mResourceConfiguration).hashCode() : 0);
        return result;
    }

    @Override
    @NonNull
    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.mName).add("minSdkVersion", (Object)this.mMinSdkVersion).add("targetSdkVersion", (Object)this.mTargetSdkVersion).add("renderscriptTargetApi", (Object)this.mRenderscriptTargetApi).add("renderscriptSupportModeEnabled", (Object)this.mRenderscriptSupportModeEnabled).add("renderscriptNdkModeEnabled", (Object)this.mRenderscriptNdkModeEnabled).add("versionCode", (Object)this.mVersionCode).add("versionName", (Object)this.mVersionName).add("applicationId", (Object)this.mApplicationId).add("testApplicationId", (Object)this.mTestApplicationId).add("testInstrumentationRunner", (Object)this.mTestInstrumentationRunner).add("testHandleProfiling", (Object)this.mTestHandleProfiling).add("testFunctionalTest", (Object)this.mTestFunctionalTest).add("signingConfig", (Object)this.mSigningConfig).add("resConfig", this.mResourceConfiguration).add("mBuildConfigFields", this.getBuildConfigFields()).add("mResValues", this.getResValues()).add("mProguardFiles", (Object)this.getProguardFiles()).add("mConsumerProguardFiles", (Object)this.getConsumerProguardFiles()).add("mManifestPlaceholders", this.getManifestPlaceholders()).toString();
    }
}

