/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.tasks;

import com.google.common.base.Objects;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class BooleanLatch {
    private final Sync sync = new Sync();

    public boolean isSignalled() {
        return this.sync.isSignalled();
    }

    public void signal() {
        this.sync.releaseShared(1);
    }

    public void await() throws InterruptedException {
        this.sync.acquireSharedInterruptibly(1);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("signaled", this.isSignalled()).toString();
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        private Sync() {
        }

        boolean isSignalled() {
            return this.getState() != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.isSignalled() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.setState(1);
            return true;
        }
    }
}

