/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.utils;

import com.google.common.base.Objects;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CachedFileContents<T> {
    @Nonnull
    private File mFile;
    private long mLastClosed;
    private long mSize;
    @Nullable
    private HashCode mHash;
    @Nullable
    private T mCache;

    public CachedFileContents(@Nonnull File file) {
        this.mFile = file;
    }

    public void closed(@Nullable T cache) {
        this.mCache = cache;
        this.mLastClosed = this.mFile.lastModified();
        this.mSize = this.mFile.length();
        this.mHash = this.hashFile();
    }

    public boolean isValid() {
        boolean valid = true;
        if (!this.mFile.exists()) {
            valid = false;
        }
        if (valid && this.mFile.lastModified() != this.mLastClosed) {
            valid = false;
        }
        if (valid && this.mFile.length() != this.mSize) {
            valid = false;
        }
        if (valid && !Objects.equal((Object)this.mHash, (Object)this.hashFile())) {
            valid = false;
        }
        if (!valid) {
            this.mCache = null;
        }
        return valid;
    }

    @Nullable
    public T getCache() {
        return this.mCache;
    }

    @Nullable
    private HashCode hashFile() {
        try {
            return Files.hash((File)this.mFile, (HashFunction)Hashing.crc32());
        }
        catch (IOException e) {
            return null;
        }
    }

    @Nonnull
    public File getFile() {
        return this.mFile;
    }
}

