/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip.compress;

import com.android.apkzlib.zip.CompressionMethod;
import com.android.apkzlib.zip.CompressionResult;
import com.android.apkzlib.zip.compress.ExecutorCompressor;
import com.android.apkzlib.zip.utils.ByteTracker;
import com.android.apkzlib.zip.utils.CloseableByteSource;
import com.android.apkzlib.zip.utils.CloseableDelegateByteSource;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.concurrent.Executor;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.annotation.Nonnull;

public class DeflateExecutionCompressor
extends ExecutorCompressor {
    private final int mLevel;
    @Nonnull
    private final ByteTracker mTracker;

    public DeflateExecutionCompressor(@Nonnull Executor executor, @Nonnull ByteTracker tracker, int level) {
        super(executor);
        this.mLevel = level;
        this.mTracker = tracker;
    }

    @Override
    @Nonnull
    protected CompressionResult immediateCompress(@Nonnull CloseableByteSource source) throws Exception {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Deflater deflater = new Deflater(this.mLevel, true);
        try (DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)output, deflater);){
            dos.write(source.read());
        }
        CloseableDelegateByteSource result = this.mTracker.fromStream(output);
        if (result.size() >= source.size()) {
            return new CompressionResult(source, CompressionMethod.STORE, source.size());
        }
        return new CompressionResult(result, CompressionMethod.DEFLATE, result.size());
    }
}

