/*
 * Decompiled with CFR 0.152.
 */
package com.android.apkzlib.zip;

import com.android.apkzlib.zip.CentralDirectoryHeader;
import com.android.apkzlib.zip.CentralDirectoryHeaderCompressInfo;
import com.android.apkzlib.zip.CompressionMethod;
import com.android.apkzlib.zip.DataDescriptorType;
import com.android.apkzlib.zip.EncodeUtils;
import com.android.apkzlib.zip.ExtraField;
import com.android.apkzlib.zip.InflaterByteSource;
import com.android.apkzlib.zip.ProcessedAndRawByteSources;
import com.android.apkzlib.zip.StoredEntryType;
import com.android.apkzlib.zip.ZFile;
import com.android.apkzlib.zip.ZipField;
import com.android.apkzlib.zip.ZipFieldInvariant;
import com.android.apkzlib.zip.ZipFieldInvariantNonNegative;
import com.android.apkzlib.zip.utils.CloseableByteSource;
import com.android.apkzlib.zip.utils.CloseableDelegateByteSource;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StoredEntry {
    static final Comparator<StoredEntry> COMPARE_BY_NAME = (o1, o2) -> {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String name1 = o1.getCentralDirectoryHeader().getName();
        String name2 = o2.getCentralDirectoryHeader().getName();
        return name1.compareTo(name2);
    };
    private static final int DATA_DESC_SIGNATURE = 134695760;
    private static final ZipField.F4 F_LOCAL_SIGNATURE = new ZipField.F4(0, 67324752L, "Signature");
    private static final ZipField.F2 F_VERSION_EXTRACT = new ZipField.F2(F_LOCAL_SIGNATURE.endOffset(), "Version to extract", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_GP_BIT = new ZipField.F2(F_VERSION_EXTRACT.endOffset(), "GP bit flag", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_METHOD = new ZipField.F2(F_GP_BIT.endOffset(), "Compression method", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_LAST_MOD_TIME = new ZipField.F2(F_METHOD.endOffset(), "Last modification time", new ZipFieldInvariant[0]);
    private static final ZipField.F2 F_LAST_MOD_DATE = new ZipField.F2(F_LAST_MOD_TIME.endOffset(), "Last modification date", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_CRC32 = new ZipField.F4(F_LAST_MOD_DATE.endOffset(), "CRC32", new ZipFieldInvariant[0]);
    private static final ZipField.F4 F_COMPRESSED_SIZE = new ZipField.F4(F_CRC32.endOffset(), "Compressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F4 F_UNCOMPRESSED_SIZE = new ZipField.F4(F_COMPRESSED_SIZE.endOffset(), "Uncompressed size", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_FILE_NAME_LENGTH = new ZipField.F2(F_UNCOMPRESSED_SIZE.endOffset(), "@File name length", new ZipFieldInvariantNonNegative());
    private static final ZipField.F2 F_EXTRA_LENGTH = new ZipField.F2(F_FILE_NAME_LENGTH.endOffset(), "Extra length", new ZipFieldInvariantNonNegative());
    static final int FIXED_LOCAL_FILE_HEADER_SIZE = F_EXTRA_LENGTH.endOffset();
    @Nonnull
    private StoredEntryType mType;
    @Nonnull
    private CentralDirectoryHeader mCdh;
    @Nonnull
    private ZFile mFile;
    private boolean mDeleted;
    @Nonnull
    private ExtraField mLocalExtra;
    @Nonnull
    private DataDescriptorType mDataDescriptorType;
    @Nonnull
    private ProcessedAndRawByteSources mSource;

    StoredEntry(@Nonnull CentralDirectoryHeader header, @Nonnull ZFile file, @Nullable ProcessedAndRawByteSources source) throws IOException {
        this.mCdh = header;
        this.mFile = file;
        this.mDeleted = false;
        if (header.getOffset() >= 0L) {
            this.mLocalExtra = new ExtraField();
            this.readLocalHeader();
            Preconditions.checkArgument((source == null ? 1 : 0) != 0, (Object)"Source was defined but contents already exist on file.");
            this.mSource = this.createSourceFromZip(this.mCdh.getOffset());
        } else {
            this.mLocalExtra = new ExtraField();
            Preconditions.checkNotNull((Object)source, (Object)"Source was not defined, but contents are not on file.");
            this.mSource = source;
        }
        if (this.mCdh.getName().endsWith(Character.toString('/'))) {
            this.mType = StoredEntryType.DIRECTORY;
            Verify.verify((boolean)this.mSource.getProcessedByteSource().isEmpty(), (String)"Directory source is not empty.", (Object[])new Object[0]);
            Verify.verify((this.mCdh.getCrc32() == 0L ? 1 : 0) != 0, (String)"Directory has CRC32 = %s.", (Object[])new Object[]{this.mCdh.getCrc32()});
            Verify.verify((this.mCdh.getUncompressedSize() == 0L ? 1 : 0) != 0, (String)"Directory has uncompressed size = %s.", (Object[])new Object[]{this.mCdh.getUncompressedSize()});
            long compressedSize = this.mCdh.getCompressionInfoWithWait().getCompressedSize();
            Verify.verify((compressedSize == 0L || compressedSize == 2L ? 1 : 0) != 0, (String)"Directory has compressed size = %s.", (Object[])new Object[]{compressedSize});
        } else {
            this.mType = StoredEntryType.FILE;
        }
        this.mDataDescriptorType = DataDescriptorType.NO_DATA_DESCRIPTOR;
        if (header.getGpBit().isDeferredCrc()) {
            Verify.verify((header.getOffset() >= 0L ? 1 : 0) != 0, (String)"Files that are not on disk cannot have the deferred CRC bit set.", (Object[])new Object[0]);
            try {
                this.readDataDescriptorRecord();
            }
            catch (IOException e) {
                throw new IOException("Failed to read data descriptor record.", e);
            }
        }
    }

    public int getLocalHeaderSize() {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return FIXED_LOCAL_FILE_HEADER_SIZE + this.mCdh.getEncodedFileName().length + this.mLocalExtra.size();
    }

    long getInFileSize() throws IOException {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return this.mCdh.getCompressionInfoWithWait().getCompressedSize() + (long)this.getLocalHeaderSize() + (long)this.mDataDescriptorType.size;
    }

    @Nonnull
    public InputStream open() throws IOException {
        return this.mSource.getProcessedByteSource().openStream();
    }

    @Nonnull
    public byte[] read() throws IOException {
        try (InputStream is = this.open();){
            byte[] byArray = ByteStreams.toByteArray((InputStream)is);
            return byArray;
        }
    }

    @Nonnull
    public StoredEntryType getType() {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        return this.mType;
    }

    public void delete() throws IOException {
        this.delete(true);
    }

    void delete(boolean notify) throws IOException {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
        this.mFile.delete(this, notify);
        this.mDeleted = true;
        this.mSource.close();
    }

    @Nonnull
    public CentralDirectoryHeader getCentralDirectoryHeader() {
        return this.mCdh;
    }

    private void readLocalHeader() throws IOException {
        byte[] localHeader = new byte[FIXED_LOCAL_FILE_HEADER_SIZE];
        this.mFile.directFullyRead(this.mCdh.getOffset(), localHeader);
        CentralDirectoryHeaderCompressInfo compressInfo = this.mCdh.getCompressionInfoWithWait();
        ByteBuffer bytes = ByteBuffer.wrap(localHeader);
        F_LOCAL_SIGNATURE.verify(bytes);
        F_VERSION_EXTRACT.verify(bytes, compressInfo.getVersionExtract());
        F_GP_BIT.verify(bytes, this.mCdh.getGpBit().getValue());
        F_METHOD.verify(bytes, compressInfo.getMethod().methodCode);
        if (this.mFile.areTimestampsIgnored()) {
            F_LAST_MOD_TIME.skip(bytes);
            F_LAST_MOD_DATE.skip(bytes);
        } else {
            F_LAST_MOD_TIME.verify(bytes, this.mCdh.getLastModTime());
            F_LAST_MOD_DATE.verify(bytes, this.mCdh.getLastModDate());
        }
        if (this.mCdh.getGpBit().isDeferredCrc()) {
            F_CRC32.skip(bytes);
            F_COMPRESSED_SIZE.skip(bytes);
            F_UNCOMPRESSED_SIZE.skip(bytes);
        } else {
            F_CRC32.verify(bytes, this.mCdh.getCrc32());
            F_COMPRESSED_SIZE.verify(bytes, compressInfo.getCompressedSize());
            F_UNCOMPRESSED_SIZE.verify(bytes, this.mCdh.getUncompressedSize());
        }
        F_FILE_NAME_LENGTH.verify(bytes, this.mCdh.getEncodedFileName().length);
        long extraLength = F_EXTRA_LENGTH.read(bytes);
        long fileNameStart = this.mCdh.getOffset() + (long)F_EXTRA_LENGTH.endOffset();
        byte[] fileNameData = new byte[this.mCdh.getEncodedFileName().length];
        this.mFile.directFullyRead(fileNameStart, fileNameData);
        String fileName = EncodeUtils.decode(fileNameData, this.mCdh.getGpBit());
        if (!fileName.equals(this.mCdh.getName())) {
            throw new IOException("Central directory reports file as being named '" + this.mCdh.getName() + "' but local header reports file being named '" + fileName + "'.");
        }
        long localExtraStart = fileNameStart + (long)this.mCdh.getEncodedFileName().length;
        byte[] localExtraRaw = new byte[Ints.checkedCast((long)extraLength)];
        this.mFile.directFullyRead(localExtraStart, localExtraRaw);
        this.mLocalExtra = new ExtraField(localExtraRaw);
    }

    private void readDataDescriptorRecord() throws IOException {
        CentralDirectoryHeaderCompressInfo compressInfo = this.mCdh.getCompressionInfoWithWait();
        long ddStart = this.mCdh.getOffset() + (long)FIXED_LOCAL_FILE_HEADER_SIZE + (long)this.mCdh.getName().length() + (long)this.mLocalExtra.size() + compressInfo.getCompressedSize();
        byte[] ddData = new byte[DataDescriptorType.DATA_DESCRIPTOR_WITH_SIGNATURE.size];
        this.mFile.directFullyRead(ddStart, ddData);
        ByteBuffer ddBytes = ByteBuffer.wrap(ddData);
        ZipField.F4 signatureField = new ZipField.F4(0, "Data descriptor signature", new ZipFieldInvariant[0]);
        int cpos = ddBytes.position();
        long sig = signatureField.read(ddBytes);
        if (sig == 134695760L) {
            this.mDataDescriptorType = DataDescriptorType.DATA_DESCRIPTOR_WITH_SIGNATURE;
        } else {
            this.mDataDescriptorType = DataDescriptorType.DATA_DESCRIPTOR_WITHOUT_SIGNATURE;
            ddBytes.position(cpos);
        }
        ZipField.F4 crc32Field = new ZipField.F4(0, "CRC32", new ZipFieldInvariant[0]);
        ZipField.F4 compressedField = new ZipField.F4(crc32Field.endOffset(), "Compressed size", new ZipFieldInvariant[0]);
        ZipField.F4 uncompressedField = new ZipField.F4(compressedField.endOffset(), "Uncompressed size", new ZipFieldInvariant[0]);
        if (!this.mFile.getSkipDataDescriptorVerification()) {
            crc32Field.verify(ddBytes, this.mCdh.getCrc32());
            compressedField.verify(ddBytes, compressInfo.getCompressedSize());
            uncompressedField.verify(ddBytes, this.mCdh.getUncompressedSize());
        }
    }

    @Nonnull
    private ProcessedAndRawByteSources createSourceFromZip(final long zipOffset) throws IOException {
        CentralDirectoryHeaderCompressInfo compressInfo;
        Preconditions.checkArgument((zipOffset >= 0L ? 1 : 0) != 0, (Object)"zipOffset < 0");
        try {
            compressInfo = this.mCdh.getCompressionInfoWithWait();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException should never occur here because compression information should be immediately available if reading from zip.", e);
        }
        CloseableByteSource rawContents = new CloseableByteSource(){

            public long size() throws IOException {
                return compressInfo.getCompressedSize();
            }

            @Nonnull
            public InputStream openStream() throws IOException {
                Preconditions.checkState((!StoredEntry.this.mDeleted ? 1 : 0) != 0, (Object)"mDeleted");
                long dataStart = zipOffset + (long)StoredEntry.this.getLocalHeaderSize();
                long dataEnd = dataStart + compressInfo.getCompressedSize();
                StoredEntry.this.mFile.openReadOnly();
                return StoredEntry.this.mFile.directOpen(dataStart, dataEnd);
            }

            @Override
            protected void innerClose() throws IOException {
            }
        };
        return this.createSourcesFromRawContents(rawContents);
    }

    @Nonnull
    private ProcessedAndRawByteSources createSourcesFromRawContents(@Nonnull CloseableByteSource rawContents) {
        CentralDirectoryHeaderCompressInfo compressInfo;
        try {
            compressInfo = this.mCdh.getCompressionInfoWithWait();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException should never occur here because compression information should be immediately available if creating from raw contents.", e);
        }
        CloseableByteSource contents = compressInfo.getMethod() == CompressionMethod.DEFLATE ? new InflaterByteSource(rawContents) : rawContents;
        return new ProcessedAndRawByteSources(contents, rawContents);
    }

    void replaceSourceFromZip(long zipFileOffset) throws IOException {
        Preconditions.checkArgument((zipFileOffset >= 0L ? 1 : 0) != 0, (Object)"zipFileOffset < 0");
        ProcessedAndRawByteSources oldSource = this.mSource;
        this.mSource = this.createSourceFromZip(zipFileOffset);
        this.mCdh.setOffset(zipFileOffset);
        oldSource.close();
    }

    void loadSourceIntoMemory() throws IOException {
        if (this.mCdh.getOffset() == -1L) {
            return;
        }
        ProcessedAndRawByteSources oldSource = this.mSource;
        byte[] rawContents = oldSource.getRawByteSource().read();
        this.mSource = this.createSourcesFromRawContents(new CloseableDelegateByteSource(ByteSource.wrap((byte[])rawContents), rawContents.length));
        this.mCdh.setOffset(-1L);
        oldSource.close();
    }

    @Nonnull
    ProcessedAndRawByteSources getSource() {
        return this.mSource;
    }

    @Nonnull
    public DataDescriptorType getDataDescriptorType() {
        return this.mDataDescriptorType;
    }

    @Nonnull
    byte[] toHeaderData() throws IOException {
        byte[] encodedFileName = this.mCdh.getEncodedFileName();
        ByteBuffer out = ByteBuffer.allocate(F_EXTRA_LENGTH.endOffset() + encodedFileName.length + this.mLocalExtra.size());
        CentralDirectoryHeaderCompressInfo compressInfo = this.mCdh.getCompressionInfoWithWait();
        F_LOCAL_SIGNATURE.write(out);
        F_VERSION_EXTRACT.write(out, compressInfo.getVersionExtract());
        F_GP_BIT.write(out, this.mCdh.getGpBit().getValue());
        F_METHOD.write(out, compressInfo.getMethod().methodCode);
        if (this.mFile.areTimestampsIgnored()) {
            F_LAST_MOD_TIME.write(out, 0L);
            F_LAST_MOD_DATE.write(out, 0L);
        } else {
            F_LAST_MOD_TIME.write(out, this.mCdh.getLastModTime());
            F_LAST_MOD_DATE.write(out, this.mCdh.getLastModDate());
        }
        F_CRC32.write(out, this.mCdh.getCrc32());
        F_COMPRESSED_SIZE.write(out, compressInfo.getCompressedSize());
        F_UNCOMPRESSED_SIZE.write(out, this.mCdh.getUncompressedSize());
        F_FILE_NAME_LENGTH.write(out, this.mCdh.getEncodedFileName().length);
        F_EXTRA_LENGTH.write(out, this.mLocalExtra.size());
        out.put(this.mCdh.getEncodedFileName());
        this.mLocalExtra.write(out);
        return out.array();
    }

    public boolean realign() throws IOException {
        Preconditions.checkState((!this.mDeleted ? 1 : 0) != 0, (Object)"Entry has been deleted.");
        return this.mFile.realign(this);
    }

    @Nonnull
    public ExtraField getLocalExtra() {
        return this.mLocalExtra;
    }

    public void setLocalExtra(@Nonnull ExtraField localExtra) throws IOException {
        boolean resized = this.setLocalExtraNoNotify(localExtra);
        this.mFile.localHeaderChanged(this, resized);
    }

    boolean setLocalExtraNoNotify(@Nonnull ExtraField localExtra) throws IOException {
        this.loadSourceIntoMemory();
        boolean sizeChanged = this.mLocalExtra.size() != localExtra.size();
        this.mLocalExtra = localExtra;
        return sizeChanged;
    }
}

