/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.sdk;

import com.android.SdkConstants;
import com.android.builder.sdk.InstallFailedException;
import com.android.builder.sdk.LicenceNotAcceptedException;
import com.android.builder.sdk.SdkInfo;
import com.android.builder.sdk.SdkLibData;
import com.android.builder.sdk.SdkLoader;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.Revision;
import com.android.repository.api.Downloader;
import com.android.repository.api.Installer;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.RepoPackage;
import com.android.repository.api.SettingsController;
import com.android.repository.api.UpdatablePackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.repository.util.InstallerUtil;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.LoggerProgressIndicatorWrapper;
import com.android.sdklib.repository.installer.SdkInstallerUtil;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.android.utils.StdLogger;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DefaultSdkLoader
implements SdkLoader {
    private static DefaultSdkLoader sLoader;
    private final File mSdkLocation;
    private AndroidSdkHandler mSdkHandler;
    private SdkInfo mSdkInfo;
    private final ImmutableList<File> mRepositories;
    private final FileOp mFileOp = FileOpUtils.create();

    public static synchronized SdkLoader getLoader(File sdkLocation) {
        if (sLoader == null) {
            sLoader = new DefaultSdkLoader(sdkLocation);
        } else if (!FileUtils.isSameFile((File)sdkLocation, (File)DefaultSdkLoader.sLoader.mSdkLocation)) {
            throw new IllegalStateException(String.format("%s already created using %s; cannot also use %s", DefaultSdkLoader.class.getSimpleName(), DefaultSdkLoader.sLoader.mSdkLocation, sdkLocation));
        }
        return sLoader;
    }

    public static synchronized void unload() {
        sLoader = null;
    }

    @Override
    public TargetInfo getTargetInfo(String targetHash, Revision buildToolRevision, ILogger logger, SdkLibData sdkLibData) throws LicenceNotAcceptedException, InstallFailedException {
        this.init(logger);
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(logger);
        ProgressIndicator stdOutputProgress = DefaultSdkLoader.getNewDownloadProgress();
        IAndroidTarget target = this.mSdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(targetHash, (ProgressIndicator)progress);
        BuildToolInfo buildToolInfo = this.mSdkHandler.getBuildToolInfo(buildToolRevision, (ProgressIndicator)progress);
        if (sdkLibData.useSdkDownload()) {
            SettingsController settings = sdkLibData.getSettings();
            Downloader downloader = sdkLibData.getDownloader();
            Preconditions.checkNotNull((Object)settings);
            Preconditions.checkNotNull((Object)downloader);
            if (buildToolInfo != null && !buildToolInfo.getRevision().equals((Object)buildToolRevision)) {
                stdOutputProgress.logWarning("Build Tools revision " + buildToolRevision + " requested, but the latest available preview is " + buildToolInfo.getRevision() + ", which will be used to build.");
            }
            if (target == null || buildToolInfo == null) {
                HashMap<RemotePackage, InstallResultType> installResults = new HashMap<RemotePackage, InstallResultType>();
                RepoManager repoManager = this.mSdkHandler.getSdkManager((ProgressIndicator)progress);
                DefaultSdkLoader.checkNeedsCacheReset(repoManager, sdkLibData);
                repoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, downloader, settings);
                if (buildToolInfo == null) {
                    installResults.putAll(this.installBuildTools(buildToolRevision, repoManager, downloader, stdOutputProgress));
                }
                if (target == null) {
                    installResults.putAll(this.installTarget(targetHash, repoManager, downloader, stdOutputProgress));
                }
                this.checkResults(installResults);
                repoManager.loadSynchronously(0L, (ProgressIndicator)progress, null, null);
                buildToolInfo = this.mSdkHandler.getBuildToolInfo(buildToolRevision, (ProgressIndicator)progress);
                target = this.mSdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(targetHash, (ProgressIndicator)progress);
            }
        }
        if (target == null) {
            throw new IllegalStateException("Failed to find target with hash string '" + targetHash + "' in: " + this.mSdkLocation);
        }
        if (buildToolInfo == null) {
            throw new IllegalStateException("Failed to find Build Tools revision " + buildToolRevision.toString());
        }
        return new TargetInfo(target, buildToolInfo);
    }

    private static void checkNeedsCacheReset(RepoManager repoManager, SdkLibData sdkLibData) {
        if (sdkLibData.needsCacheReset()) {
            repoManager.markInvalid();
            sdkLibData.setNeedsCacheReset(false);
        }
    }

    private Map<RemotePackage, InstallResultType> installTarget(String targetHash, RepoManager repoManager, Downloader downloader, ProgressIndicator progress) {
        HashMap<RemotePackage, InstallResultType> installResults = new HashMap<RemotePackage, InstallResultType>();
        AndroidVersion targetVersion = AndroidTargetHash.getVersionFromHash((String)targetHash);
        if (targetVersion == null) {
            return Collections.emptyMap();
        }
        String platformPath = DetailsTypes.getPlatformPath((AndroidVersion)targetVersion);
        UpdatablePackage platformPkg = (UpdatablePackage)repoManager.getPackages().getConsolidatedPkgs().get(platformPath);
        if (platformPkg == null) {
            throw new IllegalStateException("Failed to find Platform SDK with path: " + platformPath);
        }
        if (!platformPkg.hasLocal() && platformPkg.getRemote() != null) {
            installResults.putAll(this.installRemotePackages((List<RemotePackage>)ImmutableList.of((Object)platformPkg.getRemote()), repoManager, downloader, progress));
        }
        if (!AndroidTargetHash.isPlatform((String)targetHash)) {
            RemotePackage addonPackage = null;
            for (RemotePackage p : repoManager.getPackages().getRemotePackages().values()) {
                DetailsTypes.AddonDetailsType addonDetails;
                String addonHash;
                if (!(p.getTypeDetails() instanceof DetailsTypes.AddonDetailsType) || !targetHash.equals(addonHash = AndroidTargetHash.getAddonHashString((String)(addonDetails = (DetailsTypes.AddonDetailsType)p.getTypeDetails()).getVendor().getDisplay(), (String)addonDetails.getTag().getDisplay(), (AndroidVersion)addonDetails.getAndroidVersion()))) continue;
                addonPackage = p;
                break;
            }
            if (addonPackage == null) {
                throw new IllegalStateException("Failed to find target with hash string " + targetHash);
            }
            installResults.putAll(this.installRemotePackages((List<RemotePackage>)ImmutableList.of(addonPackage), repoManager, downloader, progress));
        }
        return installResults;
    }

    private Map<RemotePackage, InstallResultType> installBuildTools(Revision buildToolRevision, RepoManager repoManager, Downloader downloader, ProgressIndicator progress) {
        String buildToolsPath = DetailsTypes.getBuildToolsPath((Revision)buildToolRevision);
        RemotePackage buildToolsPackage = (RemotePackage)repoManager.getPackages().getRemotePackages().get(buildToolsPath);
        if (buildToolsPackage == null) {
            throw new IllegalStateException("Failed to find Build Tools revision " + buildToolRevision.toString());
        }
        if (!buildToolsPackage.getVersion().equals((Object)buildToolRevision)) {
            progress.logWarning("Build Tools revision " + buildToolRevision + " requested, but the latest available preview is " + buildToolsPackage.getVersion() + ", which will be installed.");
        }
        return this.installRemotePackages((List<RemotePackage>)ImmutableList.of((Object)buildToolsPackage), repoManager, downloader, progress);
    }

    private Map<RemotePackage, InstallResultType> installRemotePackages(List<RemotePackage> requestPackages, RepoManager repoManager, Downloader downloader, ProgressIndicator progress) {
        List remotePackages = InstallerUtil.computeRequiredPackages(requestPackages, (RepositoryPackages)repoManager.getPackages(), (ProgressIndicator)progress);
        if (remotePackages == null) {
            return Maps.toMap(requestPackages, p -> InstallResultType.INSTALL_FAIL);
        }
        HashMap<RemotePackage, InstallResultType> installResults = new HashMap<RemotePackage, InstallResultType>();
        for (RemotePackage p2 : remotePackages) {
            progress.logVerbose("Checking the license for package " + p2.getDisplayName() + " in " + repoManager.getLocalPath() + File.separator + "licenses");
            if (p2.getLicense() != null && !p2.getLicense().checkAccepted(repoManager.getLocalPath(), this.mSdkHandler.getFileOp())) {
                progress.logWarning("License for package " + p2.getDisplayName() + " not accepted.");
                installResults.put(p2, InstallResultType.LICENSE_FAIL);
                continue;
            }
            progress.logVerbose("License for package " + p2.getDisplayName() + " accepted.");
            Installer installer = SdkInstallerUtil.findBestInstallerFactory((RepoPackage)p2, (AndroidSdkHandler)this.mSdkHandler).createInstaller(p2, repoManager, downloader, this.mSdkHandler.getFileOp());
            if (installer.prepare(progress) && installer.complete(progress)) {
                installResults.put(p2, InstallResultType.SUCCESS);
                continue;
            }
            installResults.put(p2, InstallResultType.INSTALL_FAIL);
        }
        return installResults;
    }

    @Override
    public SdkInfo getSdkInfo(ILogger logger) {
        this.init(logger);
        return this.mSdkInfo;
    }

    @Override
    public ImmutableList<File> getRepositories() {
        return this.mRepositories;
    }

    private DefaultSdkLoader(File sdkLocation) {
        this.mSdkLocation = sdkLocation;
        this.mRepositories = this.computeRepositories();
    }

    private synchronized void init(ILogger logger) {
        if (this.mSdkHandler == null) {
            this.mSdkHandler = AndroidSdkHandler.getInstance((File)this.mSdkLocation);
            LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(logger);
            this.mSdkHandler.getSdkManager((ProgressIndicator)progress).reloadLocalIfNeeded((ProgressIndicator)progress);
            File toolsFolder = new File(this.mSdkLocation, "tools");
            File supportToolsFolder = new File(toolsFolder, "support");
            File platformTools = new File(this.mSdkLocation, "platform-tools");
            this.mSdkInfo = new SdkInfo(new File(supportToolsFolder, "annotations.jar"), new File(platformTools, SdkConstants.FN_ADB));
        }
    }

    private ImmutableList<File> computeRepositories() {
        return ImmutableList.of((Object)new File(this.mSdkLocation, "extras" + File.separator + "android" + File.separator + "m2repository"), (Object)new File(this.mSdkLocation, "extras" + File.separator + "google" + File.separator + "m2repository"), (Object)new File(this.mSdkLocation, "extras" + File.separator + "m2repository"));
    }

    @Override
    public List<File> updateRepositories(List<String> repositoryPaths, SdkLibData sdkLibData, ILogger logger) throws LicenceNotAcceptedException, InstallFailedException {
        ImmutableList.Builder repositoriesBuilder = ImmutableList.builder();
        HashMap<RemotePackage, InstallResultType> installResults = new HashMap<RemotePackage, InstallResultType>();
        ProgressIndicator progress = DefaultSdkLoader.getNewDownloadProgress();
        RepoManager repoManager = this.mSdkHandler.getSdkManager(progress);
        DefaultSdkLoader.checkNeedsCacheReset(repoManager, sdkLibData);
        repoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)new LoggerProgressIndicatorWrapper(logger), sdkLibData.getDownloader(), sdkLibData.getSettings());
        Map remotePackages = repoManager.getPackages().getRemotePackages();
        List<RemotePackage> artifactPackages = repositoryPaths.stream().map(remotePackages::get).filter(Objects::nonNull).collect(Collectors.toList());
        if (!artifactPackages.isEmpty()) {
            installResults.putAll(this.installRemotePackages(artifactPackages, repoManager, sdkLibData.getDownloader(), progress));
            repositoriesBuilder.add((Object)new File(this.mSdkLocation + File.separator + "extras" + File.separator + "m2repository"));
        }
        this.checkResults(installResults);
        if (artifactPackages.size() != repositoryPaths.size() || installResults.values().contains((Object)InstallResultType.INSTALL_FAIL)) {
            File androidRepo;
            UpdatablePackage googleRepositoryPackage = (UpdatablePackage)repoManager.getPackages().getConsolidatedPkgs().get(SdkMavenRepository.GOOGLE.getPackageId());
            UpdatablePackage androidRepositoryPackage = (UpdatablePackage)this.mSdkHandler.getSdkManager(progress).getPackages().getConsolidatedPkgs().get(SdkMavenRepository.ANDROID.getPackageId());
            if (DefaultSdkLoader.isInGoogleRepository(repositoryPaths)) {
                File googleRepo;
                if (googleRepositoryPackage.hasLocal() && !googleRepositoryPackage.isUpdate()) {
                    googleRepo = this.getMavenRepoAsFile(SdkMavenRepository.GOOGLE);
                    repositoriesBuilder.add((Object)googleRepo);
                } else if (googleRepositoryPackage.getRemote() != null) {
                    installResults.putAll(this.installRemotePackages((List<RemotePackage>)ImmutableList.of((Object)googleRepositoryPackage.getRemote()), repoManager, sdkLibData.getDownloader(), progress));
                    if (((InstallResultType)((Object)installResults.get(googleRepositoryPackage.getRemote()))).equals((Object)InstallResultType.SUCCESS)) {
                        googleRepo = this.getMavenRepoAsFile(SdkMavenRepository.GOOGLE);
                        repositoriesBuilder.add((Object)googleRepo);
                    }
                }
            }
            if (androidRepositoryPackage.hasLocal() && !androidRepositoryPackage.isUpdate()) {
                androidRepo = this.getMavenRepoAsFile(SdkMavenRepository.ANDROID);
                repositoriesBuilder.add((Object)androidRepo);
            } else if (androidRepositoryPackage.getRemote() != null) {
                installResults.putAll(this.installRemotePackages((List<RemotePackage>)ImmutableList.of((Object)androidRepositoryPackage.getRemote()), repoManager, sdkLibData.getDownloader(), progress));
                if (((InstallResultType)((Object)installResults.get(androidRepositoryPackage.getRemote()))).equals((Object)InstallResultType.SUCCESS)) {
                    androidRepo = this.getMavenRepoAsFile(SdkMavenRepository.ANDROID);
                    repositoriesBuilder.add((Object)androidRepo);
                }
            }
            this.checkResults(installResults);
        }
        return repositoriesBuilder.build();
    }

    private File getMavenRepoAsFile(SdkMavenRepository mavenRepository) {
        return mavenRepository.getRepositoryLocation(this.mSdkLocation, true, this.mFileOp);
    }

    private static boolean isInGoogleRepository(List<String> repoPaths) {
        for (String repoPath : repoPaths) {
            String group;
            GradleCoordinate coordinate = SdkMavenRepository.getCoordinateFromSdkPath((String)repoPath);
            if (coordinate == null || (group = coordinate.getGroupId()) == null || !group.startsWith("com.google.android.") && !group.startsWith("com.google.firebase.")) continue;
            return true;
        }
        return false;
    }

    @Override
    public File installSdkTool(SdkLibData sdkLibData, String packageId) throws LicenceNotAcceptedException, InstallFailedException {
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.WARNING));
        RepoManager repoManager = this.mSdkHandler.getSdkManager((ProgressIndicator)progress);
        repoManager.loadSynchronously(0L, (ProgressIndicator)progress, null, null);
        LocalPackage localSdkToolPackage = this.mSdkHandler.getLatestLocalPackageForPrefix(packageId, null, true, (ProgressIndicator)progress);
        if (localSdkToolPackage == null) {
            if (!sdkLibData.useSdkDownload()) {
                return null;
            }
            DefaultSdkLoader.checkNeedsCacheReset(repoManager, sdkLibData);
            repoManager.loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, sdkLibData.getDownloader(), sdkLibData.getSettings());
            RemotePackage sdkToolPackage = this.mSdkHandler.getLatestRemotePackageForPrefix(packageId, true, (ProgressIndicator)progress);
            if (sdkToolPackage == null) {
                return null;
            }
            Map<RemotePackage, InstallResultType> installResults = this.installRemotePackages((List<RemotePackage>)ImmutableList.of((Object)sdkToolPackage), repoManager, sdkLibData.getDownloader(), DefaultSdkLoader.getNewDownloadProgress());
            this.checkResults(installResults);
            repoManager.loadSynchronously(0L, (ProgressIndicator)progress, null, null);
            localSdkToolPackage = this.mSdkHandler.getLatestLocalPackageForPrefix(packageId, null, true, (ProgressIndicator)progress);
        }
        return localSdkToolPackage != null ? localSdkToolPackage.getLocation() : null;
    }

    private void checkResults(Map<RemotePackage, InstallResultType> installResults) throws LicenceNotAcceptedException, InstallFailedException {
        Function<InstallResultType, List> find = resultType -> installResults.entrySet().stream().filter(p -> p.getValue() == resultType).map(Map.Entry::getKey).collect(Collectors.toList());
        List unlicensedPackages = find.apply(InstallResultType.LICENSE_FAIL);
        if (!unlicensedPackages.isEmpty()) {
            throw new LicenceNotAcceptedException(this.mSdkLocation.toPath(), unlicensedPackages);
        }
        List failedPackages = find.apply(InstallResultType.INSTALL_FAIL);
        if (!failedPackages.isEmpty()) {
            throw new InstallFailedException(this.mSdkLocation.toPath(), failedPackages);
        }
    }

    private static ProgressIndicator getNewDownloadProgress() {
        return new LoggerProgressIndicatorWrapper((ILogger)new StdLogger(StdLogger.Level.VERBOSE));
    }

    private static enum InstallResultType {
        SUCCESS,
        LICENSE_FAIL,
        INSTALL_FAIL;

    }
}

