/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dependency.level2;

import com.android.builder.dependency.HashCodeUtils;
import com.android.builder.model.MavenCoordinates;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public final class DependencyNode {
    private final Object address;
    private final NodeType nodeType;
    private final ImmutableList<DependencyNode> dependencies;
    private final MavenCoordinates requestedCoordinates;
    private final int hashCode;

    public DependencyNode(Object address, NodeType nodeType, List<DependencyNode> dependencies, MavenCoordinates requestedCoordinates) {
        this.address = address;
        this.nodeType = nodeType;
        this.dependencies = ImmutableList.copyOf(dependencies);
        this.requestedCoordinates = requestedCoordinates;
        this.hashCode = this.computeHashCode();
    }

    public Object getAddress() {
        return this.address;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public MavenCoordinates getRequestedCoordinates() {
        return this.requestedCoordinates;
    }

    public ImmutableList<DependencyNode> getDependencies() {
        return this.dependencies;
    }

    public boolean equals(Object o4) {
        if (this == o4) {
            return true;
        }
        if (o4 == null || this.getClass() != o4.getClass()) {
            return false;
        }
        DependencyNode that = (DependencyNode)o4;
        return this.hashCode == that.hashCode && Objects.equals(this.address, that.address) && Objects.equals((Object)this.nodeType, (Object)that.nodeType) && Objects.equals(this.dependencies, that.dependencies) && Objects.equals(this.requestedCoordinates, that.requestedCoordinates);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        return HashCodeUtils.hashCode(this.address, (Object)this.nodeType, this.dependencies, this.requestedCoordinates);
    }

    public static enum NodeType {
        ANDROID,
        JAVA;

    }
}

