/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.SdkConstants;
import com.android.builder.internal.compiler.DirectoryWalker;
import com.android.ide.common.internal.WaitableExecutor;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;

public class RenderScriptProcessor {
    private static final String LIBCLCORE_BC = "libclcore.bc";
    private static final Abi[] ABIS_32 = new Abi[]{new Abi("armeabi-v7a", "armv7-none-linux-gnueabi", BuildToolInfo.PathId.LD_ARM, "-dynamic-linker", "/system/bin/linker", "-X", "-m", "armelf_linux_eabi"), new Abi("mips", "mipsel-unknown-linux", BuildToolInfo.PathId.LD_MIPS, "-EL"), new Abi("x86", "i686-unknown-linux", BuildToolInfo.PathId.LD_X86, "-m", "elf_i386")};
    private static final Abi[] ABIS_64 = new Abi[]{new Abi("arm64-v8a", "aarch64-linux-android", BuildToolInfo.PathId.LD_ARM64, "-X"), new Abi("x86_64", "x86_64-unknown-linux", BuildToolInfo.PathId.LD_X86_64, "-m", "elf_x86_64")};
    public static final String RS_DEPS = "rsDeps";
    private final Collection<File> mSourceFolders;
    private final Collection<File> mImportFolders;
    private final File mSourceOutputDir;
    private final File mResOutputDir;
    private final File mObjOutputDir;
    private final File mLibOutputDir;
    private final BuildToolInfo mBuildToolInfo;
    private final ILogger mLogger;
    private final int mTargetApi;
    private final int mOptimizationLevel;
    private final boolean mNdkMode;
    private final boolean mSupportMode;
    private final boolean mUseAndroidX;
    private final Set<String> mAbiFilters;
    private boolean is32Bit;
    private boolean is64Bit;
    private final File mRsLib;
    private final Map<String, File> mLibClCore = Maps.newHashMap();

    public RenderScriptProcessor(Collection<File> sourceFolders, Collection<File> importFolders, File sourceOutputDir, File resOutputDir, File objOutputDir, File libOutputDir, BuildToolInfo buildToolInfo, int targetApi, boolean debugBuild, int optimizationLevel, boolean ndkMode, boolean supportMode, boolean useAndroidX, Set<String> abiFilters, ILogger logger) {
        this.mSourceFolders = sourceFolders;
        this.mImportFolders = importFolders;
        this.mSourceOutputDir = sourceOutputDir;
        this.mResOutputDir = resOutputDir;
        this.mObjOutputDir = objOutputDir;
        this.mLibOutputDir = libOutputDir;
        this.mBuildToolInfo = buildToolInfo;
        this.mTargetApi = targetApi;
        this.mOptimizationLevel = optimizationLevel;
        this.mNdkMode = ndkMode;
        this.mSupportMode = supportMode;
        this.mUseAndroidX = useAndroidX;
        this.mAbiFilters = abiFilters;
        this.mLogger = logger;
        if (supportMode) {
            File rsClCoreFile;
            File rs = new File(this.mBuildToolInfo.getLocation(), "renderscript");
            this.mRsLib = new File(rs, "lib");
            File bcFolder = new File(this.mRsLib, "bc");
            for (Abi abi2 : ABIS_32) {
                rsClCoreFile = new File(bcFolder, abi2.mDevice + File.separatorChar + LIBCLCORE_BC);
                if (!rsClCoreFile.exists()) continue;
                this.mLibClCore.put(abi2.mDevice, rsClCoreFile);
            }
            for (Abi abi2 : ABIS_64) {
                rsClCoreFile = new File(bcFolder, abi2.mDevice + File.separatorChar + LIBCLCORE_BC);
                if (!rsClCoreFile.exists()) continue;
                this.mLibClCore.put(abi2.mDevice, rsClCoreFile);
            }
        } else {
            this.mRsLib = null;
        }
        if (abiFilters == null || abiFilters.isEmpty()) {
            this.is32Bit = true;
            this.is64Bit = true;
        } else {
            this.is32Bit = Arrays.stream(ABIS_32).map(abi -> ((Abi)abi).mDevice).anyMatch(abi -> this.mAbiFilters.contains(abi));
            this.is64Bit = Arrays.stream(ABIS_64).map(abi -> ((Abi)abi).mDevice).anyMatch(abi -> this.mAbiFilters.contains(abi));
        }
        if (this.mTargetApi < 21 && this.is64Bit && this.mNdkMode) {
            throw new RuntimeException("Api version " + this.mTargetApi + " does not support 64 bit ndk compilation");
        }
    }

    public static File getSupportJar(File buildToolsFolder, boolean useAndroidX) {
        return new File(RenderScriptProcessor.getBaseRenderscriptLibFolder(buildToolsFolder), useAndroidX ? "androidx-rs.jar" : "renderscript-v8.jar");
    }

    public static File getSupportNativeLibFolder(File buildToolsFolder) {
        return new File(RenderScriptProcessor.getBaseRenderscriptLibFolder(buildToolsFolder), "packaged");
    }

    public static File getSupportBlasLibFolder(File buildToolsFolder) {
        return new File(RenderScriptProcessor.getBaseRenderscriptLibFolder(buildToolsFolder), "blas");
    }

    private static File getBaseRenderscriptLibFolder(File buildToolsFolder) {
        return new File(buildToolsFolder, "renderscript/lib");
    }

    public void build(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler) throws InterruptedException, ProcessException, IOException {
        ArrayList renderscriptFiles = Lists.newArrayList();
        for (File dir : this.mSourceFolders) {
            DirectoryWalker.builder().root(dir.toPath()).extensions("rs", "fs").action((start, path) -> renderscriptFiles.add(path.toFile())).build().walk();
        }
        if (renderscriptFiles.isEmpty()) {
            return;
        }
        HashMap env = Maps.newHashMap();
        if (SdkConstants.CURRENT_PLATFORM == 3) {
            env.put("DYLD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        } else if (SdkConstants.CURRENT_PLATFORM == 1) {
            env.put("LD_LIBRARY_PATH", this.mBuildToolInfo.getLocation().getAbsolutePath());
        }
        this.doMainCompilation(renderscriptFiles, processExecutor, processOutputHandler, env);
        if (this.mSupportMode) {
            this.createSupportFiles(processExecutor, processOutputHandler, env);
        }
    }

    private File getArchSpecificRawFolder(String architecture) {
        return FileUtils.join((File)this.mResOutputDir, (String[])new String[]{"raw", "bc" + architecture});
    }

    private File getGenericRawFolder() {
        return new File(this.mResOutputDir, "raw");
    }

    private void doMainCompilation(List<File> inputFiles, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) throws ProcessException {
        ArrayList<String> fixedBuilderArgs = new ArrayList<String>();
        String rsPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS);
        String rsClangPath = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.ANDROID_RS_CLANG);
        ArrayList<String> architectures = new ArrayList<String>();
        if (this.is32Bit) {
            architectures.add("32");
        }
        if (this.is64Bit) {
            architectures.add("64");
        }
        fixedBuilderArgs.add("-I");
        fixedBuilderArgs.add(rsPath);
        fixedBuilderArgs.add("-I");
        fixedBuilderArgs.add(rsClangPath);
        for (File file : this.mImportFolders) {
            if (!file.isDirectory()) continue;
            fixedBuilderArgs.add("-I");
            fixedBuilderArgs.add(file.getAbsolutePath());
        }
        if (this.mSupportMode) {
            if (this.mUseAndroidX) {
                fixedBuilderArgs.add("-rs-package-name=androidx.renderscript");
            } else {
                fixedBuilderArgs.add("-rs-package-name=android.support.v8.renderscript");
            }
        }
        fixedBuilderArgs.add("-p");
        fixedBuilderArgs.add(this.mSourceOutputDir.getAbsolutePath());
        fixedBuilderArgs.add("-target-api");
        int targetApi = this.mTargetApi < 11 ? 11 : this.mTargetApi;
        targetApi = this.mSupportMode && targetApi < 18 ? 18 : targetApi;
        fixedBuilderArgs.add(Integer.toString(targetApi));
        for (File sourceFile : inputFiles) {
            fixedBuilderArgs.add(sourceFile.getAbsolutePath());
        }
        if (this.mNdkMode) {
            fixedBuilderArgs.add("-reflect-c++");
        }
        fixedBuilderArgs.add("-O");
        fixedBuilderArgs.add(Integer.toString(this.mOptimizationLevel));
        if (this.mTargetApi >= 21 && this.mNdkMode) {
            for (String arch : architectures) {
                ArrayList<String> variableBuilderArgs = new ArrayList<String>();
                variableBuilderArgs.add("-o");
                variableBuilderArgs.add(this.getArchSpecificRawFolder(arch).getAbsolutePath());
                variableBuilderArgs.add("-m" + arch);
                ArrayList<String> builderArgs = new ArrayList<String>(variableBuilderArgs);
                builderArgs.addAll(fixedBuilderArgs);
                builderArgs.addAll(variableBuilderArgs);
                this.compileSingleFile(processExecutor, processOutputHandler, env, builderArgs);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("-o");
            arrayList.add(this.getGenericRawFolder().getAbsolutePath());
            ArrayList<String> builderArgs = new ArrayList<String>(arrayList);
            builderArgs.addAll(fixedBuilderArgs);
            builderArgs.addAll(arrayList);
            this.compileSingleFile(processExecutor, processOutputHandler, env, builderArgs);
        }
    }

    private void compileSingleFile(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env, List<String> builderArgs) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        String renderscript = this.mBuildToolInfo.getPath(BuildToolInfo.PathId.LLVM_RS_CC);
        if (renderscript == null || !new File(renderscript).isFile()) {
            throw new IllegalStateException(BuildToolInfo.PathId.LLVM_RS_CC + " is missing");
        }
        builder.setExecutable(renderscript);
        builder.addEnvironments(env);
        for (String arg : builderArgs) {
            builder.addArgs(arg);
        }
        ProcessResult result = processExecutor.execute(builder.createProcess(), processOutputHandler);
        result.rethrowFailure().assertNormalExitValue();
    }

    private void createSupportFiles(ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) throws IOException, InterruptedException, ProcessException {
        int targetApi = this.mTargetApi < 11 ? 11 : this.mTargetApi;
        int n4 = targetApi = this.mSupportMode && targetApi < 18 ? 18 : targetApi;
        if (targetApi < 21) {
            File rawFolder = this.getGenericRawFolder();
            this.createSupportFilesHelper(rawFolder, ABIS_32, processExecutor, processOutputHandler, env);
        } else {
            File rawFolder32 = this.getArchSpecificRawFolder("32");
            this.createSupportFilesHelper(rawFolder32, ABIS_32, processExecutor, processOutputHandler, env);
            File rawFolder64 = this.getArchSpecificRawFolder("64");
            this.createSupportFilesHelper(rawFolder64, ABIS_64, processExecutor, processOutputHandler, env);
        }
    }

    private void createSupportFilesHelper(File rawFolder, Abi[] abis, final ProcessExecutor processExecutor, final ProcessOutputHandler processOutputHandler, final Map<String, String> env) throws IOException, InterruptedException, ProcessException {
        WaitableExecutor mExecutor = WaitableExecutor.useGlobalSharedThreadPool();
        LinkedList files = Lists.newLinkedList();
        DirectoryWalker.builder().root(rawFolder.toPath()).extensions("bc").action((start, path) -> files.add(path.toFile())).build().walk();
        for (final File bcFile : files) {
            String name = bcFile.getName();
            final String objName = name.replaceAll("\\.bc", ".o");
            final String soName = "librs." + name.replaceAll("\\.bc", ".so");
            for (final Abi abi : abis) {
                if (this.mAbiFilters != null && !this.mAbiFilters.contains(abi.mDevice)) continue;
                if (this.mLibClCore.get(abi.mDevice) == null) {
                    this.mLogger.warning("Skipped RenderScript support mode compilation for " + abi.mDevice + " : required components not found in Build-Tools " + this.mBuildToolInfo.getRevision().toString() + '\n' + "Please check and update your BuildTools.", new Object[0]);
                    continue;
                }
                final File objAbiFolder = new File(this.mObjOutputDir, abi.mDevice);
                if (!objAbiFolder.isDirectory() && !objAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + objAbiFolder.getAbsolutePath());
                }
                final File libAbiFolder = new File(this.mLibOutputDir, abi.mDevice);
                if (!libAbiFolder.isDirectory() && !libAbiFolder.mkdirs()) {
                    throw new IOException("Unable to create dir " + libAbiFolder.getAbsolutePath());
                }
                mExecutor.execute((Callable)new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        File objFile = RenderScriptProcessor.this.createSupportObjFile(bcFile, abi, objName, objAbiFolder, processExecutor, processOutputHandler, env);
                        RenderScriptProcessor.this.createSupportLibFile(objFile, abi, soName, libAbiFolder, processExecutor, processOutputHandler, env);
                        return null;
                    }
                });
            }
        }
        mExecutor.waitForTasksWithQuickFail(true);
    }

    private File createSupportObjFile(File bcFile, Abi abi, String objName, File objAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) throws ProcessException {
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mBuildToolInfo.getPath(BuildToolInfo.PathId.BCC_COMPAT));
        builder.addEnvironments(env);
        builder.addArgs("-O" + Integer.toString(this.mOptimizationLevel));
        File outFile = new File(objAbiFolder, objName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        builder.addArgs("-fPIC");
        builder.addArgs("-shared");
        builder.addArgs("-rt-path", this.mLibClCore.get(abi.mDevice).getAbsolutePath());
        builder.addArgs("-mtriple", abi.mToolchain);
        builder.addArgs(bcFile.getAbsolutePath());
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
        return outFile;
    }

    private void createSupportLibFile(File objFile, Abi abi, String soName, File libAbiFolder, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Map<String, String> env) throws ProcessException {
        File intermediatesFolder = new File(this.mRsLib, "intermediates");
        File intermediatesAbiFolder = new File(intermediatesFolder, abi.mDevice);
        File packagedFolder = new File(this.mRsLib, "packaged");
        File packagedAbiFolder = new File(packagedFolder, abi.mDevice);
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(this.mBuildToolInfo.getPath(abi.mLinker));
        builder.addEnvironments(env);
        builder.addArgs("--eh-frame-hdr").addArgs(abi.mLinkerArgs).addArgs("-shared", "-Bsymbolic", "-z", new String[]{"noexecstack", "-z", "relro", "-z", "now"});
        File outFile = new File(libAbiFolder, soName);
        builder.addArgs("-o", outFile.getAbsolutePath());
        builder.addArgs("-L" + intermediatesAbiFolder.getAbsolutePath(), "-L" + packagedAbiFolder.getAbsolutePath(), "-soname", new String[]{soName, objFile.getAbsolutePath(), new File(intermediatesAbiFolder, "libcompiler_rt.a").getAbsolutePath(), "-lRSSupport", "-lm", "-lc"});
        processExecutor.execute(builder.createProcess(), processOutputHandler).rethrowFailure().assertNormalExitValue();
    }

    private static final class Abi {
        private final String mDevice;
        private final String mToolchain;
        private final BuildToolInfo.PathId mLinker;
        private final String[] mLinkerArgs;

        Abi(String device, String toolchain, BuildToolInfo.PathId linker, String ... linkerArgs) {
            this.mDevice = device;
            this.mToolchain = toolchain;
            this.mLinker = linker;
            this.mLinkerArgs = linkerArgs;
        }
    }
}

