/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.cf.code;

import com.android.dx.util.FixedSizeList;

public final class LineNumberList
extends FixedSizeList {
    public static final LineNumberList EMPTY = new LineNumberList(0);

    public static LineNumberList concat(LineNumberList list1, LineNumberList list2) {
        int i4;
        if (list1 == EMPTY) {
            return list2;
        }
        int sz1 = list1.size();
        int sz2 = list2.size();
        LineNumberList result = new LineNumberList(sz1 + sz2);
        for (i4 = 0; i4 < sz1; ++i4) {
            result.set(i4, list1.get(i4));
        }
        for (i4 = 0; i4 < sz2; ++i4) {
            result.set(sz1 + i4, list2.get(i4));
        }
        return result;
    }

    public LineNumberList(int count) {
        super(count);
    }

    public Item get(int n4) {
        return (Item)this.get0(n4);
    }

    public void set(int n4, Item item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.set0(n4, item);
    }

    public void set(int n4, int startPc, int lineNumber) {
        this.set0(n4, new Item(startPc, lineNumber));
    }

    public int pcToLine(int pc) {
        int sz = this.size();
        int bestPc = -1;
        int bestLine = -1;
        for (int i4 = 0; i4 < sz; ++i4) {
            Item one = this.get(i4);
            int onePc = one.getStartPc();
            if (onePc > pc || onePc <= bestPc) continue;
            bestPc = onePc;
            bestLine = one.getLineNumber();
            if (bestPc == pc) break;
        }
        return bestLine;
    }

    public static class Item {
        private final int startPc;
        private final int lineNumber;

        public Item(int startPc, int lineNumber) {
            if (startPc < 0) {
                throw new IllegalArgumentException("startPc < 0");
            }
            if (lineNumber < 0) {
                throw new IllegalArgumentException("lineNumber < 0");
            }
            this.startPc = startPc;
            this.lineNumber = lineNumber;
        }

        public int getStartPc() {
            return this.startPc;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }
    }
}

