/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassBucketGroup;
import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.ClassFileInputs;
import com.android.builder.dexing.JarBucketGroup;
import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J.\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0018\u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u00142\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/android/builder/dexing/ClassBucket;", "Ljava/io/Serializable;", "bucketGroup", "Lcom/android/builder/dexing/ClassBucketGroup;", "bucketNumber", "", "(Lcom/android/builder/dexing/ClassBucketGroup;I)V", "getBucketGroup", "()Lcom/android/builder/dexing/ClassBucketGroup;", "getBucketNumber", "()I", "relativePath", "", "numberOfBuckets", "isJarFile", "", "getClassFiles", "Ljava/util/stream/Stream;", "Lcom/android/builder/dexing/ClassFileEntry;", "filter", "Lkotlin/Function2;", "Ljava/io/File;", "closer", "Lcom/google/common/io/Closer;", "Companion", "builder"})
public final class ClassBucket
implements Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClassBucketGroup bucketGroup;
    private final int bucketNumber;
    private static final long serialVersionUID = 1L;

    public ClassBucket(@NotNull ClassBucketGroup bucketGroup, int bucketNumber) {
        Intrinsics.checkParameterIsNotNull((Object)bucketGroup, (String)"bucketGroup");
        this.bucketGroup = bucketGroup;
        this.bucketNumber = bucketNumber;
    }

    @NotNull
    public final ClassBucketGroup getBucketGroup() {
        return this.bucketGroup;
    }

    public final int getBucketNumber() {
        return this.bucketNumber;
    }

    @NotNull
    public final Stream<ClassFileEntry> getClassFiles(@NotNull Function2<? super File, ? super String, Boolean> filter, @NotNull Closer closer) {
        Intrinsics.checkParameterIsNotNull(filter, (String)"filter");
        Intrinsics.checkParameterIsNotNull((Object)closer, (String)"closer");
        Stream<Object> classFiles = Stream.empty();
        for (File root : this.bucketGroup.getRoots()) {
            ClassFileInput classFileInput = ClassFileInputs.fromPath(root.toPath());
            Intrinsics.checkExpressionValueIsNotNull((Object)classFileInput, (String)"fromPath(root.toPath())");
            ClassFileInput classFileInput2 = classFileInput;
            closer.register((Closeable)classFileInput2);
            classFiles = Stream.concat(classFiles, classFileInput2.entries(new BiPredicate<Path, String>(this, filter){
                final /* synthetic */ ClassBucket this$0;
                final /* synthetic */ Function2<File, String, Boolean> $filter;
                {
                    this.this$0 = $receiver;
                    this.$filter = $filter;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean test(Path rootPath, String relativePath) {
                    Intrinsics.checkExpressionValueIsNotNull((Object)relativePath, (String)"relativePath");
                    if (ClassBucket.access$getBucketNumber(this.this$0, relativePath, this.this$0.getBucketGroup().getNumOfBuckets(), this.this$0.getBucketGroup() instanceof JarBucketGroup) != this.this$0.getBucketNumber()) return false;
                    File file = rootPath.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"rootPath.toFile()");
                    if ((Boolean)this.$filter.invoke((Object)file, (Object)relativePath) == false) return false;
                    return true;
                }
            }));
        }
        Stream stream = classFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)stream, (String)"classFiles");
        return stream;
    }

    private final int getBucketNumber(String relativePath, int numberOfBuckets, boolean isJarFile2) {
        String string;
        boolean bl2 = !new File(relativePath).isAbsolute();
        boolean bl3 = false;
        int n10 = 0;
        if (!bl2) {
            boolean bl4 = false;
            String string2 = Intrinsics.stringPlus((String)"Expected relative path but found absolute path: ", (Object)relativePath);
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        String pathOfPackageOrClass = isJarFile2 ? ((string = new File(relativePath).getParent()) == null ? "" : string) : relativePath;
        String normalizedPath = FilesKt.getInvariantSeparatorsPath((File)new File(pathOfPackageOrClass));
        n10 = normalizedPath.hashCode();
        boolean bl5 = false;
        return Math.abs(n10) % numberOfBuckets;
    }

    public static final /* synthetic */ int access$getBucketNumber(ClassBucket $this, String relativePath, int numberOfBuckets, boolean isJarFile2) {
        return $this.getBucketNumber(relativePath, numberOfBuckets, isJarFile2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/builder/dexing/ClassBucket$Companion;", "", "()V", "serialVersionUID", "", "builder"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

