/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.internal.aapt.AaptConvertConfig;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.v2.Aapt2;
import com.android.builder.internal.aapt.v2.Aapt2Daemon;
import com.android.builder.internal.aapt.v2.Aapt2Exception;
import com.android.ide.common.resources.CompileResourceRequest;
import com.android.utils.ILogger;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0005()*+,BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001bH\u0003J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0006\u0010#\u001a\u00020\u001fJ\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001b0'H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "", "logger", "Lcom/android/utils/ILogger;", "daemonFactory", "Lkotlin/Function1;", "", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "expiryTime", "", "expiryTimeUnit", "Ljava/util/concurrent/TimeUnit;", "listener", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "timeSource", "Lcom/google/common/base/Ticker;", "(Lcom/android/utils/ILogger;Lkotlin/jvm/functions/Function1;JLjava/util/concurrent/TimeUnit;Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;Lcom/google/common/base/Ticker;)V", "expiryTimeNanoSeconds", "latestDisplayId", "leasingAapt2Daemon", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "getLeasingAapt2Daemon", "()Lcom/android/builder/internal/aapt/v2/Aapt2;", "getLogger", "()Lcom/android/utils/ILogger;", "pool", "", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "leaseDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "maintain", "", "newAaptDaemon", "returnProcess", "key", "shutdown", "stats", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "takeExpiredDaemonsFromPool", "", "LeasableAaptDaemon", "LeasedAaptDaemon", "Listener", "NoOpListener", "Stats", "builder"})
@ThreadSafe
public final class Aapt2DaemonManager {
    @NotNull
    private final ILogger logger;
    @NotNull
    private final Function1<Integer, Aapt2Daemon> daemonFactory;
    @NotNull
    private final Listener listener;
    @NotNull
    private final Ticker timeSource;
    private final long expiryTimeNanoSeconds;
    @GuardedBy(value="this")
    private int latestDisplayId;
    @GuardedBy(value="this")
    @NotNull
    private final List<LeasableAaptDaemon> pool;
    @NotNull
    private final Aapt2 leasingAapt2Daemon;

    public Aapt2DaemonManager(@NotNull ILogger logger, @NotNull Function1<? super Integer, ? extends Aapt2Daemon> daemonFactory, long expiryTime, @NotNull TimeUnit expiryTimeUnit, @NotNull Listener listener, @NotNull Ticker timeSource) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter(daemonFactory, (String)"daemonFactory");
        Intrinsics.checkNotNullParameter((Object)((Object)expiryTimeUnit), (String)"expiryTimeUnit");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)timeSource, (String)"timeSource");
        this.logger = logger;
        this.daemonFactory = daemonFactory;
        this.listener = listener;
        this.timeSource = timeSource;
        this.expiryTimeNanoSeconds = expiryTimeUnit.toNanos(expiryTime);
        boolean bl2 = false;
        this.pool = new ArrayList();
        this.leasingAapt2Daemon = new Aapt2(this){
            final /* synthetic */ Aapt2DaemonManager this$0;
            {
                this.this$0 = $receiver;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it2 = (LeasedAaptDaemon)closeable;
                    boolean bl4 = false;
                    it2.compile(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it2 = (LeasedAaptDaemon)closeable;
                    boolean bl4 = false;
                    it2.link(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void convert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) {
                Intrinsics.checkNotNullParameter((Object)request, (String)"request");
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                Closeable closeable = this.this$0.leaseDaemon();
                boolean bl2 = false;
                boolean bl3 = false;
                Throwable throwable = null;
                try {
                    LeasedAaptDaemon it2 = (LeasedAaptDaemon)closeable;
                    boolean bl4 = false;
                    it2.convert(request, logger);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        };
    }

    public /* synthetic */ Aapt2DaemonManager(ILogger iLogger, Function1 function1, long l12, TimeUnit timeUnit, Listener listener, Ticker ticker, int n12, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n12 & 0x10) != 0) {
            listener = new NoOpListener();
        }
        if ((n12 & 0x20) != 0) {
            Ticker ticker2 = Ticker.systemTicker();
            Intrinsics.checkNotNullExpressionValue((Object)ticker2, (String)"systemTicker()");
            ticker = ticker2;
        }
        this(iLogger, (Function1<? super Integer, ? extends Aapt2Daemon>)function1, l12, timeUnit, listener, ticker);
    }

    @NotNull
    public final ILogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final synchronized LeasedAaptDaemon leaseDaemon() {
        Object v02;
        block1: {
            Iterable iterable = this.pool;
            boolean bl2 = false;
            Iterable iterable2 = iterable;
            boolean bl3 = false;
            for (Object t12 : iterable2) {
                LeasableAaptDaemon it2 = (LeasableAaptDaemon)t12;
                boolean bl4 = false;
                if (!(!it2.getBusy())) continue;
                v02 = t12;
                break block1;
            }
            v02 = null;
        }
        LeasableAaptDaemon leasableAaptDaemon = v02;
        LeasableAaptDaemon daemon = leasableAaptDaemon == null ? this.newAaptDaemon() : leasableAaptDaemon;
        daemon.setBusy(true);
        return new LeasedAaptDaemon(daemon, (Function1<? super LeasableAaptDaemon, Unit>)((Function1)new Function1<LeasableAaptDaemon, Unit>(this){

            public final void invoke(@NotNull LeasableAaptDaemon p02) {
                Intrinsics.checkNotNullParameter((Object)p02, (String)"p0");
                Aapt2DaemonManager.access$returnProcess((Aapt2DaemonManager)this.receiver, p02);
            }
        }));
    }

    public final void maintain() {
        List<LeasableAaptDaemon> expiredDaemons = this.takeExpiredDaemonsFromPool();
        Iterable $this$forEach$iv = expiredDaemons;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LeasableAaptDaemon it2 = (LeasableAaptDaemon)element$iv;
            boolean bl2 = false;
            it2.shutdown();
        }
    }

    public final synchronized void shutdown() {
        LeasableAaptDaemon it2;
        boolean bl2;
        boolean $i$f$any;
        Object $this$any$iv;
        block6: {
            $this$any$iv = this.pool;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                Iterator iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv = iterator.next();
                    it2 = (LeasableAaptDaemon)element$iv;
                    boolean bl3 = false;
                    if (!it2.getBusy()) continue;
                    bl2 = true;
                    break block6;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            $this$any$iv = "AAPT Process manager cannot be shut down while daemons are in use";
            $i$f$any = false;
            throw (Throwable)new IllegalStateException($this$any$iv.toString());
        }
        if (!this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        Iterable $this$forEach$iv = this.pool;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it2 = (LeasableAaptDaemon)element$iv;
            boolean bl4 = false;
            it2.shutdown();
        }
        this.pool.clear();
    }

    @GuardedBy(value="this")
    private final LeasableAaptDaemon newAaptDaemon() {
        Aapt2DaemonManager aapt2DaemonManager = this;
        int n12 = aapt2DaemonManager.latestDisplayId;
        aapt2DaemonManager.latestDisplayId = n12 + 1;
        int displayId = n12;
        Aapt2Daemon process = (Aapt2Daemon)this.daemonFactory.invoke((Object)displayId);
        LeasableAaptDaemon daemon = new LeasableAaptDaemon(process, this.timeSource.read(), false, 4, null);
        if (this.pool.isEmpty()) {
            this.listener.firstDaemonStarted(this);
        }
        this.pool.add(daemon);
        return daemon;
    }

    private final synchronized void returnProcess(LeasableAaptDaemon key) {
        if (key.getDaemon().getState() != Aapt2Daemon.State.RUNNING) {
            this.pool.remove(key);
            if (this.pool.isEmpty()) {
                this.listener.lastDaemonStopped();
            }
            return;
        }
        key.setLastUsedNanoSeconds(this.timeSource.read());
        key.setBusy(false);
    }

    private final synchronized List<LeasableAaptDaemon> takeExpiredDaemonsFromPool() {
        boolean bl2 = false;
        List expired = new ArrayList();
        long expireHorizon = this.timeSource.read() - this.expiryTimeNanoSeconds;
        ArrayList oldPool = new ArrayList(this.pool);
        this.pool.clear();
        for (LeasableAaptDaemon daemon : oldPool) {
            if (daemon.getBusy() || daemon.getLastUsedNanoSeconds() >= expireHorizon) {
                Intrinsics.checkNotNullExpressionValue((Object)daemon, (String)"daemon");
                this.pool.add(daemon);
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)daemon, (String)"daemon");
            expired.add(daemon);
        }
        if (this.pool.isEmpty()) {
            this.listener.lastDaemonStopped();
        }
        return expired;
    }

    @NotNull
    public final Aapt2 getLeasingAapt2Daemon() {
        return this.leasingAapt2Daemon;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final synchronized Stats stats() {
        int n12;
        int n13;
        void $this$count$iv;
        Iterable iterable = this.pool;
        int n14 = this.pool.size();
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n13 = 0;
        } else {
            void var3_4;
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                LeasableAaptDaemon it2 = (LeasableAaptDaemon)element$iv;
                boolean bl2 = false;
                if (!it2.getBusy()) continue;
                int n15 = ++count$iv;
                boolean bl3 = false;
                if (n15 >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n13 = var3_4;
        }
        int n16 = n12 = n13;
        int n17 = n14;
        return new Stats(n17, n16);
    }

    public static final /* synthetic */ void access$returnProcess(Aapt2DaemonManager $this, LeasableAaptDaemon key) {
        $this.returnProcess(key);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "", "daemon", "Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "lastUsedNanoSeconds", "", "busy", "", "(Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;JZ)V", "getBusy", "()Z", "setBusy", "(Z)V", "getDaemon", "()Lcom/android/builder/internal/aapt/v2/Aapt2Daemon;", "getLastUsedNanoSeconds", "()J", "setLastUsedNanoSeconds", "(J)V", "shutdown", "", "builder"})
    public static final class LeasableAaptDaemon {
        @NotNull
        private final Aapt2Daemon daemon;
        private long lastUsedNanoSeconds;
        private boolean busy;

        public LeasableAaptDaemon(@NotNull Aapt2Daemon daemon, long lastUsedNanoSeconds, boolean busy) {
            Intrinsics.checkNotNullParameter((Object)daemon, (String)"daemon");
            this.daemon = daemon;
            this.lastUsedNanoSeconds = lastUsedNanoSeconds;
            this.busy = busy;
        }

        public /* synthetic */ LeasableAaptDaemon(Aapt2Daemon aapt2Daemon, long l12, boolean bl2, int n12, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n12 & 4) != 0) {
                bl2 = false;
            }
            this(aapt2Daemon, l12, bl2);
        }

        @NotNull
        public final Aapt2Daemon getDaemon() {
            return this.daemon;
        }

        public final long getLastUsedNanoSeconds() {
            return this.lastUsedNanoSeconds;
        }

        public final void setLastUsedNanoSeconds(long l12) {
            this.lastUsedNanoSeconds = l12;
        }

        public final boolean getBusy() {
            return this.busy;
        }

        public final void setBusy(boolean bl2) {
            this.busy = bl2;
        }

        public final void shutdown() {
            this.daemon.shutDown();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B#\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000b\u001a\u00020\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasedAaptDaemon;", "Lcom/android/builder/internal/aapt/v2/Aapt2;", "Ljava/io/Closeable;", "leasableDaemon", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;", "closeAction", "Lkotlin/Function1;", "", "(Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$LeasableAaptDaemon;Lkotlin/jvm/functions/Function1;)V", "leaseValid", "", "close", "compile", "request", "Lcom/android/ide/common/resources/CompileResourceRequest;", "logger", "Lcom/android/utils/ILogger;", "convert", "Lcom/android/builder/internal/aapt/AaptConvertConfig;", "link", "Lcom/android/builder/internal/aapt/AaptPackageConfig;", "builder"})
    @NotThreadSafe
    public static final class LeasedAaptDaemon
    implements Aapt2,
    Closeable {
        @NotNull
        private final LeasableAaptDaemon leasableDaemon;
        @NotNull
        private final Function1<LeasableAaptDaemon, Unit> closeAction;
        private boolean leaseValid;

        public LeasedAaptDaemon(@NotNull LeasableAaptDaemon leasableDaemon, @NotNull Function1<? super LeasableAaptDaemon, Unit> closeAction) {
            Intrinsics.checkNotNullParameter((Object)leasableDaemon, (String)"leasableDaemon");
            Intrinsics.checkNotNullParameter(closeAction, (String)"closeAction");
            this.leasableDaemon = leasableDaemon;
            this.closeAction = closeAction;
            this.leaseValid = true;
        }

        @Override
        public void compile(@NotNull CompileResourceRequest request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().compile(request, logger);
        }

        @Override
        public void link(@NotNull AaptPackageConfig request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().link(request, logger);
        }

        @Override
        public void convert(@NotNull AaptConvertConfig request, @NotNull ILogger logger) throws Aapt2Exception {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.leasableDaemon.getDaemon().convert(request, logger);
        }

        @Override
        public void close() {
            Preconditions.checkState((boolean)this.leaseValid, (String)"Leased process is already closed", (Object[])new Object[0]);
            this.closeAction.invoke((Object)this.leasableDaemon);
            this.leaseValid = false;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\b\u0010\u0006\u001a\u00020\u0003H&\u00a8\u0006\u0007"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static interface Listener {
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager var1);

        public void lastDaemonStopped();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\b"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$NoOpListener;", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Listener;", "()V", "firstDaemonStarted", "", "manager", "Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager;", "lastDaemonStopped", "builder"})
    public static final class NoOpListener
    implements Listener {
        @Override
        public void firstDaemonStarted(@NotNull Aapt2DaemonManager manager) {
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        }

        @Override
        public void lastDaemonStopped() {
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/android/builder/internal/aapt/v2/Aapt2DaemonManager$Stats;", "", "poolSize", "", "busyCount", "(II)V", "getBusyCount", "()I", "getPoolSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "builder"})
    public static final class Stats {
        private final int poolSize;
        private final int busyCount;

        public Stats(int poolSize, int busyCount) {
            this.poolSize = poolSize;
            this.busyCount = busyCount;
        }

        public final int getPoolSize() {
            return this.poolSize;
        }

        public final int getBusyCount() {
            return this.busyCount;
        }

        public final int component1() {
            return this.poolSize;
        }

        public final int component2() {
            return this.busyCount;
        }

        @NotNull
        public final Stats copy(int poolSize, int busyCount) {
            return new Stats(poolSize, busyCount);
        }

        public static /* synthetic */ Stats copy$default(Stats stats, int n12, int n13, int n14, Object object) {
            if ((n14 & 1) != 0) {
                n12 = stats.poolSize;
            }
            if ((n14 & 2) != 0) {
                n13 = stats.busyCount;
            }
            return stats.copy(n12, n13);
        }

        @NotNull
        public String toString() {
            return "Stats(poolSize=" + this.poolSize + ", busyCount=" + this.busyCount + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.poolSize);
            result = result * 31 + Integer.hashCode(this.busyCount);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stats)) {
                return false;
            }
            Stats stats = (Stats)other;
            if (this.poolSize != stats.poolSize) {
                return false;
            }
            return this.busyCount == stats.busyCount;
        }
    }
}

