/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.packaging;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;

public interface JarCreator
extends Closeable {
    public static final Predicate<String> CLASSES_ONLY = archivePath -> archivePath.endsWith(".class");
    public static final Predicate<String> EXCLUDE_CLASSES = archivePath -> !archivePath.endsWith(".class");

    public static Predicate<String> allIgnoringDuplicateResources() {
        HashSet resources = new HashSet();
        return archivePath -> archivePath.endsWith(".class") || resources.add(archivePath);
    }

    public void addDirectory(Path var1) throws IOException;

    public void addDirectory(Path var1, Predicate<String> var2, Transformer var3, Relocator var4) throws IOException;

    public void addJar(Path var1) throws IOException;

    public void addJar(InputStream var1) throws IOException;

    public void addJar(Path var1, Predicate<String> var2, Relocator var3) throws IOException;

    public void addFile(String var1, Path var2) throws IOException;

    public void addEntry(String var1, InputStream var2) throws IOException;

    public void setCompressionLevel(int var1);

    public void setManifestProperties(Map<String, String> var1) throws IOException;

    public static interface Relocator {
        public String relocate(String var1);
    }

    public static interface Transformer {
        public InputStream filter(String var1, InputStream var2);
    }
}

