/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import shadow.bundletool.com.android.tools.r8.DataResource;
import shadow.bundletool.com.android.tools.r8.Keep;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;

@Keep
public interface DataEntryResource
extends DataResource {
    public InputStream getByteStream() throws ResourceException;

    public static DataEntryResource fromBytes(byte[] bytes, String name, Origin origin) {
        return new ByteDataEntryResource(bytes, name, origin);
    }

    public static DataEntryResource fromFile(Path dir, Path file) {
        return new LocalDataEntryResource(dir.resolve(file).toFile(), file.toString().replace(File.separatorChar, '/'));
    }

    public static DataEntryResource fromZip(ZipFile zip2, ZipEntry entry) {
        return new ZipDataEntryResource(zip2, entry);
    }

    default public DataEntryResource withName(String name) {
        return new NestedDataEntryResource(name, null, this);
    }

    public static class NestedDataEntryResource
    implements DataEntryResource {
        private final String name;
        private final Origin origin;
        private final DataEntryResource resource;

        public NestedDataEntryResource(String name, Origin origin, DataEntryResource resource) {
            this.name = name;
            this.origin = origin;
            this.resource = resource;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            return this.resource.getByteStream();
        }

        @Override
        public String getName() {
            return this.name != null ? this.name : this.resource.getName();
        }

        @Override
        public Origin getOrigin() {
            return this.origin != null ? this.origin : this.resource.getOrigin();
        }
    }

    public static class LocalDataEntryResource
    implements DataEntryResource {
        private final File file;
        private final String relativePath;

        private LocalDataEntryResource(File file, String relativePath) {
            assert (file != null);
            assert (relativePath != null);
            this.file = file;
            this.relativePath = relativePath;
        }

        @Override
        public Origin getOrigin() {
            return new PathOrigin(this.file.toPath());
        }

        @Override
        public String getName() {
            return this.relativePath;
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return new FileInputStream(this.file);
            }
            catch (IOException e) {
                throw new ResourceException(this.getOrigin(), (Throwable)e);
            }
        }
    }

    public static class ZipDataEntryResource
    implements DataEntryResource {
        private final ZipFile zip;
        private final ZipEntry entry;

        private ZipDataEntryResource(ZipFile zip2, ZipEntry entry) {
            assert (zip2 != null);
            assert (entry != null);
            this.zip = zip2;
            this.entry = entry;
        }

        @Override
        public Origin getOrigin() {
            return new ArchiveEntryOrigin(this.entry.getName(), new PathOrigin(Paths.get(this.zip.getName(), new String[0])));
        }

        @Override
        public String getName() {
            return this.entry.getName();
        }

        @Override
        public InputStream getByteStream() throws ResourceException {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new ResourceException(this.getOrigin(), (Throwable)e);
            }
        }
    }

    public static class ByteDataEntryResource
    implements DataEntryResource {
        private final byte[] bytes;
        private final String name;
        private final Origin origin;

        public ByteDataEntryResource(byte[] bytes, String name, Origin origin) {
            this.bytes = bytes;
            this.name = name;
            this.origin = origin;
        }

        @Override
        public InputStream getByteStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Origin getOrigin() {
            return this.origin;
        }
    }
}

