/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.cf.code;

import shadow.bundletool.com.android.tools.r8.cf.CfPrinter;
import shadow.bundletool.com.android.tools.r8.cf.code.CfInstruction;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.ir.code.Cmp;
import shadow.bundletool.com.android.tools.r8.ir.code.NumericType;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfSourceCode;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfState;
import shadow.bundletool.com.android.tools.r8.ir.conversion.IRBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.MethodVisitor;

public class CfCmp
extends CfInstruction {
    private final Cmp.Bias bias;
    private final NumericType type;

    public CfCmp(Cmp.Bias bias, NumericType type) {
        assert (bias != null);
        assert (type != null);
        assert (type == NumericType.LONG || type == NumericType.FLOAT || type == NumericType.DOUBLE);
        assert (type != NumericType.LONG || bias == Cmp.Bias.NONE);
        assert (type == NumericType.LONG || bias != Cmp.Bias.NONE);
        this.bias = bias;
        this.type = type;
    }

    public Cmp.Bias getBias() {
        return this.bias;
    }

    public NumericType getType() {
        return this.type;
    }

    public static CfCmp fromAsm(int opcode) {
        switch (opcode) {
            case 148: {
                return new CfCmp(Cmp.Bias.NONE, NumericType.LONG);
            }
            case 149: {
                return new CfCmp(Cmp.Bias.LT, NumericType.FLOAT);
            }
            case 150: {
                return new CfCmp(Cmp.Bias.GT, NumericType.FLOAT);
            }
            case 151: {
                return new CfCmp(Cmp.Bias.LT, NumericType.DOUBLE);
            }
            case 152: {
                return new CfCmp(Cmp.Bias.GT, NumericType.DOUBLE);
            }
        }
        throw new Unreachable("Wrong ASM opcode for CfCmp " + opcode);
    }

    public int getAsmOpcode() {
        switch (this.type) {
            case LONG: {
                return 148;
            }
            case FLOAT: {
                return this.bias == Cmp.Bias.LT ? 149 : 150;
            }
            case DOUBLE: {
                return this.bias == Cmp.Bias.LT ? 151 : 152;
            }
        }
        throw new Unreachable("CfCmp has unknown type " + (Object)((Object)this.type));
    }

    @Override
    public void print(CfPrinter printer) {
        printer.print(this);
    }

    @Override
    public void write(MethodVisitor visitor, NamingLens lens) {
        visitor.visitInsn(this.getAsmOpcode());
    }

    @Override
    public void buildIR(IRBuilder builder, CfState state, CfSourceCode code) {
        int right = state.pop().register;
        int left = state.pop().register;
        builder.addCmp(this.type, this.bias, state.push((ValueType)ValueType.INT).register, left, right);
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext, GraphLense graphLense, AppView<?> appView) {
        return inliningConstraints.forBinop();
    }
}

