/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.Descriptor;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.KeyedDexItem;
import shadow.bundletool.com.android.tools.r8.graph.ResolutionResult;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;
import shadow.bundletool.com.android.tools.r8.utils.InternalOptions;
import shadow.bundletool.com.android.tools.r8.utils.ListUtils;

public class AppInfo
implements DexDefinitionSupplier {
    private final DexApplication app;
    private final DexItemFactory dexItemFactory;
    private final ConcurrentHashMap<DexType, Map<Descriptor<?, ?>, KeyedDexItem<?>>> definitions = new ConcurrentHashMap();
    final ConcurrentHashMap<DexType, DexProgramClass> synthesizedClasses = new ConcurrentHashMap();
    private boolean obsolete;

    public AppInfo(DexApplication application) {
        this.app = application;
        this.dexItemFactory = this.app.dexItemFactory;
    }

    protected AppInfo(AppInfo previous) {
        assert (!previous.isObsolete());
        this.app = previous.app;
        this.dexItemFactory = this.app.dexItemFactory;
        this.definitions.putAll(previous.definitions);
        this.copyMetadataFromPrevious(previous);
    }

    protected InternalOptions options() {
        return this.app.options;
    }

    public void copyMetadataFromPrevious(AppInfo previous) {
        this.synthesizedClasses.putAll(previous.synthesizedClasses);
    }

    public boolean isObsolete() {
        return this.obsolete;
    }

    public void markObsolete() {
        this.obsolete = true;
    }

    public void unsetObsolete() {
        this.obsolete = false;
    }

    public boolean checkIfObsolete() {
        assert (!this.isObsolete());
        return true;
    }

    public DexApplication app() {
        assert (this.checkIfObsolete());
        return this.app;
    }

    @Override
    public DexItemFactory dexItemFactory() {
        assert (this.checkIfObsolete());
        return this.dexItemFactory;
    }

    public void addSynthesizedClass(DexProgramClass clazz) {
        assert (this.checkIfObsolete());
        assert (clazz.type.isD8R8SynthesizedClassType());
        DexProgramClass previous = this.synthesizedClasses.put(clazz.type, clazz);
        this.invalidateTypeCacheFor(clazz.type);
        assert (previous == null || previous == clazz);
    }

    public Collection<DexProgramClass> getSynthesizedClassesForSanityCheck() {
        assert (this.checkIfObsolete());
        return Collections.unmodifiableCollection(this.synthesizedClasses.values());
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> computeDefinitions(DexType type) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        DexClass clazz = this.definitionFor(type);
        if (clazz != null) {
            clazz.forEachMethod(method -> builder.put(method.getKey(), method));
            clazz.forEachField(field -> builder.put(field.getKey(), field));
        }
        return builder.build();
    }

    public Iterable<DexProgramClass> classes() {
        assert (this.checkIfObsolete());
        return this.app.classes();
    }

    public Iterable<DexProgramClass> classesWithDeterministicOrder() {
        assert (this.checkIfObsolete());
        return this.app.classesWithDeterministicOrder();
    }

    @Override
    public DexDefinition definitionFor(DexReference reference) {
        assert (this.checkIfObsolete());
        if (reference.isDexType()) {
            return this.definitionFor(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.definitionFor(reference.asDexMethod());
        }
        assert (reference.isDexField());
        return this.definitionFor(reference.asDexField());
    }

    @Override
    public DexClass definitionFor(DexType type) {
        assert (this.checkIfObsolete());
        DexProgramClass cached = this.synthesizedClasses.get(type);
        if (cached != null) {
            assert (this.app.definitionFor(type) == null);
            return cached;
        }
        return this.app.definitionFor(type);
    }

    public DexClass definitionForDesugarDependency(DexClass dependent, DexType type) {
        if (dependent.type == type) {
            return dependent;
        }
        DexClass definition = this.definitionFor(type);
        if (definition != null && !definition.isLibraryClass() && dependent.isProgramClass()) {
            InterfaceMethodRewriter.reportDependencyEdge(dependent.asProgramClass(), definition, this.options());
        }
        return definition;
    }

    @Override
    public DexProgramClass definitionForProgramType(DexType type) {
        return this.app.programDefinitionFor(type);
    }

    public Origin originFor(DexType type) {
        assert (this.checkIfObsolete());
        DexClass definition = this.app.definitionFor(type);
        return definition == null ? Origin.unknown() : definition.origin;
    }

    @Override
    public DexEncodedMethod definitionFor(DexMethod method) {
        assert (this.checkIfObsolete());
        DexType holderType = method.holder;
        DexEncodedMethod cached = (DexEncodedMethod)this.getDefinitions(holderType).get(method);
        if (cached != null && cached.isObsolete()) {
            this.definitions.remove(holderType);
            cached = (DexEncodedMethod)this.getDefinitions(holderType).get(method);
        }
        return cached;
    }

    @Override
    public DexEncodedField definitionFor(DexField field) {
        assert (this.checkIfObsolete());
        return (DexEncodedField)this.getDefinitions(field.holder).get(field);
    }

    private Map<Descriptor<?, ?>, KeyedDexItem<?>> getDefinitions(DexType type) {
        Map<Descriptor<?, ?>, KeyedDexItem<?>> typeDefinitions = this.definitions.get(type);
        if (typeDefinitions != null) {
            return typeDefinitions;
        }
        typeDefinitions = this.computeDefinitions(type);
        Map<Descriptor<?, ?>, KeyedDexItem<?>> existing = this.definitions.putIfAbsent(type, typeDefinitions);
        return existing != null ? existing : typeDefinitions;
    }

    public void invalidateTypeCacheFor(DexType type) {
        this.definitions.remove(type);
    }

    public DexEncodedMethod lookupStaticTarget(DexMethod method) {
        assert (this.checkIfObsolete());
        ResolutionResult resolutionResult = this.resolveMethod(method.holder, method);
        DexEncodedMethod target = resolutionResult.getSingleTarget();
        return target == null || target.isStatic() ? target : null;
    }

    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexType invocationContext) {
        assert (this.checkIfObsolete());
        assert (invocationContext.isClassType());
        DexClass context = this.definitionFor(invocationContext);
        return context == null ? null : this.lookupSuperTarget(method, context);
    }

    public DexEncodedMethod lookupSuperTarget(DexMethod method, DexClass invocationContext) {
        assert (this.checkIfObsolete());
        return this.resolveMethod(method.holder, method).lookupInvokeSuperTarget(invocationContext, this);
    }

    public DexEncodedMethod lookupDirectTarget(DexMethod method) {
        assert (this.checkIfObsolete());
        ResolutionResult resolutionResult = this.resolveMethod(method.holder, method);
        DexEncodedMethod target = resolutionResult.getSingleTarget();
        return target == null || target.isDirectMethod() ? target : null;
    }

    public DexEncodedMethod lookupVirtualTarget(DexType type, DexMethod method) {
        assert (this.checkIfObsolete());
        assert (type.isClassType() || type.isArrayType());
        ResolutionResult resolutionResult = this.resolveMethod(type, method);
        return resolutionResult.isVirtualTarget() ? resolutionResult.getSingleTarget() : null;
    }

    public ResolutionResult resolveMethod(DexType holder, DexMethod method) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return this.resolveMethodOnArray(holder, method);
        }
        DexClass definition = this.definitionFor(holder);
        if (definition == null) {
            return ResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        return this.resolveMethod(definition, method);
    }

    public ResolutionResult resolveMethod(DexClass holder, DexMethod method) {
        return holder.isInterface() ? this.resolveMethodOnInterface(holder, method) : this.resolveMethodOnClass(holder, method);
    }

    public ResolutionResult resolveMethod(DexType holder, DexMethod method, boolean isInterface) {
        assert (this.checkIfObsolete());
        return isInterface ? this.resolveMethodOnInterface(holder, method) : this.resolveMethodOnClass(holder, method);
    }

    private ResolutionResult resolveMethodOnArray(DexType holder, DexMethod method) {
        assert (this.checkIfObsolete());
        assert (holder.isArrayType());
        if (method.name == this.dexItemFactory.cloneMethodName) {
            return ResolutionResult.ArrayCloneMethodResult.INSTANCE;
        }
        return this.resolveMethodOnClass(this.dexItemFactory.objectType, method);
    }

    public ResolutionResult resolveMethodOnClass(DexType holder, DexMethod method) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return this.resolveMethodOnArray(holder, method);
        }
        DexClass clazz = this.definitionFor(holder);
        if (clazz == null) {
            return ResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        if (clazz.isInterface()) {
            return ResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        return this.resolveMethodOnClass(clazz, method);
    }

    public ResolutionResult resolveMethodOnClass(DexClass clazz, DexMethod method) {
        assert (this.checkIfObsolete());
        assert (!clazz.isInterface());
        ResolutionResult result = this.resolveMethodOnClassStep2(clazz, method, clazz);
        if (result != null) {
            return result;
        }
        return this.resolveMethodStep3(clazz, method);
    }

    private ResolutionResult resolveMethodOnClassStep2(DexClass clazz, DexMethod method, DexClass initialResolutionHolder) {
        DexClass superClass;
        DexEncodedMethod result = clazz.lookupSignaturePolymorphicMethod(method.name, this.dexItemFactory);
        if (result != null) {
            return new ResolutionResult.SingleResolutionResult(initialResolutionHolder, clazz, result);
        }
        result = clazz.lookupMethod(method);
        if (result != null) {
            if (result.isPrivateMethod() && clazz != initialResolutionHolder) {
                return new ResolutionResult.IllegalAccessOrNoSuchMethodResult(result);
            }
            return new ResolutionResult.SingleResolutionResult(initialResolutionHolder, clazz, result);
        }
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType)) != null) {
            return this.resolveMethodOnClassStep2(superClass, method, initialResolutionHolder);
        }
        return null;
    }

    public ResolutionResult resolveMaximallySpecificMethods(DexClass clazz, DexMethod method) {
        DexEncodedMethod result;
        assert (!clazz.type.isArrayType());
        if (clazz.isInterface() && (result = clazz.lookupMethod(method)) != null) {
            return new ResolutionResult.SingleResolutionResult(clazz, clazz, result);
        }
        return this.resolveMethodStep3(clazz, method);
    }

    private ResolutionResult resolveMethodStep3(DexClass clazz, DexMethod method) {
        MaximallySpecificMethodsBuilder builder = new MaximallySpecificMethodsBuilder(clazz);
        this.resolveMethodStep3Helper(clazz, method, builder);
        return builder.resolve();
    }

    private void resolveMethodStep3Helper(DexClass clazz, DexMethod method, MaximallySpecificMethodsBuilder builder) {
        DexClass superClass;
        for (DexType iface : clazz.interfaces.values) {
            DexClass definiton = this.definitionFor(iface);
            if (definiton == null) continue;
            assert (definiton.isInterface());
            DexEncodedMethod result = definiton.lookupMethod(method);
            if (this.isMaximallySpecificCandidate(result)) {
                builder.addCandidate(definiton, result, this);
                continue;
            }
            this.resolveMethodStep3Helper(definiton, method, builder);
        }
        if (clazz.superType != null && (superClass = this.definitionFor(clazz.superType)) != null) {
            this.resolveMethodStep3Helper(superClass, method, builder);
        }
    }

    private boolean isMaximallySpecificCandidate(DexEncodedMethod method) {
        return method != null && !method.accessFlags.isPrivate() && !method.accessFlags.isStatic();
    }

    public ResolutionResult resolveMethodOnInterface(DexType holder, DexMethod desc) {
        assert (this.checkIfObsolete());
        if (holder.isArrayType()) {
            return ResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        DexClass definition = this.definitionFor(holder);
        if (definition == null) {
            return ResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        if (!definition.isInterface()) {
            return ResolutionResult.IncompatibleClassResult.INSTANCE;
        }
        return this.resolveMethodOnInterface(definition, desc);
    }

    public ResolutionResult resolveMethodOnInterface(DexClass definition, DexMethod desc) {
        assert (this.checkIfObsolete());
        assert (definition.isInterface());
        DexEncodedMethod result = definition.lookupMethod(desc);
        if (result != null) {
            return new ResolutionResult.SingleResolutionResult(definition, definition, result);
        }
        DexClass objectClass = this.definitionFor(this.dexItemFactory.objectType);
        if (objectClass == null) {
            return ResolutionResult.ClassNotFoundResult.INSTANCE;
        }
        result = objectClass.lookupMethod(desc);
        if (result != null && result.accessFlags.isPublic() && !result.accessFlags.isAbstract()) {
            return new ResolutionResult.SingleResolutionResult(definition, objectClass, result);
        }
        return this.resolveMethodStep3(definition, desc);
    }

    public DexEncodedField lookupInstanceTarget(DexType type, DexField field) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        DexEncodedField result = this.resolveFieldOn(type, field);
        return result == null || result.accessFlags.isStatic() ? null : result;
    }

    public DexEncodedField lookupStaticTarget(DexType type, DexField field) {
        assert (this.checkIfObsolete());
        assert (type.isClassType());
        DexEncodedField result = this.resolveFieldOn(type, field);
        return result == null || !result.accessFlags.isStatic() ? null : result;
    }

    public DexEncodedField resolveField(DexField field) {
        assert (this.checkIfObsolete());
        return this.resolveFieldOn(field.holder, field);
    }

    public DexEncodedField resolveFieldOn(DexType type, DexField desc) {
        assert (this.checkIfObsolete());
        DexClass holder = this.definitionFor(type);
        return holder != null ? this.resolveFieldOn(holder, desc) : null;
    }

    public DexEncodedField resolveFieldOn(DexClass holder, DexField desc) {
        assert (this.checkIfObsolete());
        assert (holder != null);
        DexEncodedField result = holder.lookupField(desc);
        if (result != null) {
            return result;
        }
        for (DexType iface : holder.interfaces.values) {
            result = this.resolveFieldOn(iface, desc);
            if (result == null) continue;
            return result;
        }
        if (holder.superType != null && (result = this.resolveFieldOn(holder.superType, desc)) != null) {
            return result;
        }
        return null;
    }

    public boolean hasSubtyping() {
        assert (this.checkIfObsolete());
        return false;
    }

    public AppInfoWithSubtyping withSubtyping() {
        assert (this.checkIfObsolete());
        return null;
    }

    public boolean hasLiveness() {
        assert (this.checkIfObsolete());
        return false;
    }

    public AppInfoWithLiveness withLiveness() {
        assert (this.checkIfObsolete());
        return null;
    }

    public boolean isInMainDexList(DexType type) {
        assert (this.checkIfObsolete());
        return this.app.mainDexList.contains(type);
    }

    private static class MaximallySpecificMethodsBuilder {
        private final DexClass initialResolutionHolder;
        LinkedHashMap<DexClass, DexEncodedMethod> maximallySpecificMethods = new LinkedHashMap();

        public MaximallySpecificMethodsBuilder(DexClass initialResolutionHolder) {
            this.initialResolutionHolder = initialResolutionHolder;
        }

        void addCandidate(DexClass holder, DexEncodedMethod method, AppInfo appInfo) {
            if (this.maximallySpecificMethods.containsKey(holder)) {
                return;
            }
            this.maximallySpecificMethods.put(holder, method);
            assert (holder.isInterface());
            assert (holder.superType == ((AppInfo)appInfo).dexItemFactory.objectType);
            for (DexType iface : holder.interfaces.values) {
                this.markShadowed(iface, appInfo);
            }
        }

        private void markShadowed(DexType type, AppInfo appInfo) {
            if (type == null) {
                return;
            }
            DexClass clazz = appInfo.definitionFor(type);
            if (clazz == null) {
                return;
            }
            assert (clazz.isInterface());
            assert (clazz.superType == ((AppInfo)appInfo).dexItemFactory.objectType);
            if (this.maximallySpecificMethods.containsKey(clazz) && this.maximallySpecificMethods.get(clazz) == null) {
                return;
            }
            this.maximallySpecificMethods.put(clazz, null);
            for (DexType iface : clazz.interfaces.values) {
                this.markShadowed(iface, appInfo);
            }
        }

        ResolutionResult resolve() {
            if (this.maximallySpecificMethods.isEmpty()) {
                return ResolutionResult.NoSuchMethodResult.INSTANCE;
            }
            if (this.maximallySpecificMethods.size() == 1) {
                Map.Entry<DexClass, DexEncodedMethod> first = this.maximallySpecificMethods.entrySet().iterator().next();
                return new ResolutionResult.SingleResolutionResult(this.initialResolutionHolder, first.getKey(), first.getValue());
            }
            Map.Entry<DexClass, DexEncodedMethod> firstMaximallySpecificMethod = null;
            ArrayList<Map.Entry<DexClass, DexEncodedMethod>> nonAbstractMethods = new ArrayList<Map.Entry<DexClass, DexEncodedMethod>>(this.maximallySpecificMethods.size());
            for (Map.Entry<DexClass, DexEncodedMethod> entry : this.maximallySpecificMethods.entrySet()) {
                DexEncodedMethod method = entry.getValue();
                if (method == null) continue;
                if (firstMaximallySpecificMethod == null) {
                    firstMaximallySpecificMethod = entry;
                }
                if (!method.isNonAbstractVirtualMethod()) continue;
                nonAbstractMethods.add(entry);
            }
            if (nonAbstractMethods.isEmpty()) {
                return new ResolutionResult.SingleResolutionResult(this.initialResolutionHolder, (DexClass)firstMaximallySpecificMethod.getKey(), (DexEncodedMethod)firstMaximallySpecificMethod.getValue());
            }
            if (nonAbstractMethods.size() == 1) {
                Map.Entry entry = (Map.Entry)nonAbstractMethods.get(0);
                return new ResolutionResult.SingleResolutionResult(this.initialResolutionHolder, (DexClass)entry.getKey(), (DexEncodedMethod)entry.getValue());
            }
            return ResolutionResult.IncompatibleClassResult.create(ListUtils.map(nonAbstractMethods, Map.Entry::getValue));
        }
    }
}

