/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.IntIterator;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class DebugLocalInfo {
    public static final PrintLevel PRINT_LEVEL = PrintLevel.NAME;
    public final DexString name;
    public final DexType type;
    public final DexString signature;

    public DebugLocalInfo(DexString name, DexType type, DexString signature) {
        this.name = name;
        this.type = type;
        this.signature = signature;
    }

    public static boolean localsInfoMapsEqual(Int2ReferenceMap<DebugLocalInfo> set0, Int2ReferenceMap<DebugLocalInfo> set1) {
        if (set0 == null) {
            return set1 == null;
        }
        if (set1 == null) {
            return false;
        }
        if (set0.keySet().size() != set1.keySet().size()) {
            return false;
        }
        IntIterator intIterator = set0.keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            if (((DebugLocalInfo)set0.get(i)).equals(set1.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Int2ReferenceSortedMap<DebugLocalInfo> endingLocals(Int2ReferenceMap<DebugLocalInfo> previousLocals, Int2ReferenceMap<DebugLocalInfo> nextLocals) {
        Int2ReferenceAVLTreeMap<DebugLocalInfo> ending = new Int2ReferenceAVLTreeMap<DebugLocalInfo>();
        for (Int2ReferenceMap.Entry entry : previousLocals.int2ReferenceEntrySet()) {
            int register = entry.getIntKey();
            DebugLocalInfo local = (DebugLocalInfo)entry.getValue();
            if (nextLocals.get(register) == local) continue;
            ending.put(register, local);
        }
        return ending;
    }

    public static Int2ReferenceSortedMap<DebugLocalInfo> startingLocals(Int2ReferenceMap<DebugLocalInfo> previousLocals, Int2ReferenceMap<DebugLocalInfo> nextLocals) {
        Int2ReferenceAVLTreeMap<DebugLocalInfo> starting = new Int2ReferenceAVLTreeMap<DebugLocalInfo>();
        for (Int2ReferenceMap.Entry entry : nextLocals.int2ReferenceEntrySet()) {
            int register = entry.getIntKey();
            DebugLocalInfo local = (DebugLocalInfo)entry.getValue();
            if (previousLocals.get(register) == local) continue;
            starting.put(register, local);
        }
        return starting;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DebugLocalInfo)) {
            return false;
        }
        DebugLocalInfo o = (DebugLocalInfo)other;
        return this.name == o.name && this.type == o.type && this.signature == o.signature;
    }

    public int hashCode() {
        int hash = 7 * this.name.hashCode() + 13 * this.type.hashCode();
        if (this.signature != null) {
            hash += 31 * this.signature.hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.toString(PRINT_LEVEL);
    }

    public String toString(PrintLevel printLevel) {
        switch (printLevel) {
            case NONE: {
                return "";
            }
            case NAME: {
                return this.name.toString();
            }
            case FULL: {
                return this.name + ":" + (this.signature == null ? this.type : DescriptorUtils.descriptorToJavaType(this.signature.toString()));
            }
        }
        throw new Unreachable();
    }

    public static enum PrintLevel {
        NONE,
        NAME,
        FULL;

    }
}

