/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.Collection;
import java.util.function.Consumer;
import java.util.stream.Stream;
import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.dex.MixedSectionCollection;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;

public abstract class DexItem {
    static <T extends DexItem> void collectAll(IndexedItemCollection indexedItems, T[] items) {
        DexItem.consumeArray(items, (T item) -> item.collectIndexedItems(indexedItems));
    }

    public static <T extends DexItem> void collectAll(MixedSectionCollection mixedItems, T[] items) {
        DexItem.consumeArray(items, (T item) -> item.collectMixedSectionItems(mixedItems));
    }

    public static <T extends DexItem> void collectAll(MixedSectionCollection mixedItems, Collection<T> items) {
        items.forEach(item -> item.collectMixedSectionItems(mixedItems));
    }

    private static <T extends DexItem> void consumeArray(T[] items, Consumer<T> consumer) {
        if (items == null) {
            return;
        }
        for (T item : items) {
            if (item == null) continue;
            consumer.accept(item);
        }
    }

    abstract void collectIndexedItems(IndexedItemCollection var1, DexMethod var2, int var3);

    public void collectIndexedItems(IndexedItemCollection collection) {
        this.collectIndexedItems(collection, null, -1);
    }

    public void collectIndexedItems(IndexedItemCollection collection, DexMethod method) {
        this.collectIndexedItems(collection, method, -1);
    }

    abstract void collectMixedSectionItems(MixedSectionCollection var1);

    protected void flushCachedValues() {
    }

    public String toSmaliString() {
        return this.toString();
    }

    public String toSourceString() {
        return this.toString();
    }

    public boolean isDexReference() {
        return false;
    }

    public DexReference asDexReference() {
        return null;
    }

    public boolean isDexDefinition() {
        return false;
    }

    public DexDefinition asDexDefinition() {
        return null;
    }

    static <T extends DexItem> Stream<T> filter(Stream<DexItem> stream, Class<T> clazz) {
        return stream.filter(clazz::isInstance).map(clazz::cast);
    }
}

