/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import shadow.bundletool.com.android.tools.r8.dex.IndexedItemCollection;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.org.objectweb.asm.ClassWriter;

public final class EnclosingMethodAttribute {
    private DexType enclosingClass;
    private DexMethod enclosingMethod;

    public EnclosingMethodAttribute(DexType enclosingClass) {
        this.enclosingClass = enclosingClass;
    }

    public EnclosingMethodAttribute(DexMethod enclosingMethod) {
        this.enclosingMethod = enclosingMethod;
    }

    public void write(ClassWriter writer, NamingLens lens) {
        if (this.enclosingMethod != null) {
            writer.visitOuterClass(lens.lookupInternalName(this.enclosingMethod.holder), lens.lookupName(this.enclosingMethod).toString(), this.enclosingMethod.proto.toDescriptorString(lens));
        } else {
            writer.visitOuterClass(lens.lookupInternalName(this.enclosingClass), null, null);
        }
    }

    public DexMethod getEnclosingMethod() {
        return this.enclosingMethod;
    }

    public DexType getEnclosingClass() {
        return this.enclosingClass;
    }

    public int hashCode() {
        assert (this.enclosingClass == null != (this.enclosingMethod == null));
        return System.identityHashCode(this.enclosingClass) + System.identityHashCode(this.enclosingMethod);
    }

    public boolean equals(Object obj) {
        return obj instanceof EnclosingMethodAttribute && this.enclosingClass == ((EnclosingMethodAttribute)obj).enclosingClass && this.enclosingMethod == ((EnclosingMethodAttribute)obj).enclosingMethod;
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        if (this.enclosingClass != null) {
            this.enclosingClass.collectIndexedItems(indexedItems);
        }
        if (this.enclosingMethod != null) {
            this.enclosingMethod.collectIndexedItems(indexedItems);
        }
    }

    public String toString() {
        return "[enclosingClass: " + (this.enclosingClass == null ? "null" : this.enclosingClass.toDescriptorString()) + ", enclosingMethod: " + (this.enclosingMethod == null ? "null" : this.enclosingMethod.toSourceString()) + "]";
    }
}

