/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinitionSupplier;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoCollection;
import shadow.bundletool.com.android.tools.r8.graph.FieldAccessInfoImpl;
import shadow.bundletool.com.android.tools.r8.graph.GraphLense;
import shadow.bundletool.com.android.tools.r8.utils.SetUtils;

public class FieldAccessInfoCollectionImpl
implements FieldAccessInfoCollection<FieldAccessInfoImpl> {
    private Map<DexField, FieldAccessInfoImpl> infos = new IdentityHashMap<DexField, FieldAccessInfoImpl>();

    @Override
    public FieldAccessInfoImpl get(DexField field) {
        return this.infos.get(field);
    }

    public void extend(DexField field, FieldAccessInfoImpl info) {
        assert (!this.infos.containsKey(field));
        this.infos.put(field, info);
    }

    @Override
    public void forEach(Consumer<FieldAccessInfoImpl> consumer) {
        assert (this.verifyMappingIsOneToOne());
        this.infos.values().forEach(consumer);
    }

    public void removeIf(BiPredicate<DexField, FieldAccessInfoImpl> predicate) {
        this.infos.entrySet().removeIf((? super E entry) -> predicate.test((DexField)entry.getKey(), (FieldAccessInfoImpl)entry.getValue()));
    }

    public FieldAccessInfoCollectionImpl rewrittenWithLens(DexDefinitionSupplier definitions, GraphLense lens) {
        FieldAccessInfoCollectionImpl collection = new FieldAccessInfoCollectionImpl();
        this.infos.forEach((? super K field, ? super V info) -> collection.infos.put(lens.lookupField((DexField)field), info.rewrittenWithLens(definitions, lens)));
        return collection;
    }

    public boolean verifyMappingIsOneToOne() {
        assert (this.infos.values().size() == SetUtils.newIdentityHashSet(this.infos.values()).size());
        return true;
    }
}

