/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.fieldaccess;

import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.ir.code.And;
import shadow.bundletool.com.android.tools.r8.ir.code.FieldInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.LogicalBinop;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.BitAccessInfo;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.OptimizationFeedback;

public class FieldBitAccessAnalysis {
    private final AppView<? extends AppInfoWithSubtyping> appView;

    public FieldBitAccessAnalysis(AppView<? extends AppInfoWithSubtyping> appView) {
        assert (appView.enableWholeProgramOptimizations());
        this.appView = appView;
    }

    public void recordFieldAccesses(IRCode code, OptimizationFeedback feedback) {
        if (!code.metadata().mayHaveFieldInstruction()) {
            return;
        }
        for (Instruction instruction : code.instructions()) {
            DexEncodedField encodedField;
            if (!instruction.isFieldInstruction()) continue;
            FieldInstruction fieldInstruction = instruction.asFieldInstruction();
            DexField field = fieldInstruction.getField();
            if (!field.type.isIntType() || (encodedField = this.appView.appInfo().resolveField(field)) == null || !encodedField.isProgramField(this.appView) || BitAccessInfo.allBitsRead(encodedField.getOptimizationInfo().getReadBits()) || !fieldInstruction.isFieldGet()) continue;
            feedback.markFieldBitsRead(encodedField, this.computeBitsRead(fieldInstruction, encodedField));
        }
    }

    private int computeBitsRead(FieldInstruction instruction, DexEncodedField encodedField) {
        Value outValue = instruction.outValue();
        if (outValue.numberOfPhiUsers() > 0) {
            return BitAccessInfo.getAllBitsReadValue();
        }
        int bitsRead = BitAccessInfo.getNoBitsReadValue();
        for (Instruction user : outValue.uniqueUsers()) {
            if (this.isOnlyUsedToUpdateFieldValue(user, encodedField)) continue;
            if (user.isAnd()) {
                And andInstruction = user.asAnd();
                Value other = andInstruction.inValues().get(1 - andInstruction.inValues().indexOf(outValue)).getAliasedValue();
                if (other.isPhi() || !other.definition.isConstNumber()) {
                    return BitAccessInfo.getAllBitsReadValue();
                }
                bitsRead |= other.definition.asConstNumber().getIntValue();
                continue;
            }
            return BitAccessInfo.getAllBitsReadValue();
        }
        return bitsRead;
    }

    private boolean isOnlyUsedToUpdateFieldValue(Instruction user, DexEncodedField encodedField) {
        FieldInstruction fieldInstruction;
        if (user.isLogicalBinop()) {
            LogicalBinop binop = user.asLogicalBinop();
            Value outValue = binop.outValue();
            if (outValue.numberOfPhiUsers() > 0) {
                return false;
            }
            for (Instruction indirectUser : outValue.uniqueUsers()) {
                if (!indirectUser.isFieldPut()) {
                    return false;
                }
                if (indirectUser.asFieldInstruction().getField() == encodedField.field) continue;
                return false;
            }
            return true;
        }
        return user.isFieldPut() && (fieldInstruction = user.asFieldInstruction()).getField() == encodedField.field;
    }
}

