/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema;

import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.ir.analysis.proto.schema.ProtoFieldObject;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.FieldNameComputationInfo;

public class LiveProtoFieldObject
extends ProtoFieldObject {
    private final DexField field;

    public LiveProtoFieldObject(DexField field) {
        this.field = field;
    }

    public DexField getField() {
        return this.field;
    }

    @Override
    public Instruction buildIR(AppView<?> appView, IRCode code) {
        Value value = code.createValue(TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull()));
        BasicBlock.ThrowingInfo throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
        if (appView.options().isMinifying()) {
            return new DexItemBasedConstString(value, this.field, FieldNameComputationInfo.forFieldName(), throwingInfo);
        }
        return new ConstString(value, this.field.name, throwingInfo);
    }

    @Override
    public boolean isLiveProtoFieldObject() {
        return true;
    }

    @Override
    public LiveProtoFieldObject asLiveProtoFieldObject() {
        return this;
    }

    public String toString() {
        return "LiveProtoFieldObject(" + this.field.toSourceString() + ")";
    }
}

