/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.analysis.value;

import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppInfoWithSubtyping;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.value.SingleValue;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.TypeAndLocalInfoSupplier;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.optimize.MemberRebindingAnalysis;

public class SingleEnumValue
extends SingleValue {
    private final DexField field;

    SingleEnumValue(DexField field) {
        this.field = field;
    }

    @Override
    public boolean isSingleEnumValue() {
        return true;
    }

    @Override
    public SingleEnumValue asSingleEnumValue() {
        return this;
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public String toString() {
        return "SingleEnumValue(" + this.field.toSourceString() + ")";
    }

    @Override
    public Instruction createMaterializingInstruction(AppView<? extends AppInfoWithSubtyping> appView, IRCode code, TypeAndLocalInfoSupplier info) {
        TypeLatticeElement type = TypeLatticeElement.fromDexType(this.field.type, Nullability.maybeNull(), appView);
        assert (type.lessThanOrEqual(info.getTypeLattice(), appView));
        Value outValue = code.createValue(type, info.getLocalInfo());
        return new StaticGet(outValue, this.field);
    }

    @Override
    public boolean isMaterializableInContext(AppView<?> appView, DexType context) {
        DexEncodedField encodedField = ((AppInfo)appView.appInfo()).resolveField(this.field);
        return MemberRebindingAnalysis.isMemberVisibleFromOriginalContext(appView, context, encodedField.field.holder, encodedField.accessFlags);
    }
}

