/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.TypeVerificationHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfConstMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexMethodHandle;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Inliner;
import shadow.bundletool.com.android.tools.r8.ir.optimize.InliningConstraints;

public class ConstMethodHandle
extends ConstInstruction {
    private final DexMethodHandle methodHandle;

    public ConstMethodHandle(Value dest, DexMethodHandle methodHandle) {
        super(dest);
        this.methodHandle = methodHandle;
    }

    @Override
    public int opcode() {
        return 13;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static ConstMethodHandle copyOf(IRCode code, ConstMethodHandle original) {
        Value newValue = new Value(code.valueNumberGenerator.next(), original.outValue().getTypeLattice(), original.getLocalInfo());
        return ConstMethodHandle.copyOf(newValue, original);
    }

    public static ConstMethodHandle copyOf(Value newValue, ConstMethodHandle original) {
        return new ConstMethodHandle(newValue, original.getValue());
    }

    public Value dest() {
        return this.outValue;
    }

    public DexMethodHandle getValue() {
        return this.methodHandle;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int dest = builder.allocatedRegister(this.dest(), this.getNumber());
        builder.add((Instruction)this, (shadow.bundletool.com.android.tools.r8.code.Instruction)new shadow.bundletool.com.android.tools.r8.code.ConstMethodHandle(dest, this.methodHandle));
    }

    @Override
    public void buildCf(CfBuilder builder) {
        builder.add(new CfConstMethodHandle(this.methodHandle));
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return other.isConstMethodHandle() && other.asConstMethodHandle().methodHandle == this.methodHandle;
    }

    @Override
    public int maxInValueRegister() {
        assert (false) : "ConstMethodHandle has no register arguments.";
        return 0;
    }

    @Override
    public Inliner.ConstraintWithTarget inliningConstraint(InliningConstraints inliningConstraints, DexType invocationContext) {
        return inliningConstraints.forConstMethodHandle();
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        return super.toString() + " \"" + this.methodHandle + "\"";
    }

    @Override
    public boolean instructionTypeCanThrow() {
        return true;
    }

    @Override
    public boolean isOutConstant() {
        return true;
    }

    @Override
    public boolean isConstMethodHandle() {
        return true;
    }

    @Override
    public ConstMethodHandle asConstMethodHandle() {
        return this;
    }

    @Override
    public TypeLatticeElement evaluate(AppView<?> appView) {
        return TypeLatticeElement.fromDexType(appView.dexItemFactory().methodHandleType, Nullability.definitelyNotNull(), appView);
    }

    @Override
    public DexType computeVerificationType(AppView<?> appView, TypeVerificationHelper helper) {
        return appView.dexItemFactory().methodHandleType;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.storeOutValue(this, it);
    }
}

