/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;

public class IRMetadata {
    private long first;
    private long second;

    public IRMetadata() {
    }

    private IRMetadata(long first, long second) {
        this.first = first;
        this.second = second;
    }

    public static IRMetadata unknown() {
        return new IRMetadata(-1L, -1L);
    }

    private boolean get(int bit) {
        if (bit < 64) {
            return this.isAnySetInFirst(1L << bit);
        }
        assert (bit < 128);
        int adjusted = bit - 64;
        return this.isAnySetInSecond(1L << adjusted);
    }

    private boolean isAnySetInFirst(long mask) {
        return (this.first & mask) != 0L;
    }

    private boolean isAnySetInSecond(long mask) {
        return (this.second & mask) != 0L;
    }

    private void set(int bit) {
        if (bit < 64) {
            this.first |= 1L << bit;
        } else {
            assert (bit < 128);
            int adjusted = bit - 64;
            this.second |= 1L << adjusted;
        }
    }

    public void record(Instruction instruction) {
        this.set(instruction.opcode());
    }

    public void merge(IRMetadata metadata) {
        this.first |= metadata.first;
        this.second |= metadata.second;
    }

    public boolean mayHaveAdd() {
        return this.get(0);
    }

    public boolean mayHaveAnd() {
        return this.get(4);
    }

    public boolean mayHaveCheckCast() {
        return this.get(10);
    }

    public boolean mayHaveConstNumber() {
        return this.get(15);
    }

    public boolean mayHaveConstString() {
        return this.get(16);
    }

    public boolean mayHaveDebugPosition() {
        return this.get(19);
    }

    public boolean mayHaveDexItemBasedConstString() {
        return this.get(20);
    }

    public boolean mayHaveDiv() {
        return this.get(21);
    }

    public boolean mayHaveFieldGet() {
        return this.mayHaveInstanceGet() || this.mayHaveStaticGet();
    }

    public boolean mayHaveFieldInstruction() {
        long mask = 432345564898656256L;
        boolean result = this.isAnySetInFirst(mask);
        assert (result == (this.mayHaveInstanceGet() || this.mayHaveInstancePut() || this.mayHaveStaticGet() || this.mayHaveStaticPut()));
        return result;
    }

    public boolean mayHaveInstanceGet() {
        return this.get(27);
    }

    public boolean mayHaveInstancePut() {
        return this.get(29);
    }

    public boolean mayHaveInstanceOf() {
        return this.get(28);
    }

    public boolean mayHaveIntSwitch() {
        return this.get(30);
    }

    public boolean mayHaveInvokeDirect() {
        return this.get(32);
    }

    public boolean mayHaveInvokeInterface() {
        return this.get(33);
    }

    public boolean mayHaveInvokeMethod() {
        long mask = 0xF300000000L;
        boolean result = this.isAnySetInFirst(mask);
        assert (result == (this.mayHaveInvokeDirect() || this.mayHaveInvokeInterface() || this.mayHaveInvokePolymorphic() || this.mayHaveInvokeStatic() || this.mayHaveInvokeSuper() || this.mayHaveInvokeVirtual()));
        return result;
    }

    public boolean mayHaveInvokeMethodWithReceiver() {
        long mask = 0xC300000000L;
        boolean result = this.isAnySetInFirst(mask);
        assert (result == (this.mayHaveInvokeDirect() || this.mayHaveInvokeInterface() || this.mayHaveInvokeSuper() || this.mayHaveInvokeVirtual()));
        return result;
    }

    public boolean mayHaveInvokePolymorphic() {
        return this.get(36);
    }

    public boolean mayHaveInvokeStatic() {
        return this.get(37);
    }

    public boolean mayHaveInvokeSuper() {
        return this.get(38);
    }

    public boolean mayHaveInvokeVirtual() {
        return this.get(39);
    }

    public boolean mayHaveMonitorInstruction() {
        return this.get(41);
    }

    public boolean mayHaveMul() {
        return this.get(44);
    }

    public boolean mayHaveOr() {
        return this.get(51);
    }

    public boolean mayHaveRem() {
        return this.get(53);
    }

    public boolean mayHaveShl() {
        return this.get(55);
    }

    public boolean mayHaveShr() {
        return this.get(56);
    }

    public boolean mayHaveStaticGet() {
        return this.get(57);
    }

    public boolean mayHaveStaticPut() {
        return this.get(58);
    }

    public boolean mayHaveStringSwitch() {
        return this.get(60);
    }

    public boolean mayHaveSub() {
        return this.get(61);
    }

    public boolean mayHaveUshr() {
        return this.get(64);
    }

    public boolean mayHaveXor() {
        return this.get(65);
    }

    public boolean mayHaveArithmeticOrLogicalBinop() {
        boolean result;
        long mask = 2425205991527153683L;
        long other = 3L;
        boolean bl = result = this.isAnySetInFirst(mask) || this.isAnySetInSecond(other);
        assert (result == (this.mayHaveAdd() || this.mayHaveDiv() || this.mayHaveMul() || this.mayHaveRem() || this.mayHaveSub() || this.mayHaveAnd() || this.mayHaveOr() || this.mayHaveShl() || this.mayHaveShr() || this.mayHaveUshr() || this.mayHaveXor()));
        return result;
    }
}

