/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIf;
import shadow.bundletool.com.android.tools.r8.cf.code.CfIfCmp;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.InternalOutputMode;

public class If
extends JumpInstruction {
    private Type type;

    private static boolean verifyTypeCompatible(TypeLatticeElement valueType, Type ifType) {
        return valueType.isInt() || valueType.isFloat() && (ifType == Type.EQ || ifType == Type.NE) || valueType.isReference() && (ifType == Type.EQ || ifType == Type.NE);
    }

    public If(Type type, Value value) {
        super(value);
        this.type = type;
    }

    public If(Type type, List<Value> values2) {
        super(values2);
        this.type = type;
    }

    @Override
    public int opcode() {
        return 25;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public boolean isZeroTest() {
        return this.inValues.size() == 1;
    }

    public Value lhs() {
        return (Value)this.inValues.get(0);
    }

    public Value rhs() {
        assert (!this.isZeroTest());
        return (Value)this.inValues.get(1);
    }

    public Type getType() {
        return this.type;
    }

    public void invert() {
        BasicBlock tmp = this.getTrueTarget();
        this.setTrueTarget(this.fallthroughBlock());
        this.setFallthroughBlock(tmp);
        this.type = this.type.inverted();
    }

    public BasicBlock getTrueTarget() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 2);
        return successors.get(successors.size() - 2);
    }

    public void setTrueTarget(BasicBlock block) {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getMutableSuccessors();
        assert (successors.size() >= 2);
        successors.set(successors.size() - 2, block);
    }

    @Override
    public BasicBlock fallthroughBlock() {
        assert (this.getBlock().exit() == this);
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        assert (successors.size() >= 2);
        return successors.get(successors.size() - 1);
    }

    @Override
    public void setFallthroughBlock(BasicBlock block) {
        List<BasicBlock> successors = this.getBlock().getMutableSuccessors();
        successors.set(successors.size() - 1, block);
    }

    @Override
    public void buildDex(DexBuilder builder) {
        builder.addIf(this);
    }

    public static int estimatedSize(InternalOutputMode mode) {
        if (mode.isGeneratingClassFiles()) {
            return 3;
        }
        return 2;
    }

    @Override
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.type) + (this.isZeroTest() ? "Z" : " ") + " block " + this.getTrueTarget().getNumberAsString() + " (fallthrough " + this.fallthroughBlock().getNumberAsString() + ")";
    }

    @Override
    public int maxInValueRegister() {
        return this.isZeroTest() ? 255 : 15;
    }

    @Override
    public int maxOutValueRegister() {
        assert (false) : "If instructions define no values.";
        return 0;
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        printer.append(" B").append(this.getTrueTarget().getNumber());
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        if (!other.isIf()) {
            return false;
        }
        If o = other.asIf();
        return o.getTrueTarget() == this.getTrueTarget() && o.fallthroughBlock() == this.fallthroughBlock() && o.type == this.type;
    }

    public BasicBlock targetFromCondition(ConstNumber value) {
        assert (this.isZeroTest());
        assert (If.verifyTypeCompatible(value.outValue().getTypeLattice(), this.type));
        return this.targetFromCondition(Long.signum(value.getRawValue()));
    }

    public BasicBlock targetFromCondition(ConstNumber left, ConstNumber right) {
        assert (!this.isZeroTest());
        assert (left.outType() == right.outType());
        assert (If.verifyTypeCompatible(left.outValue().getTypeLattice(), this.type));
        return this.targetFromCondition(Long.signum(left.getRawValue() - right.getRawValue()));
    }

    public BasicBlock targetFromNonNullObject() {
        assert (this.isZeroTest());
        assert (((Value)this.inValues.get(0)).outType().isObject());
        return this.targetFromCondition(1);
    }

    public BasicBlock targetFromCondition(int cond) {
        assert (Integer.signum(cond) == cond);
        switch (this.type) {
            case EQ: {
                return cond == 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case NE: {
                return cond != 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case GE: {
                return cond >= 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case GT: {
                return cond > 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case LE: {
                return cond <= 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
            case LT: {
                return cond < 0 ? this.getTrueTarget() : this.fallthroughBlock();
            }
        }
        throw new Unreachable("Unexpected condition type " + (Object)((Object)this.type));
    }

    @Override
    public boolean isIf() {
        return true;
    }

    @Override
    public If asIf() {
        return this;
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        ValueType ifType = ((Value)this.inValues.get(0)).outType();
        if (this.inValues.size() == 1) {
            builder.add(new CfIf(this.type, ifType, builder.getLabel(this.getTrueTarget())));
            return;
        }
        assert (this.inValues.size() == 2);
        assert (((Value)this.inValues.get(0)).outType() == ((Value)this.inValues.get(1)).outType());
        builder.add(new CfIfCmp(this.type, ifType, builder.getLabel(this.getTrueTarget())));
    }

    public static enum Type {
        EQ,
        GE,
        GT,
        LE,
        LT,
        NE;


        public Type forSwappedOperands() {
            switch (this) {
                case EQ: 
                case NE: {
                    return this;
                }
                case GE: {
                    return LE;
                }
                case GT: {
                    return LT;
                }
                case LE: {
                    return GE;
                }
                case LT: {
                    return GT;
                }
            }
            throw new Unreachable("Unknown if condition type.");
        }

        public Type inverted() {
            switch (this) {
                case EQ: {
                    return NE;
                }
                case GE: {
                    return LT;
                }
                case GT: {
                    return LE;
                }
                case LE: {
                    return GT;
                }
                case LT: {
                    return GE;
                }
                case NE: {
                    return EQ;
                }
            }
            throw new Unreachable("Unknown if condition type.");
        }
    }
}

