/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.code;

import java.util.ArrayList;
import java.util.List;
import shadow.bundletool.com.android.tools.r8.cf.LoadStoreHelper;
import shadow.bundletool.com.android.tools.r8.cf.code.CfLabel;
import shadow.bundletool.com.android.tools.r8.cf.code.CfSwitch;
import shadow.bundletool.com.android.tools.r8.code.Nop;
import shadow.bundletool.com.android.tools.r8.code.PackedSwitch;
import shadow.bundletool.com.android.tools.r8.code.PackedSwitchPayload;
import shadow.bundletool.com.android.tools.r8.code.SparseSwitch;
import shadow.bundletool.com.android.tools.r8.code.SparseSwitchPayload;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionVisitor;
import shadow.bundletool.com.android.tools.r8.ir.code.Switch;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.conversion.CfBuilder;
import shadow.bundletool.com.android.tools.r8.ir.conversion.DexBuilder;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceAVLTreeMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.ints.Int2ReferenceSortedMap;
import shadow.bundletool.com.android.tools.r8.utils.CfgPrinter;
import shadow.bundletool.com.android.tools.r8.utils.IntObjConsumer;
import shadow.bundletool.com.android.tools.r8.utils.InternalOutputMode;

public class IntSwitch
extends Switch {
    private final int[] keys;

    public IntSwitch(Value value, int[] keys2, int[] targetBlockIndices, int fallthroughBlockIndex) {
        super(value, targetBlockIndices, fallthroughBlockIndex);
        this.keys = keys2;
        assert (this.valid());
    }

    @Override
    public int opcode() {
        return 30;
    }

    @Override
    public <T> T accept(InstructionVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void forEachCase(IntObjConsumer<BasicBlock> fn) {
        for (int i = 0; i < this.keys.length; ++i) {
            fn.accept(this.getKey(i), this.targetBlock(i));
        }
    }

    @Override
    public boolean valid() {
        assert (super.valid());
        assert (this.keys.length >= 1);
        assert (this.keys.length <= 65535);
        assert (this.keys.length == this.numberOfKeys());
        for (int i = 1; i < this.keys.length - 1; ++i) {
            assert (this.keys[i - 1] < this.keys[i]);
        }
        return true;
    }

    private static long numberOfTargetsIfPacked(int[] keys2) {
        return (long)keys2[keys2.length - 1] - (long)keys2[0] + 1L;
    }

    public static boolean canBePacked(InternalOutputMode mode, int[] keys2) {
        return IntSwitch.canBePacked(mode, IntSwitch.numberOfTargetsIfPacked(keys2));
    }

    public static boolean canBePacked(InternalOutputMode mode, long numberOfTargets) {
        return numberOfTargets <= (mode.isGeneratingClassFiles() ? 0xFFFFFFFFL : 65535L);
    }

    public static long estimatedSize(InternalOutputMode mode, int[] keys2) {
        long packedPayloadSize;
        long sparseSize = IntSwitch.sparsePayloadSize(mode, keys2) + (long)IntSwitch.baseSparseSize(mode);
        long packedSize = Long.MAX_VALUE;
        if (IntSwitch.canBePacked(mode, keys2) && (packedSize = (packedPayloadSize = IntSwitch.packedPayloadSize(mode, keys2)) + (long)IntSwitch.basePackedSize(mode)) < packedPayloadSize) {
            packedSize = Integer.MAX_VALUE;
        }
        return Math.min(sparseSize, packedSize);
    }

    public static long estimatedSparseSize(InternalOutputMode mode, long keys2) {
        return IntSwitch.sparsePayloadSize(mode, keys2) + (long)IntSwitch.baseSparseSize(mode);
    }

    public static int basePackedSize(InternalOutputMode mode) {
        if (mode.isGeneratingClassFiles()) {
            return 16;
        }
        return 3;
    }

    public static int baseSparseSize(InternalOutputMode mode) {
        if (mode.isGeneratingClassFiles()) {
            return 12;
        }
        return 3;
    }

    public static long packedPayloadSize(InternalOutputMode mode, long numberOfTargets) {
        if (mode.isGeneratingClassFiles()) {
            assert (numberOfTargets <= 0xFFFFFFFFL);
            return numberOfTargets * 4L;
        }
        return numberOfTargets * 2L + 4L;
    }

    public static long packedPayloadSize(InternalOutputMode mode, int[] keys2) {
        assert (IntSwitch.canBePacked(mode, keys2));
        long numberOfTargets = IntSwitch.numberOfTargetsIfPacked(keys2);
        return IntSwitch.packedPayloadSize(mode, numberOfTargets);
    }

    public static long sparsePayloadSize(InternalOutputMode mode, int[] keys2) {
        return IntSwitch.sparsePayloadSize(mode, keys2.length);
    }

    public static long sparsePayloadSize(InternalOutputMode mode, long keys2) {
        if (mode.isGeneratingClassFiles()) {
            return keys2 * 8L;
        }
        return keys2 * 4L + 2L;
    }

    private boolean canBePacked(InternalOutputMode mode) {
        return IntSwitch.canBePacked(mode, this.keys);
    }

    private long packedPayloadSize(InternalOutputMode mode) {
        return IntSwitch.packedPayloadSize(mode, this.keys);
    }

    private long sparsePayloadSize(InternalOutputMode mode) {
        return IntSwitch.sparsePayloadSize(mode, this.keys);
    }

    private boolean emitPacked(InternalOutputMode mode) {
        return this.canBePacked(mode) && this.packedPayloadSize(mode) <= this.sparsePayloadSize(mode);
    }

    public int getFirstKey() {
        return this.keys[0];
    }

    @Override
    public boolean isIntSwitch() {
        return true;
    }

    @Override
    public IntSwitch asIntSwitch() {
        return this;
    }

    @Override
    public boolean identicalNonValueNonPositionParts(Instruction other) {
        return false;
    }

    @Override
    public void buildDex(DexBuilder builder) {
        int value = builder.allocatedRegister(this.value(), this.getNumber());
        if (this.emitPacked(InternalOutputMode.DexIndexed)) {
            builder.addSwitch(this, new PackedSwitch(value));
        } else {
            builder.addSwitch(this, new SparseSwitch(value));
        }
    }

    public int getKey(int index) {
        return this.keys[index];
    }

    public int[] getKeys() {
        return this.keys;
    }

    public Int2ReferenceSortedMap<BasicBlock> getKeyToTargetMap() {
        Int2ReferenceAVLTreeMap<BasicBlock> result = new Int2ReferenceAVLTreeMap<BasicBlock>();
        for (int i = 0; i < this.keys.length; ++i) {
            result.put(this.getKey(i), this.targetBlock(i));
        }
        return result;
    }

    public Nop buildPayload(int[] targets, int fallthroughTarget, InternalOutputMode mode) {
        assert (this.keys.length == targets.length);
        assert (mode.isGeneratingDex());
        if (this.emitPacked(mode)) {
            int targetsCount = (int)IntSwitch.numberOfTargetsIfPacked(this.keys);
            if (targets.length == targetsCount) {
                return new PackedSwitchPayload(this.getFirstKey(), targets);
            }
            int[] packedTargets = new int[targetsCount];
            int originalIndex = 0;
            for (int i = 0; i < targetsCount; ++i) {
                int key = this.getFirstKey() + i;
                if (this.keys[originalIndex] == key) {
                    packedTargets[i] = targets[originalIndex];
                    ++originalIndex;
                    continue;
                }
                packedTargets[i] = fallthroughTarget;
            }
            assert (originalIndex == this.keys.length);
            return new PackedSwitchPayload(this.getFirstKey(), packedTargets);
        }
        assert (this.numberOfKeys() == this.keys.length);
        return new SparseSwitchPayload(this.keys, targets);
    }

    @Override
    public int maxInValueRegister() {
        return 255;
    }

    @Override
    public int maxOutValueRegister() {
        return 255;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString()).append(System.lineSeparator());
        for (int i = 0; i < this.numberOfKeys(); ++i) {
            builder.append("          ").append(this.getKey(i)).append(" -> ").append(this.targetBlock(i).getNumberAsString()).append(System.lineSeparator());
        }
        return builder.append("          F -> ").append(this.fallthroughBlock().getNumber()).toString();
    }

    @Override
    public void print(CfgPrinter printer) {
        super.print(printer);
        for (int index : this.targetBlockIndices()) {
            BasicBlock target = this.getBlock().getSuccessors().get(index);
            printer.append(" B").append(target.getNumber());
        }
    }

    @Override
    public void insertLoadAndStores(InstructionListIterator it, LoadStoreHelper helper) {
        helper.loadInValues(this, it);
    }

    @Override
    public void buildCf(CfBuilder builder) {
        CfLabel fallthroughLabel = builder.getLabel(this.fallthroughBlock());
        ArrayList<CfLabel> labels = new ArrayList<CfLabel>(this.numberOfKeys());
        List<BasicBlock> successors = this.getBlock().getSuccessors();
        if (this.emitPacked(InternalOutputMode.ClassFile)) {
            int min = this.keys[0];
            int max = this.keys[this.keys.length - 1];
            int index = 0;
            for (long i = (long)min; i <= (long)max; ++i) {
                if (i == (long)this.keys[index]) {
                    labels.add(builder.getLabel(successors.get(this.getTargetBlockIndex(index))));
                    ++index;
                    continue;
                }
                labels.add(fallthroughLabel);
            }
            assert (index == this.numberOfKeys());
            builder.add(new CfSwitch(CfSwitch.Kind.TABLE, fallthroughLabel, new int[]{min}, labels));
        } else {
            for (int index : this.targetBlockIndices()) {
                labels.add(builder.getLabel(successors.get(index)));
            }
            builder.add(new CfSwitch(CfSwitch.Kind.LOOKUP, fallthroughLabel, this.keys, labels));
        }
    }
}

