/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.desugar;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableMap;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.PrefixRewritingMapper;
import shadow.bundletool.com.android.tools.r8.utils.AndroidApiLevel;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.Pair;

public class DesugaredLibraryConfiguration {
    public static final String FALL_BACK_SYNTHESIZED_CLASSES_PACKAGE_PREFIX = "j$/";
    private final AndroidApiLevel requiredCompilationAPILevel;
    private final boolean libraryCompilation;
    private final String synthesizedLibraryClassesPackagePrefix;
    private final Map<String, String> rewritePrefix;
    private final Map<DexType, DexType> emulateLibraryInterface;
    private final Map<DexString, Map<DexType, DexType>> retargetCoreLibMember;
    private final Map<DexType, DexType> backportCoreLibraryMember;
    private final Map<DexType, DexType> customConversions;
    private final List<Pair<DexType, DexString>> dontRewriteInvocation;
    private final List<String> extraKeepRules;

    public static Builder builder(DexItemFactory dexItemFactory) {
        return new Builder(dexItemFactory);
    }

    public static DesugaredLibraryConfiguration withOnlyRewritePrefixForTesting(Map<String, String> prefix) {
        return new DesugaredLibraryConfiguration(AndroidApiLevel.B, false, FALL_BACK_SYNTHESIZED_CLASSES_PACKAGE_PREFIX, prefix, ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), ImmutableList.of());
    }

    public static DesugaredLibraryConfiguration empty() {
        return new DesugaredLibraryConfiguration(AndroidApiLevel.B, false, FALL_BACK_SYNTHESIZED_CLASSES_PACKAGE_PREFIX, ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableList.of(), ImmutableList.of());
    }

    public DesugaredLibraryConfiguration(AndroidApiLevel requiredCompilationAPILevel, boolean libraryCompilation, String packagePrefix, Map<String, String> rewritePrefix, Map<DexType, DexType> emulateLibraryInterface, Map<DexString, Map<DexType, DexType>> retargetCoreLibMember, Map<DexType, DexType> backportCoreLibraryMember, Map<DexType, DexType> customConversions, List<Pair<DexType, DexString>> dontRewriteInvocation, List<String> extraKeepRules) {
        this.requiredCompilationAPILevel = requiredCompilationAPILevel;
        this.libraryCompilation = libraryCompilation;
        this.synthesizedLibraryClassesPackagePrefix = packagePrefix;
        this.rewritePrefix = rewritePrefix;
        this.emulateLibraryInterface = emulateLibraryInterface;
        this.retargetCoreLibMember = retargetCoreLibMember;
        this.backportCoreLibraryMember = backportCoreLibraryMember;
        this.customConversions = customConversions;
        this.dontRewriteInvocation = dontRewriteInvocation;
        this.extraKeepRules = extraKeepRules;
    }

    public PrefixRewritingMapper createPrefixRewritingMapper(DexItemFactory factory) {
        return this.rewritePrefix.isEmpty() ? PrefixRewritingMapper.empty() : new PrefixRewritingMapper.DesugarPrefixRewritingMapper(this.rewritePrefix, factory);
    }

    public AndroidApiLevel getRequiredCompilationApiLevel() {
        return this.requiredCompilationAPILevel;
    }

    public boolean isLibraryCompilation() {
        return this.libraryCompilation;
    }

    public String getSynthesizedLibraryClassesPackagePrefix(AppView<?> appView) {
        return appView.options().isDesugaredLibraryCompilation() ? this.synthesizedLibraryClassesPackagePrefix : "";
    }

    public String getSynthesizedLibraryClassesPackagePrefix() {
        return this.synthesizedLibraryClassesPackagePrefix;
    }

    public Map<String, String> getRewritePrefix() {
        return this.rewritePrefix;
    }

    public Map<DexType, DexType> getEmulateLibraryInterface() {
        return this.emulateLibraryInterface;
    }

    public DexMethod retargetMethod(DexMethod method, AppView<?> appView) {
        Map<DexType, DexType> typeMap = this.retargetCoreLibMember.get(method.name);
        if (typeMap != null && typeMap.containsKey(method.holder)) {
            return appView.dexItemFactory().createMethod(typeMap.get(method.holder), appView.dexItemFactory().prependTypeToProto(method.holder, method.proto), method.name);
        }
        return null;
    }

    public Map<DexString, Map<DexType, DexType>> getRetargetCoreLibMember() {
        return this.retargetCoreLibMember;
    }

    public Map<DexType, DexType> getBackportCoreLibraryMember() {
        return this.backportCoreLibraryMember;
    }

    public Map<DexType, DexType> getCustomConversions() {
        return this.customConversions;
    }

    public List<Pair<DexType, DexString>> getDontRewriteInvocation() {
        return this.dontRewriteInvocation;
    }

    public List<String> getExtraKeepRules() {
        return this.extraKeepRules;
    }

    public static class Builder {
        private final DexItemFactory factory;
        private AndroidApiLevel requiredCompilationAPILevel;
        private boolean libraryCompilation = false;
        private String synthesizedLibraryClassesPackagePrefix = "j$/";
        private Map<String, String> rewritePrefix = new HashMap<String, String>();
        private Map<DexType, DexType> emulateLibraryInterface = new HashMap<DexType, DexType>();
        private Map<DexString, Map<DexType, DexType>> retargetCoreLibMember = new IdentityHashMap<DexString, Map<DexType, DexType>>();
        private Map<DexType, DexType> backportCoreLibraryMember = new HashMap<DexType, DexType>();
        private Map<DexType, DexType> customConversions = new HashMap<DexType, DexType>();
        private List<Pair<DexType, DexString>> dontRewriteInvocation = new ArrayList<Pair<DexType, DexString>>();
        private List<String> extraKeepRules = Collections.emptyList();

        public Builder(DexItemFactory dexItemFactory) {
            this.factory = dexItemFactory;
        }

        public Builder setSynthesizedLibraryClassesPackagePrefix(String prefix) {
            String replace;
            this.synthesizedLibraryClassesPackagePrefix = replace = prefix.replace('.', '/');
            return this;
        }

        public Builder setRequiredCompilationAPILevel(AndroidApiLevel requiredCompilationAPILevel) {
            this.requiredCompilationAPILevel = requiredCompilationAPILevel;
            return this;
        }

        public Builder setProgramCompilation() {
            this.libraryCompilation = false;
            return this;
        }

        public Builder setLibraryCompilation() {
            this.libraryCompilation = true;
            return this;
        }

        public Builder setExtraKeepRules(List<String> rules) {
            this.extraKeepRules = rules;
            return this;
        }

        public Builder putRewritePrefix(String prefix, String rewrittenPrefix) {
            this.rewritePrefix.put(prefix, rewrittenPrefix);
            return this;
        }

        public Builder putEmulateLibraryInterface(String emulateLibraryItf, String rewrittenEmulateLibraryItf) {
            DexType interfaceType = this.stringClassToDexType(emulateLibraryItf);
            DexType rewrittenType = this.stringClassToDexType(rewrittenEmulateLibraryItf);
            this.emulateLibraryInterface.put(interfaceType, rewrittenType);
            return this;
        }

        public Builder putCustomConversion(String type, String conversionHolder) {
            DexType dexType = this.stringClassToDexType(type);
            DexType conversionType = this.stringClassToDexType(conversionHolder);
            this.customConversions.put(dexType, conversionType);
            return this;
        }

        public Builder putRetargetCoreLibMember(String retarget, String rewrittenRetarget) {
            int index = this.sharpIndex(retarget, "retarget core library member");
            DexString methodName = this.factory.createString(retarget.substring(index + 1));
            this.retargetCoreLibMember.putIfAbsent(methodName, new IdentityHashMap());
            Map<DexType, DexType> typeMap = this.retargetCoreLibMember.get(methodName);
            DexType originalType = this.stringClassToDexType(retarget.substring(0, index));
            DexType finalType = this.stringClassToDexType(rewrittenRetarget);
            assert (!typeMap.containsKey(originalType));
            typeMap.put(originalType, finalType);
            return this;
        }

        public Builder putBackportCoreLibraryMember(String backport, String rewrittenBackport) {
            DexType backportType = this.stringClassToDexType(backport);
            DexType rewrittenBackportType = this.stringClassToDexType(rewrittenBackport);
            this.backportCoreLibraryMember.put(backportType, rewrittenBackportType);
            return this;
        }

        public Builder addDontRewriteInvocation(String dontRewriteInvocation) {
            int index = this.sharpIndex(dontRewriteInvocation, "don't rewrite");
            this.dontRewriteInvocation.add(new Pair<DexType, DexString>(this.stringClassToDexType(dontRewriteInvocation.substring(0, index)), this.factory.createString(dontRewriteInvocation.substring(index + 1))));
            return this;
        }

        private int sharpIndex(String typeAndSelector, String descr) {
            int index = typeAndSelector.lastIndexOf(35);
            if (index <= 0 || index >= typeAndSelector.length() - 1) {
                throw new CompilationError("Invalid " + descr + " specification (# position) in " + typeAndSelector + ".");
            }
            return index;
        }

        private DexType stringClassToDexType(String stringClass) {
            return this.factory.createType(DescriptorUtils.javaTypeToDescriptor(stringClass));
        }

        public DesugaredLibraryConfiguration build() {
            return new DesugaredLibraryConfiguration(this.requiredCompilationAPILevel, this.libraryCompilation, this.synthesizedLibraryClassesPackagePrefix, ImmutableMap.copyOf(this.rewritePrefix), ImmutableMap.copyOf(this.emulateLibraryInterface), ImmutableMap.copyOf(this.retargetCoreLibMember), ImmutableMap.copyOf(this.backportCoreLibraryMember), ImmutableMap.copyOf(this.customConversions), ImmutableList.copyOf(this.dontRewriteInvocation), ImmutableList.copyOf(this.extraKeepRules));
        }
    }
}

