/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.ClassTypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.JumpInstruction;
import shadow.bundletool.com.android.tools.r8.ir.code.Position;
import shadow.bundletool.com.android.tools.r8.ir.code.StaticGet;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.Assumer;
import shadow.bundletool.com.android.tools.r8.ir.optimize.info.MethodOptimizationInfo;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class DynamicTypeOptimization
implements Assumer {
    private final AppView<AppInfoWithLiveness> appView;

    public DynamicTypeOptimization(AppView<AppInfoWithLiveness> appView) {
        this.appView = appView;
    }

    @Override
    public void insertAssumeInstructionsInBlocks(IRCode code, ListIterator<BasicBlock> blockIterator, Predicate<BasicBlock> blockTester) {
        while (blockIterator.hasNext()) {
            BasicBlock block = blockIterator.next();
            if (!blockTester.test(block)) continue;
            this.insertAssumeDynamicTypeInstructionsInBlock(code, blockIterator, block);
        }
    }

    private void insertAssumeDynamicTypeInstructionsInBlock(IRCode code, ListIterator<BasicBlock> blockIterator, BasicBlock block) {
        InstructionListIterator instructionIterator = block.listIterator(code);
        while (instructionIterator.hasNext()) {
            ClassTypeLatticeElement dynamicLowerBoundType;
            TypeLatticeElement dynamicUpperBoundType;
            Instruction current = (Instruction)instructionIterator.next();
            if (!current.hasOutValue() || !current.outValue().isUsed()) continue;
            if (current.isInvokeMethod()) {
                MethodOptimizationInfo optimizationInfo;
                DexEncodedMethod singleTarget;
                InvokeMethod invoke = current.asInvokeMethod();
                DexType staticReturnTypeRaw = invoke.getInvokedMethod().proto.returnType;
                if (!staticReturnTypeRaw.isReferenceType() || (singleTarget = invoke.lookupSingleTarget(this.appView, code.method.method.holder)) == null || (optimizationInfo = singleTarget.getOptimizationInfo()).returnsArgument()) continue;
                dynamicUpperBoundType = optimizationInfo.getDynamicUpperBoundType();
                dynamicLowerBoundType = optimizationInfo.getDynamicLowerBoundType();
            } else {
                if (!current.isStaticGet()) continue;
                StaticGet staticGet = current.asStaticGet();
                DexEncodedField encodedField = this.appView.appInfo().resolveField(staticGet.getField());
                if (encodedField == null) continue;
                dynamicUpperBoundType = encodedField.getOptimizationInfo().getDynamicUpperBoundType();
                dynamicLowerBoundType = encodedField.getOptimizationInfo().getDynamicLowerBoundType();
            }
            Value outValue = current.outValue();
            boolean isTrivial = (dynamicUpperBoundType == null || !dynamicUpperBoundType.strictlyLessThan(outValue.getTypeLattice(), this.appView)) && dynamicLowerBoundType == null;
            if (isTrivial) continue;
            if (dynamicUpperBoundType == null) {
                dynamicUpperBoundType = outValue.getTypeLattice();
            }
            BasicBlock insertionBlock = block.hasCatchHandlers() ? instructionIterator.split(code, blockIterator) : block;
            Value specializedOutValue = code.createValue(outValue.getTypeLattice(), outValue.getLocalInfo());
            outValue.replaceUsers(specializedOutValue);
            Assume<Assume.DynamicTypeAssumption> assumeInstruction = Assume.createAssumeDynamicTypeInstruction(dynamicUpperBoundType, dynamicLowerBoundType, specializedOutValue, outValue, current, this.appView);
            assumeInstruction.setPosition(this.appView.options().debug ? current.getPosition() : Position.none());
            if (insertionBlock == block) {
                instructionIterator.add(assumeInstruction);
                continue;
            }
            insertionBlock.listIterator(code).add(assumeInstruction);
        }
    }

    public TypeLatticeElement computeDynamicReturnType(DexEncodedMethod method, IRCode code) {
        assert (method.method.proto.returnType.isReferenceType());
        ArrayList<TypeLatticeElement> returnedTypes = new ArrayList<TypeLatticeElement>();
        for (BasicBlock block : code.blocks) {
            JumpInstruction exitInstruction = block.exit();
            if (!exitInstruction.isReturn()) continue;
            Value returnValue = exitInstruction.asReturn().returnValue();
            returnedTypes.add(returnValue.getDynamicUpperBoundType(this.appView));
        }
        return returnedTypes.isEmpty() ? null : TypeLatticeElement.join(returnedTypes, this.appView);
    }

    public ClassTypeLatticeElement computeDynamicLowerBoundType(DexEncodedMethod method, IRCode code) {
        assert (method.method.proto.returnType.isReferenceType());
        ClassTypeLatticeElement result = null;
        for (BasicBlock block : code.blocks) {
            JumpInstruction exitInstruction = block.exit();
            if (!exitInstruction.isReturn()) continue;
            Value returnValue = exitInstruction.asReturn().returnValue();
            ClassTypeLatticeElement dynamicLowerBoundType = returnValue.getDynamicLowerBoundType(this.appView);
            if (dynamicLowerBoundType == null) {
                return null;
            }
            if (result == null) {
                result = dynamicLowerBoundType;
                continue;
            }
            if (dynamicLowerBoundType.equalUpToNullability(result)) {
                if (dynamicLowerBoundType.nullability() == result.nullability()) continue;
                result = dynamicLowerBoundType.join((TypeLatticeElement)result, this.appView).asClassTypeLatticeElement();
                continue;
            }
            return null;
        }
        return result;
    }
}

