/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.kotlin;

import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationSet;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProto;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.graph.EnclosingMethodAttribute;
import shadow.bundletool.com.android.tools.r8.graph.InnerClassAttribute;
import shadow.bundletool.com.android.tools.r8.graph.ParameterAnnotationsList;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroup;
import shadow.bundletool.com.android.tools.r8.ir.optimize.lambda.LambdaGroupId;

abstract class KotlinLambdaGroupId
implements LambdaGroupId {
    private static final int MISSING_INNER_CLASS_ATTRIBUTE = -1;
    private final int hash;
    final String capture;
    final DexType iface;
    final String pkg;
    final String signature;
    final DexString mainMethodName;
    final DexProto mainMethodProto;
    final DexAnnotationSet mainMethodAnnotations;
    final ParameterAnnotationsList mainMethodParamAnnotations;
    final EnclosingMethodAttribute enclosing;
    final int innerClassAccess;

    KotlinLambdaGroupId(String capture, DexType iface, String pkg, String signature, DexEncodedMethod mainMethod, InnerClassAttribute inner, EnclosingMethodAttribute enclosing) {
        assert (capture != null && iface != null && pkg != null && mainMethod != null);
        assert (inner == null || inner.isAnonymous() && inner.getOuter() == null);
        this.capture = capture;
        this.iface = iface;
        this.pkg = pkg;
        this.signature = signature;
        this.mainMethodName = mainMethod.method.name;
        this.mainMethodProto = mainMethod.method.proto;
        this.mainMethodAnnotations = mainMethod.annotations;
        this.mainMethodParamAnnotations = mainMethod.parameterAnnotationsList;
        this.innerClassAccess = inner != null ? inner.getAccess() : -1;
        this.enclosing = enclosing;
        this.hash = this.computeHashCode();
    }

    final boolean hasInnerClassAttribute() {
        return this.innerClassAccess != -1;
    }

    @Override
    public final int hashCode() {
        return this.hash;
    }

    private int computeHashCode() {
        int hash = this.capture.hashCode() * 7;
        hash += this.iface.hashCode() * 17;
        hash += this.pkg.hashCode() * 37;
        hash += this.signature != null ? this.signature.hashCode() * 47 : 0;
        hash += this.mainMethodName.hashCode() * 71;
        hash += this.mainMethodProto.hashCode() * 89;
        hash += this.mainMethodAnnotations != null ? this.mainMethodAnnotations.hashCode() * 101 : 0;
        hash += this.mainMethodParamAnnotations != null ? this.mainMethodParamAnnotations.hashCode() * 113 : 0;
        hash += this.innerClassAccess * 131;
        return hash += this.enclosing != null ? this.enclosing.hashCode() * 211 : 0;
    }

    @Override
    public abstract boolean equals(Object var1);

    boolean computeEquals(KotlinLambdaGroupId other) {
        return this.capture.equals(other.capture) && this.iface == other.iface && this.pkg.equals(other.pkg) && this.mainMethodName == other.mainMethodName && this.mainMethodProto == other.mainMethodProto && (this.mainMethodAnnotations == null ? other.mainMethodAnnotations == null : this.mainMethodAnnotations.equals(other.mainMethodAnnotations)) && (this.mainMethodParamAnnotations == null ? other.mainMethodParamAnnotations == null : this.mainMethodParamAnnotations.equals(other.mainMethodParamAnnotations)) && (this.signature == null ? other.signature == null : this.signature.equals(other.signature)) && this.innerClassAccess == other.innerClassAccess && (this.enclosing == null ? other.enclosing == null : this.enclosing.equals(other.enclosing));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getLambdaKindDescriptor()).append("\n  capture: ").append(this.capture).append("\n  interface: ").append(this.iface.descriptor).append("\n  package: ").append(this.pkg).append("\n  signature: ").append(this.signature).append("\n  main method name: ").append(this.mainMethodName.toString()).append("\n  main method: ").append(this.mainMethodProto.toSourceString()).append("\n  main annotations: ").append(this.mainMethodAnnotations).append("\n  main param annotations: ").append(this.mainMethodParamAnnotations).append("\n  inner: ").append(this.innerClassAccess == -1 ? "none" : Integer.valueOf(this.innerClassAccess));
        if (this.enclosing != null) {
            if (this.enclosing.getEnclosingClass() != null) {
                builder.append("\n  enclosingClass: ").append(this.enclosing.getEnclosingClass().descriptor);
            } else {
                builder.append("\n  enclosingMethod: ").append(this.enclosing.getEnclosingMethod().toSourceString());
            }
        }
        return builder.toString();
    }

    abstract String getLambdaKindDescriptor();

    @Override
    public abstract LambdaGroup createGroup();
}

