/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.string;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.com.google.common.annotations.VisibleForTesting;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysisConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.Assume;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DominatorTree;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.NumberConversion;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.code.ValueType;
import shadow.bundletool.com.android.tools.r8.ir.optimize.string.StringBuilderOptimizationConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.optimize.string.StringOptimizer;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class StringBuilderOptimizer {
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final BasicBlock.ThrowingInfo throwingInfo;
    @VisibleForTesting
    StringConcatenationAnalysis analysis;
    final StringBuilderOptimizationConfiguration optimizationConfiguration;
    private int numberOfBuildersWithMultipleToString = 0;
    private int numberOfBuildersWithoutToString = 0;
    private int numberOfBuildersThatEscape = 0;
    private int numberOfBuildersWhoseResultIsInterned = 0;
    private int numberOfBuildersWithNonTrivialStateChange = 0;
    private int numberOfBuildersWithUnsupportedArg = 0;
    private int numberOfBuildersWithMergingPoints = 0;
    private int numberOfBuildersWithNonDeterministicArg = 0;
    private int numberOfDeadBuilders = 0;
    private int numberOfBuildersSimplified = 0;
    private final Object2IntMap<Integer> histogramOfLengthOfAppendChains;
    private final Object2IntMap<Integer> histogramOfLengthOfEndResult;
    private final Object2IntMap<Integer> histogramOfLengthOfPartialAppendChains;
    private final Object2IntMap<Integer> histogramOfLengthOfPartialResult;

    public StringBuilderOptimizer(AppView<? extends AppInfo> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
        this.optimizationConfiguration = new DefaultStringBuilderOptimizationConfiguration();
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringBuilderOptimizer.class)) {
            this.histogramOfLengthOfAppendChains = new Object2IntArrayMap<Integer>();
            this.histogramOfLengthOfEndResult = new Object2IntArrayMap<Integer>();
            this.histogramOfLengthOfPartialAppendChains = new Object2IntArrayMap<Integer>();
            this.histogramOfLengthOfPartialResult = new Object2IntArrayMap<Integer>();
        } else {
            this.histogramOfLengthOfAppendChains = null;
            this.histogramOfLengthOfEndResult = null;
            this.histogramOfLengthOfPartialAppendChains = null;
            this.histogramOfLengthOfPartialResult = null;
        }
    }

    public void logResults() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# builders w/ multiple toString(): %s", this.numberOfBuildersWithMultipleToString);
        Log.info(this.getClass(), "# builders w/o toString(): %s", this.numberOfBuildersWithoutToString);
        Log.info(this.getClass(), "# builders that escape: %s", this.numberOfBuildersThatEscape);
        Log.info(this.getClass(), "# builders whose result is interned: %s", this.numberOfBuildersWhoseResultIsInterned);
        Log.info(this.getClass(), "# builders w/ non-trivial state change: %s", this.numberOfBuildersWithNonTrivialStateChange);
        Log.info(this.getClass(), "# builders w/ unsupported arg: %s", this.numberOfBuildersWithUnsupportedArg);
        Log.info(this.getClass(), "# builders w/ merging points: %s", this.numberOfBuildersWithMergingPoints);
        Log.info(this.getClass(), "# builders w/ non-deterministic arg: %s", this.numberOfBuildersWithNonDeterministicArg);
        Log.info(this.getClass(), "# dead builders : %s", this.numberOfDeadBuilders);
        Log.info(this.getClass(), "# builders simplified: %s", this.numberOfBuildersSimplified);
        if (this.histogramOfLengthOfAppendChains != null) {
            Log.info(this.getClass(), "------ histogram of StringBuilder append chain lengths ------", new Object[0]);
            this.histogramOfLengthOfAppendChains.forEach((chainSize, count) -> Log.info(this.getClass(), "%s: %s (%s)", chainSize, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.histogramOfLengthOfEndResult != null) {
            Log.info(this.getClass(), "------ histogram of StringBuilder result lengths ------", new Object[0]);
            this.histogramOfLengthOfEndResult.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.histogramOfLengthOfPartialAppendChains != null) {
            Log.info(this.getClass(), "------ histogram of StringBuilder append chain lengths (partial) ------", new Object[0]);
            this.histogramOfLengthOfPartialAppendChains.forEach((chainSize, count) -> Log.info(this.getClass(), "%s: %s (%s)", chainSize, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.histogramOfLengthOfPartialResult != null) {
            Log.info(this.getClass(), "------ histogram of StringBuilder partial result lengths ------", new Object[0]);
            this.histogramOfLengthOfPartialResult.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
        }
    }

    public void computeTrivialStringConcatenation(IRCode code) {
        StringConcatenationAnalysis analysis;
        this.analysis = analysis = new StringConcatenationAnalysis(code);
        Set candidateBuilders = analysis.findAllLocalBuilders().stream().filter(x$0 -> analysis.canBeOptimized(x$0)).collect(Collectors.toSet());
        if (candidateBuilders.isEmpty()) {
            return;
        }
        analysis.buildBuilderStateGraph(candidateBuilders).applyConcatenationResults(candidateBuilders).removeTrivialBuilders();
    }

    static class BuilderState {
        BuilderState previous = null;
        String addition = null;
        Set<BuilderState> nexts = null;

        private BuilderState() {
        }

        static BuilderState createRoot() {
            return new BuilderState();
        }

        BuilderState createChild(String addition) {
            BuilderState newState = new BuilderState();
            newState.previous = this;
            newState.addition = addition;
            if (this.nexts == null) {
                this.nexts = Sets.newIdentityHashSet();
            }
            this.nexts.add(newState);
            return newState;
        }
    }

    class StringBuilderOptimizerEscapeAnalysisConfiguration
    implements EscapeAnalysisConfiguration {
        final Value builder;
        final DexType builderType;

        private StringBuilderOptimizerEscapeAnalysisConfiguration(Value builder) {
            this.builder = builder;
            assert (builder.getTypeLattice().isClassType());
            this.builderType = builder.getTypeLattice().asClassTypeLatticeElement().getClassType();
        }

        private void logEscapingRoute(boolean legitimate) {
            if (!legitimate) {
                StringBuilderOptimizer.this.numberOfBuildersThatEscape++;
            }
        }

        @Override
        public boolean isLegitimateEscapeRoute(AppView<?> appView, EscapeAnalysis escapeAnalysis, Instruction escapeRoute, DexMethod context) {
            if (escapeRoute.isReturn() || escapeRoute.isThrow() || escapeRoute.isStaticPut()) {
                this.logEscapingRoute(false);
                return false;
            }
            if (escapeRoute.isInvokeMethod()) {
                DexClass holderClass = appView.definitionFor(escapeRoute.asInvokeMethod().getInvokedMethod().holder);
                if (holderClass != null && !holderClass.isLibraryClass()) {
                    this.logEscapingRoute(false);
                    return false;
                }
                InvokeMethod invoke = escapeRoute.asInvokeMethod();
                DexMethod invokedMethod = invoke.getInvokedMethod();
                if (invokedMethod.holder != this.builderType) {
                    this.logEscapingRoute(false);
                    return false;
                }
                if (StringBuilderOptimizer.this.optimizationConfiguration.isBuilderInit(invokedMethod, this.builderType)) {
                    return true;
                }
                if (StringBuilderOptimizer.this.optimizationConfiguration.isToStringMethod(invokedMethod)) {
                    Value out = escapeRoute.outValue();
                    if (out != null) {
                        for (Instruction outUser : out.uniqueUsers()) {
                            if (!outUser.isInvokeMethodWithReceiver() || outUser.asInvokeMethodWithReceiver().getInvokedMethod() != ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringMethods.intern) continue;
                            StringBuilderOptimizer.this.numberOfBuildersWhoseResultIsInterned++;
                            return false;
                        }
                    }
                    return true;
                }
                if (!StringBuilderOptimizer.this.optimizationConfiguration.isAppendMethod(invokedMethod)) {
                    StringBuilderOptimizer.this.numberOfBuildersWithNonTrivialStateChange++;
                    return false;
                }
                return StringBuilderOptimizer.this.optimizationConfiguration.isSupportedAppendMethod(invoke);
            }
            if (escapeRoute.isArrayPut()) {
                Value array = escapeRoute.asArrayPut().array().getAliasedValue();
                boolean legitimate = !array.isPhi() && array.definition.isCreatingArray();
                this.logEscapingRoute(legitimate);
                return legitimate;
            }
            if (escapeRoute.isInstancePut()) {
                Value instance = escapeRoute.asInstancePut().object().getAliasedValue();
                boolean legitimate = !instance.isPhi() && instance.definition.isNewInstance();
                this.logEscapingRoute(legitimate);
                return legitimate;
            }
            this.logEscapingRoute(false);
            return false;
        }
    }

    class DefaultStringBuilderOptimizationConfiguration
    implements StringBuilderOptimizationConfiguration {
        DefaultStringBuilderOptimizationConfiguration() {
        }

        @Override
        public boolean isBuilderType(DexType type) {
            return type == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBuilderType || type == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBufferType;
        }

        @Override
        public boolean isBuilderInit(DexMethod method, DexType builderType) {
            return builderType == method.holder && StringBuilderOptimizer.this.factory.isConstructor(method);
        }

        @Override
        public boolean isBuilderInit(DexMethod method) {
            return this.isBuilderType(method.holder) && StringBuilderOptimizer.this.factory.isConstructor(method);
        }

        @Override
        public boolean isBuilderInitWithInitialValue(InvokeMethod invoke) {
            return this.isBuilderInit(invoke.getInvokedMethod()) && invoke.inValues().size() == 2 && !invoke.inValues().get(1).getTypeLattice().isPrimitive();
        }

        @Override
        public boolean isAppendMethod(DexMethod method) {
            return ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBuilderMethods.isAppendMethod(method) || ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBufferMethods.isAppendMethod(method);
        }

        @Override
        public boolean isSupportedAppendMethod(InvokeMethod invoke) {
            DexMethod invokedMethod = invoke.getInvokedMethod();
            assert (this.isAppendMethod(invokedMethod));
            if (invoke.inValues().size() > 2) {
                StringBuilderOptimizer.this.numberOfBuildersWithNonTrivialStateChange++;
                return false;
            }
            assert (invoke.inValues().size() == 2);
            TypeLatticeElement argType = invoke.inValues().get(1).getTypeLattice();
            if (!(argType.isPrimitive() || argType.isClassType() || argType.isNullType())) {
                StringBuilderOptimizer.this.numberOfBuildersWithUnsupportedArg++;
                return false;
            }
            if (argType.isClassType()) {
                DexType argClassType = argType.asClassTypeLatticeElement().getClassType();
                return this.canHandleArgumentType(argClassType);
            }
            return true;
        }

        @Override
        public boolean isToStringMethod(DexMethod method) {
            return method == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBuilderMethods.toString || method == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringBufferMethods.toString;
        }

        private boolean canHandleArgumentType(DexType argType) {
            return argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.stringType || argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.charSequenceType;
        }
    }

    class StringConcatenationAnalysis {
        private static final int CONCATENATION_THRESHOLD = 200;
        private static final String ANY_STRING = "*";
        private static final String DUMMY = "$dummy$";
        private final IRCode code;
        final Object2IntMap<Value> builderToStringCounts = new Object2IntArrayMap<Value>();
        final Map<Value, Map<Instruction, BuilderState>> builderStates = new HashMap<Value, Map<Instruction, BuilderState>>();
        final Set<Value> deadBuilders = Sets.newIdentityHashSet();
        final Set<Value> simplifiedBuilders = Sets.newIdentityHashSet();

        StringConcatenationAnalysis(IRCode code) {
            this.code = code;
        }

        private Set<Value> findAllLocalBuilders() {
            for (Instruction instr : this.code.instructions()) {
                if (!instr.isNewInstance() || !StringBuilderOptimizer.this.optimizationConfiguration.isBuilderType(instr.asNewInstance().clazz)) continue;
                Value builder = instr.asNewInstance().dest();
                assert (!this.builderToStringCounts.containsKey(builder));
                this.builderToStringCounts.put(builder, 0);
            }
            if (this.builderToStringCounts.isEmpty()) {
                return ImmutableSet.of();
            }
            int concatenationCount = 0;
            for (Instruction instr : this.code.instructions()) {
                if (!instr.isInvokeVirtual()) continue;
                InvokeVirtual invoke = instr.asInvokeVirtual();
                DexMethod invokedMethod = invoke.getInvokedMethod();
                if (StringBuilderOptimizer.this.optimizationConfiguration.isAppendMethod(invokedMethod)) {
                    if (++concatenationCount <= 200) continue;
                    return ImmutableSet.of();
                }
                if (!StringBuilderOptimizer.this.optimizationConfiguration.isToStringMethod(invokedMethod)) continue;
                assert (invoke.inValues().size() == 1);
                Value receiver = invoke.getReceiver().getAliasedValue();
                for (Value builder : this.collectAllLinkedBuilders(receiver)) {
                    if (!this.builderToStringCounts.containsKey(builder)) continue;
                    int count = this.builderToStringCounts.getInt(builder);
                    this.builderToStringCounts.put(builder, count + 1);
                }
            }
            return this.builderToStringCounts.keySet();
        }

        private Set<Value> collectAllLinkedBuilders(Value builder) {
            Set<Value> builders = Sets.newIdentityHashSet();
            Set<Value> visited = Sets.newIdentityHashSet();
            this.collectAllLinkedBuilders(builder, builders, visited);
            return builders;
        }

        private void collectAllLinkedBuilders(Value builder, Set<Value> builders, Set<Value> visited) {
            if (!visited.add(builder)) {
                return;
            }
            if (builder.isPhi()) {
                for (Value operand : builder.asPhi().getOperands()) {
                    this.collectAllLinkedBuilders(operand, builders, visited);
                }
            } else {
                builders.add(builder);
            }
        }

        private boolean canBeOptimized(Value builder) {
            assert (!builder.isAlwaysNull(StringBuilderOptimizer.this.appView));
            assert (this.builderToStringCounts.containsKey(builder));
            if (this.builderToStringCounts.getInt(builder) > 1) {
                StringBuilderOptimizer.this.numberOfBuildersWithMultipleToString++;
                return false;
            }
            if (this.builderToStringCounts.getInt(builder) < 1) {
                StringBuilderOptimizer.this.numberOfBuildersWithoutToString++;
                return false;
            }
            assert (!builder.isPhi() && builder.definition.isNewInstance());
            assert (builder.getTypeLattice().isClassType());
            DexType builderType = builder.getTypeLattice().asClassTypeLatticeElement().getClassType();
            assert (StringBuilderOptimizer.this.optimizationConfiguration.isBuilderType(builderType));
            EscapeAnalysis escapeAnalysis = new EscapeAnalysis(StringBuilderOptimizer.this.appView, new StringBuilderOptimizerEscapeAnalysisConfiguration(builder));
            return !escapeAnalysis.isEscaping(this.code, builder);
        }

        private Map<Instruction, BuilderState> createBuilderState(Value builder) {
            return this.builderStates.computeIfAbsent(builder, ignore -> new LinkedHashMap());
        }

        private Map<Instruction, BuilderState> getBuilderState(Value builder) {
            return this.builderStates.get(builder);
        }

        private StringConcatenationAnalysis buildBuilderStateGraph(Set<Value> candidateBuilders) {
            DominatorTree dominatorTree = new DominatorTree(this.code, DominatorTree.Assumption.MAY_HAVE_UNREACHABLE_BLOCKS);
            for (BasicBlock block : this.code.topologicallySortedBlocks()) {
                for (Instruction instr : block.getInstructions()) {
                    BuilderState currentState;
                    BuilderState dominantState;
                    Map<Instruction, BuilderState> perInstrState;
                    String addition;
                    DexType argType;
                    Value arg;
                    Value builder;
                    InvokeMethodWithReceiver invoke;
                    if (instr.isNewInstance() && StringBuilderOptimizer.this.optimizationConfiguration.isBuilderType(instr.asNewInstance().clazz)) {
                        Value builder2 = instr.asNewInstance().dest();
                        if (!candidateBuilders.contains(builder2)) continue;
                        Map<Instruction, BuilderState> perInstrState2 = this.createBuilderState(builder2);
                        perInstrState2.put(instr, BuilderState.createRoot());
                        continue;
                    }
                    if (instr.isInvokeDirect() && StringBuilderOptimizer.this.optimizationConfiguration.isBuilderInitWithInitialValue(instr.asInvokeDirect())) {
                        invoke = instr.asInvokeDirect();
                        builder = invoke.getReceiver().getAliasedValue();
                        if (!candidateBuilders.contains(builder)) continue;
                        assert (invoke.inValues().size() == 2);
                        arg = invoke.inValues().get(1).getAliasedValue();
                        argType = invoke.getInvokedMethod().proto.parameters.values[0];
                        addition = this.extractConstantArgument(arg, argType);
                        perInstrState = this.getBuilderState(builder);
                        dominantState = this.findDominantState(dominatorTree, perInstrState, instr);
                        if (dominantState != null) {
                            currentState = dominantState.createChild(addition);
                            perInstrState.put(instr, currentState);
                            continue;
                        }
                        candidateBuilders.remove(builder);
                        continue;
                    }
                    if (!instr.isInvokeMethodWithReceiver()) continue;
                    invoke = instr.asInvokeMethodWithReceiver();
                    if (StringBuilderOptimizer.this.optimizationConfiguration.isAppendMethod(invoke.getInvokedMethod())) {
                        builder = invoke.getReceiver().getAliasedValue();
                        if (!candidateBuilders.contains(builder)) continue;
                        arg = invoke.inValues().get(1).getAliasedValue();
                        argType = invoke.getInvokedMethod().proto.parameters.values[0];
                        addition = this.extractConstantArgument(arg, argType);
                        perInstrState = this.getBuilderState(builder);
                        dominantState = this.findDominantState(dominatorTree, perInstrState, instr);
                        if (dominantState != null) {
                            currentState = dominantState.createChild(addition);
                            perInstrState.put(instr, currentState);
                        } else {
                            candidateBuilders.remove(builder);
                        }
                    }
                    if (!StringBuilderOptimizer.this.optimizationConfiguration.isToStringMethod(invoke.getInvokedMethod()) || !candidateBuilders.contains(builder = invoke.getReceiver().getAliasedValue())) continue;
                    Map<Instruction, BuilderState> perInstrState3 = this.getBuilderState(builder);
                    BuilderState dominantState2 = this.findDominantState(dominatorTree, perInstrState3, instr);
                    if (dominantState2 != null) {
                        BuilderState currentState2 = dominantState2.createChild("");
                        perInstrState3.put(instr, currentState2);
                        continue;
                    }
                    candidateBuilders.remove(builder);
                }
            }
            return this;
        }

        private String extractConstantArgument(Value arg, DexType argType) {
            String addition = ANY_STRING;
            if (arg.isPhi()) {
                return addition;
            }
            if (arg.definition.isConstString()) {
                addition = arg.definition.asConstString().getValue().toString();
            } else if (arg.definition.isConstNumber() || arg.definition.isNumberConversion()) {
                Number number = this.extractConstantNumber(arg);
                if (number == null) {
                    return addition;
                }
                if (arg.getTypeLattice().isPrimitive()) {
                    if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.booleanType) {
                        addition = String.valueOf(number.intValue() != 0);
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.byteType) {
                        addition = String.valueOf(number.byteValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.shortType) {
                        addition = String.valueOf(number.shortValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.charType) {
                        addition = String.valueOf((char)number.intValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.intType) {
                        addition = String.valueOf(number.intValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.longType) {
                        addition = String.valueOf(number.longValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.floatType) {
                        addition = String.valueOf(number.floatValue());
                    } else if (argType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.doubleType) {
                        addition = String.valueOf(number.doubleValue());
                    }
                } else if (arg.getTypeLattice().isNullType()) {
                    assert (number.intValue() == 0);
                    addition = "null";
                }
            }
            return addition;
        }

        private Number extractConstantNumber(Value arg) {
            if (arg.isPhi()) {
                return null;
            }
            if (arg.definition.isConstNumber()) {
                ConstNumber cst = arg.definition.asConstNumber();
                if (cst.outType() == ValueType.LONG) {
                    return cst.getLongValue();
                }
                if (cst.outType() == ValueType.FLOAT) {
                    return Float.valueOf(cst.getFloatValue());
                }
                if (cst.outType() == ValueType.DOUBLE) {
                    return cst.getDoubleValue();
                }
                assert (cst.outType() == ValueType.INT || cst.outType() == ValueType.OBJECT);
                return cst.getIntValue();
            }
            if (arg.definition.isNumberConversion()) {
                NumberConversion conversion = arg.definition.asNumberConversion();
                assert (conversion.inValues().size() == 1);
                Number temp = this.extractConstantNumber(conversion.inValues().get(0));
                if (temp == null) {
                    return null;
                }
                DexType conversionType = conversion.to.dexTypeFor(StringBuilderOptimizer.this.factory);
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.booleanType) {
                    return temp.intValue() != 0 ? 1 : 0;
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.byteType) {
                    return temp.byteValue();
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.shortType) {
                    return temp.shortValue();
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.charType) {
                    return temp.intValue();
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.intType) {
                    return temp.intValue();
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.longType) {
                    return temp.longValue();
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.floatType) {
                    return Float.valueOf(temp.floatValue());
                }
                if (conversionType == ((StringBuilderOptimizer)StringBuilderOptimizer.this).factory.doubleType) {
                    return temp.doubleValue();
                }
            }
            return null;
        }

        private BuilderState findDominantState(DominatorTree dominatorTree, Map<Instruction, BuilderState> perInstrState, Instruction current) {
            BuilderState result = null;
            BasicBlock lastDominantBlock = null;
            for (Instruction instr : perInstrState.keySet()) {
                BasicBlock block = instr.getBlock();
                if (!dominatorTree.dominatedBy(current.getBlock(), block) || lastDominantBlock != null && !dominatorTree.dominatedBy(block, lastDominantBlock)) continue;
                result = perInstrState.get(instr);
                lastDominantBlock = block;
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logHistogramOfChains(List<String> contents, boolean isPartial) {
            int count;
            if (!Log.ENABLED || !Log.isLoggingEnabledFor(StringOptimizer.class)) {
                return;
            }
            if (contents == null || contents.isEmpty()) {
                return;
            }
            String result = StringUtils.join(contents, "");
            Integer size = contents.size();
            Integer length = result.length();
            if (isPartial) {
                int count2;
                assert (StringBuilderOptimizer.this.histogramOfLengthOfPartialAppendChains != null);
                Object2IntMap object2IntMap = StringBuilderOptimizer.this.histogramOfLengthOfPartialAppendChains;
                synchronized (object2IntMap) {
                    count2 = StringBuilderOptimizer.this.histogramOfLengthOfPartialAppendChains.getOrDefault(size, 0);
                    StringBuilderOptimizer.this.histogramOfLengthOfPartialAppendChains.put(size, count2 + 1);
                }
                assert (StringBuilderOptimizer.this.histogramOfLengthOfPartialResult != null);
                object2IntMap = StringBuilderOptimizer.this.histogramOfLengthOfPartialResult;
                synchronized (object2IntMap) {
                    count2 = StringBuilderOptimizer.this.histogramOfLengthOfPartialResult.getOrDefault(length, 0);
                    StringBuilderOptimizer.this.histogramOfLengthOfPartialResult.put(length, count2 + 1);
                }
            }
            assert (StringBuilderOptimizer.this.histogramOfLengthOfAppendChains != null);
            Object2IntMap object2IntMap = StringBuilderOptimizer.this.histogramOfLengthOfAppendChains;
            synchronized (object2IntMap) {
                count = StringBuilderOptimizer.this.histogramOfLengthOfAppendChains.getOrDefault(size, 0);
                StringBuilderOptimizer.this.histogramOfLengthOfAppendChains.put(size, count + 1);
            }
            assert (StringBuilderOptimizer.this.histogramOfLengthOfEndResult != null);
            object2IntMap = StringBuilderOptimizer.this.histogramOfLengthOfEndResult;
            synchronized (object2IntMap) {
                count = StringBuilderOptimizer.this.histogramOfLengthOfEndResult.getOrDefault(length, 0);
                StringBuilderOptimizer.this.histogramOfLengthOfEndResult.put(length, count + 1);
            }
        }

        private StringConcatenationAnalysis applyConcatenationResults(Set<Value> candidateBuilders) {
            Instruction instr;
            Set<Value> affectedValues = Sets.newIdentityHashSet();
            InstructionListIterator it = this.code.instructionListIterator();
            while (it.hasNext() && (instr = it.nextUntil(i -> this.isToStringOfInterest(candidateBuilders, (Instruction)i))) != null) {
                InvokeVirtual invoke = instr.asInvokeVirtual();
                assert (invoke.inValues().size() == 1);
                Value builder = invoke.getReceiver().getAliasedValue();
                Value outValue = invoke.outValue();
                if (outValue == null || outValue.isDead(StringBuilderOptimizer.this.appView, this.code)) {
                    if (outValue != null && outValue.isUsed()) {
                        Value dummy = this.code.createValue(TypeLatticeElement.stringClassType(StringBuilderOptimizer.this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                        it.replaceCurrentInstruction(new ConstString(dummy, StringBuilderOptimizer.this.factory.createString(DUMMY), StringBuilderOptimizer.this.throwingInfo));
                    } else {
                        it.removeOrReplaceByDebugLocalRead();
                    }
                    this.deadBuilders.add(builder);
                    StringBuilderOptimizer.this.numberOfDeadBuilders++;
                    continue;
                }
                Map<Instruction, BuilderState> perInstrState = this.builderStates.get(builder);
                assert (perInstrState != null);
                BuilderState builderState = perInstrState.get(instr);
                assert (builderState != null);
                String element = this.toCompileTimeString(builderState);
                assert (element != null);
                Value stringValue = this.code.createValue(TypeLatticeElement.stringClassType(StringBuilderOptimizer.this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                affectedValues.addAll(outValue.affectedValues());
                it.replaceCurrentInstruction(new ConstString(stringValue, StringBuilderOptimizer.this.factory.createString(element), StringBuilderOptimizer.this.throwingInfo));
                this.simplifiedBuilders.add(builder);
                StringBuilderOptimizer.this.numberOfBuildersSimplified++;
            }
            if (!affectedValues.isEmpty()) {
                new TypeAnalysis(StringBuilderOptimizer.this.appView).narrowing(affectedValues);
            }
            return this;
        }

        private boolean isToStringOfInterest(Set<Value> candidateBuilders, Instruction instr) {
            if (!instr.isInvokeVirtual()) {
                return false;
            }
            InvokeVirtual invoke = instr.asInvokeVirtual();
            DexMethod invokedMethod = invoke.getInvokedMethod();
            if (!StringBuilderOptimizer.this.optimizationConfiguration.isToStringMethod(invokedMethod)) {
                return false;
            }
            assert (invoke.inValues().size() == 1);
            Value builder = invoke.getReceiver().getAliasedValue();
            if (!candidateBuilders.contains(builder)) {
                return false;
            }
            if (!invoke.hasOutValue() || invoke.outValue().isDead(StringBuilderOptimizer.this.appView, this.code)) {
                return true;
            }
            Map<Instruction, BuilderState> perInstrState = this.builderStates.get(builder);
            if (perInstrState == null) {
                return false;
            }
            BuilderState builderState = perInstrState.get(instr);
            if (builderState == null) {
                return false;
            }
            String element = this.toCompileTimeString(builderState);
            return element != null;
        }

        @VisibleForTesting
        String toCompileTimeString(BuilderState state) {
            boolean continuedForLogging = false;
            LinkedList<String> contents = new LinkedList<String>();
            while (state != null) {
                if (state.nexts != null && state.nexts.size() > 1) {
                    StringBuilderOptimizer.this.numberOfBuildersWithMergingPoints++;
                    if (Log.ENABLED && Log.isLoggingEnabledFor(StringBuilderOptimizer.class)) {
                        this.logHistogramOfChains(contents, true);
                        continuedForLogging = true;
                        contents.clear();
                        state = state.previous;
                        continue;
                    }
                    return null;
                }
                if (state.addition == null) break;
                if (state.addition.equals(ANY_STRING)) {
                    StringBuilderOptimizer.this.numberOfBuildersWithNonDeterministicArg++;
                    if (Log.ENABLED && Log.isLoggingEnabledFor(StringBuilderOptimizer.class)) {
                        this.logHistogramOfChains(contents, true);
                        continuedForLogging = true;
                        contents.clear();
                        state = state.previous;
                        continue;
                    }
                    return null;
                }
                contents.push(state.addition);
                state = state.previous;
            }
            if (continuedForLogging) {
                this.logHistogramOfChains(contents, true);
                return null;
            }
            if (Log.ENABLED && Log.isLoggingEnabledFor(StringBuilderOptimizer.class)) {
                this.logHistogramOfChains(contents, false);
            }
            if (contents.isEmpty()) {
                return null;
            }
            String result = StringUtils.join(contents, "");
            int estimate = this.estimateSizeReduction(contents);
            return estimate > result.length() ? result : null;
        }

        private int estimateSizeReduction(List<String> contents) {
            int result = 8;
            for (String content : contents) {
                result += 4;
                result += (int)((double)content.length() * 0.5);
            }
            return result += 4;
        }

        void removeTrivialBuilders() {
            InvokeMethodWithReceiver invoke;
            DexMethod invokedMethod;
            Instruction instr;
            if (this.deadBuilders.isEmpty() && this.simplifiedBuilders.isEmpty()) {
                return;
            }
            Sets.SetView<Value> buildersToRemove = Sets.union(this.deadBuilders, this.simplifiedBuilders);
            InstructionListIterator it = this.code.instructionListIterator();
            while (it.hasNext()) {
                instr = (Instruction)it.next();
                if (!instr.isInvokeVirtual() || !StringBuilderOptimizer.this.optimizationConfiguration.isToStringMethod(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) || !buildersToRemove.contains(invoke.getReceiver().getAliasedValue())) continue;
                it.removeOrReplaceByDebugLocalRead();
            }
            it = this.code.instructionListIterator();
            while (it.hasNext()) {
                instr = (Instruction)it.next();
                if (instr.isInvokeVirtual() && StringBuilderOptimizer.this.optimizationConfiguration.isAppendMethod(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) && buildersToRemove.contains(invoke.getReceiver().getAliasedValue())) {
                    it.removeOrReplaceByDebugLocalRead();
                }
                if (instr.isInvokeDirect() && StringBuilderOptimizer.this.optimizationConfiguration.isBuilderInit(invokedMethod = (invoke = instr.asInvokeDirect()).getInvokedMethod()) && buildersToRemove.contains(invoke.getReceiver().getAliasedValue())) {
                    it.removeOrReplaceByDebugLocalRead();
                }
                if (!instr.isAssume() || !buildersToRemove.contains(instr.outValue().getAliasedValue())) continue;
                Assume<?> assumeInstruction = instr.asAssume();
                Value src = assumeInstruction.src();
                Value dest = assumeInstruction.outValue();
                dest.replaceUsers(src);
                it.remove();
            }
            it = this.code.instructionListIterator();
            while (it.hasNext()) {
                instr = (Instruction)it.next();
                if (!instr.isNewInstance() || !StringBuilderOptimizer.this.optimizationConfiguration.isBuilderType(instr.asNewInstance().clazz) || !instr.hasOutValue() || !buildersToRemove.contains(instr.outValue())) continue;
                it.removeOrReplaceByDebugLocalRead();
            }
            assert (this.code.isConsistentSSA());
        }
    }
}

