/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.ir.optimize.string;

import java.io.UTFDataFormatException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.escape.EscapeAnalysisConfiguration;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.Nullability;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeAnalysis;
import shadow.bundletool.com.android.tools.r8.ir.analysis.type.TypeLatticeElement;
import shadow.bundletool.com.android.tools.r8.ir.code.BasicBlock;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstClass;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstNumber;
import shadow.bundletool.com.android.tools.r8.ir.code.ConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.DexItemBasedConstString;
import shadow.bundletool.com.android.tools.r8.ir.code.IRCode;
import shadow.bundletool.com.android.tools.r8.ir.code.Instruction;
import shadow.bundletool.com.android.tools.r8.ir.code.InstructionListIterator;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethod;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeMethodWithReceiver;
import shadow.bundletool.com.android.tools.r8.ir.code.InvokeVirtual;
import shadow.bundletool.com.android.tools.r8.ir.code.Value;
import shadow.bundletool.com.android.tools.r8.ir.optimize.CodeRewriter;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import shadow.bundletool.com.android.tools.r8.it.unimi.dsi.fastutil.objects.Object2IntMap;
import shadow.bundletool.com.android.tools.r8.logging.Log;
import shadow.bundletool.com.android.tools.r8.naming.dexitembasedstring.ClassNameComputationInfo;
import shadow.bundletool.com.android.tools.r8.utils.StringUtils;

public class StringOptimizer {
    private final AppView<?> appView;
    private final DexItemFactory factory;
    private final BasicBlock.ThrowingInfo throwingInfo;
    private int numberOfSimplifiedOperations = 0;
    private final Object2IntMap<ClassNameComputationInfo.ClassNameMapping> numberOfComputedNames;
    private final Object2IntMap<ClassNameComputationInfo.ClassNameMapping> numberOfDeferredComputationOfNames;
    private final Object2IntMap<Integer> histogramOfLengthOfNames;
    private final Object2IntMap<Integer> histogramOfLengthOfDeferredNames;
    private int numberOfSimplifiedConversions = 0;

    public StringOptimizer(AppView<?> appView) {
        this.appView = appView;
        this.factory = appView.dexItemFactory();
        this.throwingInfo = BasicBlock.ThrowingInfo.defaultForConstString(appView.options());
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringOptimizer.class)) {
            this.numberOfComputedNames = new Object2IntArrayMap<ClassNameComputationInfo.ClassNameMapping>();
            this.numberOfDeferredComputationOfNames = new Object2IntArrayMap<ClassNameComputationInfo.ClassNameMapping>();
            this.histogramOfLengthOfNames = new Object2IntArrayMap<Integer>();
            this.histogramOfLengthOfDeferredNames = new Object2IntArrayMap<Integer>();
        } else {
            this.numberOfComputedNames = null;
            this.numberOfDeferredComputationOfNames = null;
            this.histogramOfLengthOfNames = null;
            this.histogramOfLengthOfDeferredNames = null;
        }
    }

    public void logResult() {
        assert (Log.ENABLED);
        Log.info(this.getClass(), "# trivial operations on const-string: %s", this.numberOfSimplifiedOperations);
        Log.info(this.getClass(), "# trivial conversions from/to const-string: %s", this.numberOfSimplifiedConversions);
        if (this.numberOfComputedNames != null) {
            Log.info(this.getClass(), "------ # of get*Name() computation ------", new Object[0]);
            this.numberOfComputedNames.forEach((kind, count) -> Log.info(this.getClass(), "%s: %s (%s)", kind, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.numberOfDeferredComputationOfNames != null) {
            Log.info(this.getClass(), "------ # of deferred get*Name() computation ------", new Object[0]);
            this.numberOfDeferredComputationOfNames.forEach((kind, count) -> Log.info(this.getClass(), "%s: %s (%s)", kind, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.histogramOfLengthOfNames != null) {
            Log.info(this.getClass(), "------ histogram of get*Name() result lengths ------", new Object[0]);
            this.histogramOfLengthOfNames.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
        }
        if (this.histogramOfLengthOfDeferredNames != null) {
            Log.info(this.getClass(), "------ histogram of original type length for deferred get*Name() ------", new Object[0]);
            this.histogramOfLengthOfDeferredNames.forEach((length, count) -> Log.info(this.getClass(), "%s: %s (%s)", length, StringUtils.times("*", Math.min(count, 53)), count));
        }
    }

    public void computeTrivialOperationsOnConstString(IRCode code) {
        if (!code.metadata().mayHaveConstString()) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator it = code.instructionListIterator();
        while (it.hasNext()) {
            ConstNumber constNumber;
            Object rcvString;
            InvokeVirtual invoke;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !(invoke = instr.asInvokeVirtual()).hasOutValue()) continue;
            DexMethod invokedMethod = invoke.getInvokedMethod();
            if (invokedMethod.name == this.factory.substringName) {
                int endIndexValue;
                assert (invoke.inValues().size() == 2 || invoke.inValues().size() == 3);
                Value rcv2 = invoke.getReceiver().getAliasedValue();
                if (rcv2.definition == null || !rcv2.definition.isConstString() || rcv2.hasLocalInfo()) continue;
                Value beginIndex = invoke.inValues().get(1).getAliasedValue();
                if (beginIndex.definition == null || !beginIndex.definition.isConstNumber() || beginIndex.hasLocalInfo()) continue;
                int beginIndexValue = beginIndex.definition.asConstNumber().getIntValue();
                Value endIndex = null;
                if (invoke.inValues().size() == 3) {
                    endIndex = invoke.inValues().get(2).getAliasedValue();
                    if (endIndex.definition == null || !endIndex.definition.isConstNumber() || endIndex.hasLocalInfo()) continue;
                }
                rcvString = rcv2.definition.asConstString().getValue().toString();
                int n = endIndexValue = endIndex == null ? ((String)rcvString).length() : endIndex.definition.asConstNumber().getIntValue();
                if (beginIndexValue < 0 || endIndexValue > ((String)rcvString).length() || beginIndexValue > endIndexValue) continue;
                String sub = ((String)rcvString).substring(beginIndexValue, endIndexValue);
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                affectedValues.addAll(invoke.outValue().affectedValues());
                it.replaceCurrentInstruction(new ConstString(stringValue, this.factory.createString(sub), this.throwingInfo));
                ++this.numberOfSimplifiedOperations;
                continue;
            }
            if (invokedMethod == this.factory.stringMethods.trim) {
                Value receiver = invoke.getReceiver().getAliasedValue();
                if (receiver.hasLocalInfo() || receiver.isPhi() || !receiver.definition.isConstString()) continue;
                DexString resultString = this.factory.createString(receiver.definition.asConstString().getValue().toString().trim());
                Value newOutValue = code.createValue(TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                affectedValues.addAll(invoke.outValue().affectedValues());
                it.replaceCurrentInstruction(new ConstString(newOutValue, resultString, this.throwingInfo));
                ++this.numberOfSimplifiedOperations;
                continue;
            }
            Function<DexString, Integer> operatorWithNoArg = null;
            BiFunction<DexString, DexString, Integer> operatorWithString = null;
            BiFunction<DexString, Integer, Integer> operatorWithInt = null;
            if (invokedMethod == this.factory.stringMethods.hashCode) {
                operatorWithNoArg = rcv -> {
                    try {
                        return rcv.decodedHashCode();
                    }
                    catch (UTFDataFormatException e) {
                        throw new Unreachable();
                    }
                };
            } else if (invokedMethod == this.factory.stringMethods.length) {
                operatorWithNoArg = rcv -> rcv.size;
            } else if (invokedMethod == this.factory.stringMethods.isEmpty) {
                operatorWithNoArg = rcv -> rcv.size == 0 ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contains) {
                operatorWithString = (rcv, arg) -> rcv.toString().contains(arg.toString()) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.startsWith) {
                operatorWithString = (rcv, arg) -> rcv.startsWith((DexString)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.endsWith) {
                operatorWithString = (rcv, arg) -> rcv.endsWith((DexString)arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equals) {
                operatorWithString = (rcv, arg) -> rcv.equals(arg) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.equalsIgnoreCase) {
                operatorWithString = (rcv, arg) -> rcv.toString().equalsIgnoreCase(arg.toString()) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.contentEqualsCharSequence) {
                operatorWithString = (rcv, arg) -> rcv.toString().contentEquals(arg.toString()) ? 1 : 0;
            } else if (invokedMethod == this.factory.stringMethods.indexOfInt) {
                operatorWithInt = (rcv, idx) -> rcv.toString().indexOf((int)idx);
            } else if (invokedMethod == this.factory.stringMethods.indexOfString) {
                operatorWithString = (rcv, arg) -> rcv.toString().indexOf(arg.toString());
            } else if (invokedMethod == this.factory.stringMethods.lastIndexOfInt) {
                operatorWithInt = (rcv, idx) -> rcv.toString().lastIndexOf((int)idx);
            } else if (invokedMethod == this.factory.stringMethods.lastIndexOfString) {
                operatorWithString = (rcv, arg) -> rcv.toString().lastIndexOf(arg.toString());
            } else if (invokedMethod == this.factory.stringMethods.compareTo) {
                operatorWithString = (rcv, arg) -> rcv.toString().compareTo(arg.toString());
            } else {
                if (invokedMethod != this.factory.stringMethods.compareToIgnoreCase) continue;
                operatorWithString = (rcv, arg) -> rcv.toString().compareToIgnoreCase(arg.toString());
            }
            Value rcv3 = invoke.getReceiver().getAliasedValue();
            if (rcv3.definition == null || !rcv3.definition.isConstString() || rcv3.definition.asConstString().instructionInstanceCanThrow() || rcv3.hasLocalInfo()) continue;
            rcvString = rcv3.definition.asConstString().getValue();
            if (operatorWithNoArg != null) {
                assert (invoke.inValues().size() == 1);
                int v = operatorWithNoArg.apply((DexString)rcvString);
                constNumber = code.createIntConstant(v);
            } else if (operatorWithString != null) {
                assert (invoke.inValues().size() == 2);
                Value arg2 = invoke.inValues().get(1).getAliasedValue();
                if (arg2.definition == null || !arg2.definition.isConstString() || arg2.hasLocalInfo()) continue;
                int v = operatorWithString.apply((DexString)rcvString, arg2.definition.asConstString().getValue());
                constNumber = code.createIntConstant(v);
            } else {
                assert (operatorWithInt != null);
                assert (invoke.inValues().size() == 2);
                Value arg3 = invoke.inValues().get(1).getAliasedValue();
                if (arg3.definition == null || !arg3.definition.isConstNumber() || arg3.hasLocalInfo()) continue;
                int v = operatorWithInt.apply((DexString)rcvString, arg3.definition.asConstNumber().getIntValue());
                constNumber = code.createIntConstant(v);
            }
            ++this.numberOfSimplifiedOperations;
            it.replaceCurrentInstruction(constNumber);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    public void rewriteClassGetName(AppView<?> appView, IRCode code) {
        if (code.method.isClassInitializer()) {
            return;
        }
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator it = code.instructionListIterator();
        while (it.hasNext()) {
            String descriptor;
            boolean mayBeRenamed;
            DexClass holder;
            Value out;
            InvokeVirtual invoke;
            DexMethod invokedMethod;
            Instruction instr = (Instruction)it.next();
            if (!instr.isInvokeVirtual() || !this.factory.classMethods.isReflectiveNameLookup(invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) || (out = invoke.outValue()) == null || !out.hasAnyUsers()) continue;
            assert (invoke.inValues().size() == 1);
            Value in = invoke.getReceiver().getAliasedValue();
            if (in.definition == null || !in.definition.isConstClass() || in.hasLocalInfo()) continue;
            ConstClass constClass = in.definition.asConstClass();
            DexType type = constClass.getValue();
            int arrayDepth = type.getNumberOfLeadingSquareBrackets();
            DexType baseType = type.toBaseType(this.factory);
            if (!baseType.isClassType() || (holder = appView.definitionFor(baseType)) == null) continue;
            boolean bl = mayBeRenamed = appView.options().isMinifying() && appView.rootSet().mayBeMinified(holder.type, appView);
            if (!appView.options().testing.forceNameReflectionOptimization) {
                EscapeAnalysis escapeAnalysis = new EscapeAnalysis(appView, StringOptimizerEscapeAnalysisConfiguration.getInstance());
                if (mayBeRenamed || escapeAnalysis.isEscaping(code, out)) continue;
            }
            boolean assumeTopLevel = (descriptor = baseType.toDescriptorString()).indexOf(36) < 0;
            DexItemBasedConstString deferred = null;
            DexString name = null;
            if (invokedMethod == this.factory.classMethods.getName) {
                if (mayBeRenamed) {
                    deferred = new DexItemBasedConstString(invoke.outValue(), baseType, ClassNameComputationInfo.create(ClassNameComputationInfo.ClassNameMapping.NAME, arrayDepth), this.throwingInfo);
                    this.logDeferredNameComputation(ClassNameComputationInfo.ClassNameMapping.NAME);
                } else {
                    name = ClassNameComputationInfo.ClassNameMapping.NAME.map(descriptor, holder, this.factory, arrayDepth);
                    this.logNameComputation(ClassNameComputationInfo.ClassNameMapping.NAME);
                }
            } else {
                if (invokedMethod == this.factory.classMethods.getTypeName) continue;
                if (invokedMethod == this.factory.classMethods.getCanonicalName) {
                    if (holder.isLocalClass() || holder.isAnonymousClass()) {
                        affectedValues.addAll(invoke.outValue().affectedValues());
                        ConstNumber constNull = code.createConstNull();
                        it.replaceCurrentInstruction(constNull);
                    } else {
                        if (!assumeTopLevel) continue;
                        if (mayBeRenamed) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, ClassNameComputationInfo.create(ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME, arrayDepth), this.throwingInfo);
                            this.logDeferredNameComputation(ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME);
                        } else {
                            name = ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME.map(descriptor, holder, this.factory, arrayDepth);
                            this.logNameComputation(ClassNameComputationInfo.ClassNameMapping.CANONICAL_NAME);
                        }
                    }
                } else if (invokedMethod == this.factory.classMethods.getSimpleName) {
                    if (holder.isAnonymousClass()) {
                        name = this.factory.createString("");
                    } else {
                        if (!assumeTopLevel) continue;
                        if (mayBeRenamed) {
                            deferred = new DexItemBasedConstString(invoke.outValue(), baseType, ClassNameComputationInfo.create(ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME, arrayDepth), this.throwingInfo);
                            this.logDeferredNameComputation(ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME);
                        } else {
                            name = ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME.map(descriptor, holder, this.factory, arrayDepth);
                            this.logNameComputation(ClassNameComputationInfo.ClassNameMapping.SIMPLE_NAME);
                        }
                    }
                }
            }
            if (name != null) {
                affectedValues.addAll(invoke.outValue().affectedValues());
                Value stringValue = code.createValue(TypeLatticeElement.stringClassType(appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                ConstString constString = new ConstString(stringValue, name, this.throwingInfo);
                it.replaceCurrentInstruction(constString);
                this.logHistogramOfNames(name);
                continue;
            }
            if (deferred == null) continue;
            affectedValues.addAll(invoke.outValue().affectedValues());
            it.replaceCurrentInstruction(deferred);
            this.logHistogramOfNames(deferred);
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(appView).narrowing(affectedValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logNameComputation(ClassNameComputationInfo.ClassNameMapping kind) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringOptimizer.class)) {
            assert (this.numberOfComputedNames != null);
            Object2IntMap<ClassNameComputationInfo.ClassNameMapping> object2IntMap = this.numberOfComputedNames;
            synchronized (object2IntMap) {
                int count = this.numberOfComputedNames.getOrDefault((Object)kind, 0);
                this.numberOfComputedNames.put(kind, count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logHistogramOfNames(DexString name) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringOptimizer.class)) {
            Integer length = name.size;
            assert (this.histogramOfLengthOfNames != null);
            Object2IntMap<Integer> object2IntMap = this.histogramOfLengthOfNames;
            synchronized (object2IntMap) {
                int count = this.histogramOfLengthOfNames.getOrDefault(length, 0);
                this.histogramOfLengthOfNames.put(length, count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logDeferredNameComputation(ClassNameComputationInfo.ClassNameMapping kind) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringOptimizer.class)) {
            assert (this.numberOfDeferredComputationOfNames != null);
            Object2IntMap<ClassNameComputationInfo.ClassNameMapping> object2IntMap = this.numberOfDeferredComputationOfNames;
            synchronized (object2IntMap) {
                int count = this.numberOfDeferredComputationOfNames.getOrDefault((Object)kind, 0);
                this.numberOfDeferredComputationOfNames.put(kind, count + 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logHistogramOfNames(DexItemBasedConstString deferred) {
        if (Log.ENABLED && Log.isLoggingEnabledFor(StringOptimizer.class)) {
            assert (deferred.getItem().isDexType());
            DexType original = deferred.getItem().asDexType();
            Integer length = original.descriptor.size;
            assert (this.histogramOfLengthOfDeferredNames != null);
            Object2IntMap<Integer> object2IntMap = this.histogramOfLengthOfDeferredNames;
            synchronized (object2IntMap) {
                int count = this.histogramOfLengthOfDeferredNames.getOrDefault(length, 0);
                this.histogramOfLengthOfDeferredNames.put(length, count + 1);
            }
        }
    }

    public void removeTrivialConversions(IRCode code) {
        Set<Value> affectedValues = Sets.newIdentityHashSet();
        InstructionListIterator it = code.instructionListIterator();
        while (it.hasNext()) {
            Value in;
            DexMethod invokedMethod;
            InvokeMethod invoke;
            Instruction instr = (Instruction)it.next();
            if (instr.isInvokeStatic()) {
                invoke = instr.asInvokeStatic();
                invokedMethod = invoke.getInvokedMethod();
                if (invokedMethod != this.factory.stringMethods.valueOf) continue;
                assert (invoke.inValues().size() == 1);
                in = invoke.inValues().get(0);
                if (in.hasLocalInfo()) continue;
                Value out = invoke.outValue();
                TypeLatticeElement inType = in.getTypeLattice();
                if (out != null && in.isAlwaysNull(this.appView)) {
                    affectedValues.addAll(out.affectedValues());
                    Value nullStringValue = code.createValue(TypeLatticeElement.stringClassType(this.appView, Nullability.definitelyNotNull()), invoke.getLocalInfo());
                    ConstString nullString = new ConstString(nullStringValue, this.factory.createString("null"), this.throwingInfo);
                    it.replaceCurrentInstruction(nullString);
                    ++this.numberOfSimplifiedConversions;
                    continue;
                }
                if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
                if (out != null) {
                    affectedValues.addAll(out.affectedValues());
                    CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
                } else {
                    it.removeOrReplaceByDebugLocalRead();
                }
                ++this.numberOfSimplifiedConversions;
                continue;
            }
            if (!instr.isInvokeVirtual() || (invokedMethod = (invoke = instr.asInvokeVirtual()).getInvokedMethod()) != this.factory.stringMethods.toString) continue;
            assert (invoke.inValues().size() == 1);
            in = ((InvokeMethodWithReceiver)invoke).getReceiver();
            TypeLatticeElement inType = in.getTypeLattice();
            if (!inType.nullability().isDefinitelyNotNull() || !inType.isClassType() || !inType.asClassTypeLatticeElement().getClassType().equals(this.factory.stringType)) continue;
            Value out = invoke.outValue();
            if (out != null) {
                affectedValues.addAll(out.affectedValues());
                CodeRewriter.removeOrReplaceByDebugLocalWrite(invoke, it, in, out);
            } else {
                it.removeOrReplaceByDebugLocalRead();
            }
            ++this.numberOfSimplifiedConversions;
        }
        if (!affectedValues.isEmpty()) {
            new TypeAnalysis(this.appView).narrowing(affectedValues);
        }
    }

    static class StringOptimizerEscapeAnalysisConfiguration
    implements EscapeAnalysisConfiguration {
        private static final StringOptimizerEscapeAnalysisConfiguration INSTANCE = new StringOptimizerEscapeAnalysisConfiguration();

        private StringOptimizerEscapeAnalysisConfiguration() {
        }

        public static StringOptimizerEscapeAnalysisConfiguration getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean isLegitimateEscapeRoute(AppView<?> appView, EscapeAnalysis escapeAnalysis, Instruction escapeRoute, DexMethod context) {
            if (escapeRoute.isReturn() || escapeRoute.isThrow() || escapeRoute.isStaticPut()) {
                return false;
            }
            if (escapeRoute.isInvokeMethod()) {
                DexMethod invokedMethod = escapeRoute.asInvokeMethod().getInvokedMethod();
                return invokedMethod == appView.dexItemFactory().stringMethods.hashCode || invokedMethod == appView.dexItemFactory().stringMethods.isEmpty || invokedMethod == appView.dexItemFactory().stringMethods.length;
            }
            if (escapeRoute.isArrayPut()) {
                Value array = escapeRoute.asArrayPut().array().getAliasedValue();
                return !array.isPhi() && array.definition.isCreatingArray();
            }
            if (escapeRoute.isInstancePut()) {
                Value instance = escapeRoute.asInstancePut().object().getAliasedValue();
                return !instance.isPhi() && instance.definition.isNewInstance();
            }
            return false;
        }
    }
}

