/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmClass;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmConstructor;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmFunction;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmProperty;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.KmType;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinMetadataSynthesizer;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class KotlinClass
extends KotlinInfo<KotlinClassMetadata.Class> {
    private KmClass kmClass;

    static KotlinClass fromKotlinClassMetadata(KotlinClassMetadata kotlinClassMetadata, DexClass clazz) {
        assert (kotlinClassMetadata instanceof KotlinClassMetadata.Class);
        KotlinClassMetadata.Class kClass = (KotlinClassMetadata.Class)kotlinClassMetadata;
        return new KotlinClass(kClass, clazz);
    }

    private KotlinClass(KotlinClassMetadata.Class metadata, DexClass clazz) {
        super(metadata, clazz);
    }

    @Override
    void processMetadata() {
        assert (!this.isProcessed);
        this.isProcessed = true;
        this.kmClass = ((KotlinClassMetadata.Class)this.metadata).toKmClass();
    }

    @Override
    void rewrite(AppView<AppInfoWithLiveness> appView, NamingLens lens) {
        List<KmType> superTypes = this.kmClass.getSupertypes();
        superTypes.clear();
        for (DexType itfType : this.clazz.interfaces.values) {
            KmType kmType = KotlinMetadataSynthesizer.toRenamedKmType(itfType, appView, lens);
            if (kmType == null) continue;
            superTypes.add(kmType);
        }
        assert (this.clazz.superType != null);
        if (this.clazz.superType != appView.dexItemFactory().objectType) {
            KmType kmTypeForSupertype = KotlinMetadataSynthesizer.toRenamedKmType(this.clazz.superType, appView, lens);
            if (kmTypeForSupertype != null) {
                superTypes.add(kmTypeForSupertype);
            }
        } else if (this.clazz.isInterface()) {
            superTypes.add(KotlinMetadataSynthesizer.toKmType(Kotlin.addKotlinPrefix("Any;")));
        }
        if (!appView.options().enableKotlinMetadataRewriting) {
            return;
        }
        List<KmConstructor> constructors = this.kmClass.getConstructors();
        ArrayList<KmConstructor> originalConstructors = new ArrayList<KmConstructor>(constructors);
        constructors.clear();
        for (Map.Entry<DexEncodedMethod, KmConstructor> entry : this.clazz.kotlinConstructors(originalConstructors, appView).entrySet()) {
            KmConstructor constructor = KotlinMetadataSynthesizer.toRenamedKmConstructor(entry.getKey(), entry.getValue(), appView, lens);
            if (constructor == null) continue;
            constructors.add(constructor);
        }
        List<KmFunction> functions = this.kmClass.getFunctions();
        List<KmFunction> originalFunctions = functions.stream().filter(kmFunction -> !KotlinMetadataSynthesizer.isExtension(kmFunction)).collect(Collectors.toList());
        List<KmFunction> originalExtensions = functions.stream().filter(KotlinMetadataSynthesizer::isExtension).collect(Collectors.toList());
        functions.clear();
        List<KmProperty> properties = this.kmClass.getProperties();
        for (DexEncodedMethod dexEncodedMethod : this.clazz.kotlinFunctions(originalFunctions, properties, appView)) {
            KmFunction function = KotlinMetadataSynthesizer.toRenamedKmFunction(dexEncodedMethod, null, appView, lens);
            if (function == null) continue;
            functions.add(function);
        }
        for (Map.Entry entry : this.clazz.kotlinExtensions(originalExtensions, appView).entrySet()) {
            KmFunction extension = KotlinMetadataSynthesizer.toRenamedKmFunctionAsExtension((DexEncodedMethod)entry.getKey(), (KmFunction)entry.getValue(), appView, lens);
            if (extension == null) continue;
            functions.add(extension);
        }
    }

    @Override
    KotlinClassHeader createHeader() {
        KotlinClassMetadata.Class.Writer writer = new KotlinClassMetadata.Class.Writer();
        this.kmClass.accept(writer);
        return writer.write().getHeader();
    }

    @Override
    public KotlinInfo.Kind getKind() {
        return KotlinInfo.Kind.Class;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    @Override
    public KotlinClass asClass() {
        return this;
    }
}

