/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.kotlin;

import java.util.IdentityHashMap;
import shadow.bundletool.com.android.tools.r8.DiagnosticsHandler;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotationElement;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexValue;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.InconsistentKotlinMetadataException;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassHeader;
import shadow.bundletool.com.android.tools.r8.jetbrains.kotlinx.metadata.jvm.KotlinClassMetadata;
import shadow.bundletool.com.android.tools.r8.kotlin.Kotlin;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinClass;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinClassFacade;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinClassPart;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinFile;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinInfo;
import shadow.bundletool.com.android.tools.r8.kotlin.KotlinSyntheticClass;
import shadow.bundletool.com.android.tools.r8.utils.StringDiagnostic;

final class KotlinClassMetadataReader {
    KotlinClassMetadataReader() {
    }

    static KotlinInfo getKotlinInfo(Kotlin kotlin, DexClass clazz, DiagnosticsHandler reporter) {
        if (clazz.annotations.isEmpty()) {
            return null;
        }
        DexAnnotation meta = clazz.annotations.getFirstMatching(kotlin.metadata.kotlinMetadataType);
        if (meta != null) {
            try {
                return KotlinClassMetadataReader.createKotlinInfo(kotlin, clazz, meta.annotation);
            }
            catch (ClassCastException | InconsistentKotlinMetadataException | MetadataError e) {
                reporter.info(new StringDiagnostic("Class " + clazz.type.toSourceString() + " has malformed kotlin.Metadata: " + e.getMessage()));
            }
            catch (Throwable e) {
                reporter.info(new StringDiagnostic("Unexpected error while reading " + clazz.type.toSourceString() + "'s kotlin.Metadata: " + e.getMessage()));
            }
        }
        return null;
    }

    private static KotlinClassMetadata toKotlinClassMetadata(Kotlin kotlin, DexEncodedAnnotation metadataAnnotation) {
        IdentityHashMap<DexString, DexAnnotationElement> elementMap = new IdentityHashMap<DexString, DexAnnotationElement>();
        for (DexAnnotationElement element : metadataAnnotation.elements) {
            elementMap.put(element.name, element);
        }
        DexAnnotationElement kind = (DexAnnotationElement)elementMap.get(kotlin.metadata.kind);
        if (kind == null) {
            throw new MetadataError("element 'k' is missing.");
        }
        Integer k = (Integer)kind.value.getBoxedValue();
        DexAnnotationElement metadataVersion = (DexAnnotationElement)elementMap.get(kotlin.metadata.metadataVersion);
        int[] mv = metadataVersion == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(metadataVersion.value, "mv");
        DexAnnotationElement bytecodeVersion = (DexAnnotationElement)elementMap.get(kotlin.metadata.bytecodeVersion);
        int[] bv = bytecodeVersion == null ? null : KotlinClassMetadataReader.getUnboxedIntArray(bytecodeVersion.value, "bv");
        DexAnnotationElement data1 = (DexAnnotationElement)elementMap.get(kotlin.metadata.data1);
        String[] d1 = data1 == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data1.value, "d1");
        DexAnnotationElement data2 = (DexAnnotationElement)elementMap.get(kotlin.metadata.data2);
        String[] d2 = data2 == null ? null : KotlinClassMetadataReader.getUnboxedStringArray(data2.value, "d2");
        DexAnnotationElement extraString = (DexAnnotationElement)elementMap.get(kotlin.metadata.extraString);
        String xs = extraString == null ? null : KotlinClassMetadataReader.getUnboxedString(extraString.value, "xs");
        DexAnnotationElement packageName = (DexAnnotationElement)elementMap.get(kotlin.metadata.packageName);
        String pn = packageName == null ? null : KotlinClassMetadataReader.getUnboxedString(packageName.value, "pn");
        DexAnnotationElement extraInt = (DexAnnotationElement)elementMap.get(kotlin.metadata.extraInt);
        Integer xi = extraInt == null ? null : (Integer)extraInt.value.getBoxedValue();
        KotlinClassHeader header = new KotlinClassHeader(k, mv, bv, d1, d2, xs, pn, xi);
        return KotlinClassMetadata.read(header);
    }

    private static KotlinInfo createKotlinInfo(Kotlin kotlin, DexClass clazz, DexEncodedAnnotation metadataAnnotation) {
        KotlinClassMetadata kMetadata = KotlinClassMetadataReader.toKotlinClassMetadata(kotlin, metadataAnnotation);
        if (kMetadata instanceof KotlinClassMetadata.Class) {
            return KotlinClass.fromKotlinClassMetadata(kMetadata, clazz);
        }
        if (kMetadata instanceof KotlinClassMetadata.FileFacade) {
            return KotlinFile.fromKotlinClassMetadata(kMetadata, clazz);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassFacade) {
            return KotlinClassFacade.fromKotlinClassMetadata(kMetadata, clazz);
        }
        if (kMetadata instanceof KotlinClassMetadata.MultiFileClassPart) {
            return KotlinClassPart.fromKotlinClassMetadata(kMetadata, clazz);
        }
        if (kMetadata instanceof KotlinClassMetadata.SyntheticClass) {
            return KotlinSyntheticClass.fromKotlinClassMetadata(kMetadata, kotlin, clazz);
        }
        throw new MetadataError("unsupported 'k' value: " + kMetadata.getHeader().getKind());
    }

    private static int[] getUnboxedIntArray(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueArray)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray intArrayValue = (DexValue.DexValueArray)v;
        DexValue[] values2 = intArrayValue.getValues();
        int[] result = new int[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = (Integer)values2[i].getBoxedValue();
        }
        return result;
    }

    private static String[] getUnboxedStringArray(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueArray)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        DexValue.DexValueArray stringArrayValue = (DexValue.DexValueArray)v;
        DexValue[] values2 = stringArrayValue.getValues();
        String[] result = new String[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            result[i] = KotlinClassMetadataReader.getUnboxedString(values2[i], elementName + "[" + i + "]");
        }
        return result;
    }

    private static String getUnboxedString(DexValue v, String elementName) {
        if (!(v instanceof DexValue.DexValueString)) {
            throw new MetadataError("invalid '" + elementName + "' value: " + v.toSourceString());
        }
        return ((DexString)((DexValue.DexValueString)v).getValue()).toString();
    }

    private static class MetadataError
    extends RuntimeException {
        MetadataError(String cause) {
            super(cause);
        }
    }
}

