/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableList;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.errors.Unimplemented;
import shadow.bundletool.com.android.tools.r8.errors.Unreachable;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.AnnotationGraphNode;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.ClassGraphNode;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.FieldGraphNode;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphConsumer;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphEdgeInfo;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.GraphNode;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.KeepRuleGraphNode;
import shadow.bundletool.com.android.tools.r8.experimental.graphinfo.MethodGraphNode;
import shadow.bundletool.com.android.tools.r8.graph.AppView;
import shadow.bundletool.com.android.tools.r8.graph.DexAnnotation;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexDefinition;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexItem;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexReference;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.ir.desugar.InterfaceMethodRewriter;
import shadow.bundletool.com.android.tools.r8.references.Reference;
import shadow.bundletool.com.android.tools.r8.references.TypeReference;
import shadow.bundletool.com.android.tools.r8.shaking.CollectingGraphConsumer;
import shadow.bundletool.com.android.tools.r8.shaking.Enqueuer;
import shadow.bundletool.com.android.tools.r8.shaking.KeepReason;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardIfRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRule;
import shadow.bundletool.com.android.tools.r8.shaking.ProguardKeepRuleBase;
import shadow.bundletool.com.android.tools.r8.utils.DequeUtils;

public class GraphReporter {
    private final AppView<?> appView;
    private final GraphConsumer keptGraphConsumer;
    private final CollectingGraphConsumer verificationGraphConsumer;
    private final Map<DexItem, AnnotationGraphNode> annotationNodes = new IdentityHashMap<DexItem, AnnotationGraphNode>();
    private final Map<DexType, ClassGraphNode> classNodes = new IdentityHashMap<DexType, ClassGraphNode>();
    private final Map<DexMethod, MethodGraphNode> methodNodes = new IdentityHashMap<DexMethod, MethodGraphNode>();
    private final Map<DexField, FieldGraphNode> fieldNodes = new IdentityHashMap<DexField, FieldGraphNode>();
    private final Map<ProguardKeepRuleBase, KeepRuleGraphNode> ruleNodes = new IdentityHashMap<ProguardKeepRuleBase, KeepRuleGraphNode>();
    private final Map<GraphEdgeInfo.EdgeKind, GraphEdgeInfo> reasonInfo = new IdentityHashMap<GraphEdgeInfo.EdgeKind, GraphEdgeInfo>();

    GraphReporter(AppView<?> appView, GraphConsumer keptGraphConsumer) {
        this.appView = appView;
        if (appView.options().testing.verifyKeptGraphInfo) {
            this.verificationGraphConsumer = new CollectingGraphConsumer(keptGraphConsumer);
            this.keptGraphConsumer = this.verificationGraphConsumer;
        } else {
            this.verificationGraphConsumer = null;
            this.keptGraphConsumer = keptGraphConsumer;
        }
    }

    public KeepReasonWitness fakeReportShouldNotBeUsed() {
        return KeepReasonWitness.INSTANCE;
    }

    public boolean verifyRootedPath(DexProgramClass liveType) {
        assert (this.verificationGraphConsumer != null);
        ClassGraphNode node = this.getClassGraphNode(liveType.type);
        Set<GraphNode> seen = Sets.newIdentityHashSet();
        Deque<ClassGraphNode> targets = DequeUtils.newArrayDeque(node);
        while (!targets.isEmpty()) {
            KeepRuleGraphNode rule;
            GraphNode item = targets.pop();
            if (item instanceof KeepRuleGraphNode && (rule = (KeepRuleGraphNode)item).getPreconditions().isEmpty()) {
                return true;
            }
            if (!seen.add(item)) continue;
            Map<GraphNode, Set<GraphEdgeInfo>> sources = this.verificationGraphConsumer.getSourcesTargeting(item);
            assert (sources != null) : "No sources set for " + item;
            assert (!sources.isEmpty()) : "Empty sources set for " + item;
            targets.addAll(sources.keySet());
        }
        assert (false) : "No rooted path to " + liveType.type;
        return false;
    }

    private GraphEdgeInfo.EdgeKind reportPrecondition(KeepRuleGraphNode keepRuleGraphNode) {
        if (keepRuleGraphNode.getPreconditions().isEmpty()) {
            return GraphEdgeInfo.EdgeKind.KeepRule;
        }
        for (GraphNode precondition : keepRuleGraphNode.getPreconditions()) {
            this.reportEdge(precondition, keepRuleGraphNode, GraphEdgeInfo.EdgeKind.KeepRulePrecondition);
        }
        return GraphEdgeInfo.EdgeKind.ConditionalKeepRule;
    }

    KeepReasonWitness reportKeepClass(DexDefinition precondition, ProguardKeepRuleBase rule, DexProgramClass clazz) {
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
        GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
        return this.reportEdge(ruleNode, this.getClassGraphNode(clazz.type), edgeKind);
    }

    KeepReasonWitness reportKeepClass(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexProgramClass clazz) {
        assert (!rules.isEmpty());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepClass(precondition, rule, clazz);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepMethod(DexDefinition precondition, ProguardKeepRuleBase rule, DexEncodedMethod method) {
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
        GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
        return this.reportEdge(ruleNode, this.getMethodGraphNode(method.method), edgeKind);
    }

    KeepReasonWitness reportKeepMethod(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexEncodedMethod method) {
        assert (!rules.isEmpty());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepMethod(precondition, rule, method);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    KeepReasonWitness reportKeepField(DexDefinition precondition, ProguardKeepRuleBase rule, DexEncodedField field) {
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        KeepRuleGraphNode ruleNode = this.getKeepRuleGraphNode(precondition, rule);
        GraphEdgeInfo.EdgeKind edgeKind = this.reportPrecondition(ruleNode);
        return this.reportEdge(ruleNode, this.getFieldGraphNode(field.field), edgeKind);
    }

    KeepReasonWitness reportKeepField(DexDefinition precondition, Collection<ProguardKeepRuleBase> rules, DexEncodedField field) {
        assert (!rules.isEmpty());
        if (this.keptGraphConsumer != null) {
            for (ProguardKeepRuleBase rule : rules) {
                this.reportKeepField(precondition, rule, field);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatKeepDefaultInitializer(DexProgramClass holder, DexEncodedMethod defaultInitializer) {
        assert (holder.type == defaultInitializer.method.holder);
        assert (holder.getDefaultInitializer() == defaultInitializer);
        if (this.keptGraphConsumer != null) {
            this.reportEdge(this.getClassGraphNode(holder.type), this.getMethodGraphNode(defaultInitializer.method), GraphEdgeInfo.EdgeKind.CompatibilityRule);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatKeepMethod(DexProgramClass holder, DexEncodedMethod method) {
        assert (holder.type == method.method.holder);
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompatInstantiated(DexProgramClass instantiated, DexEncodedMethod method) {
        if (this.keptGraphConsumer != null) {
            this.reportEdge(this.getMethodGraphNode(method.method), this.getClassGraphNode(instantiated.type), GraphEdgeInfo.EdgeKind.CompatibilityRule);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, DexProgramClass implementer) {
        if (this.keptGraphConsumer != null) {
            ClassGraphNode source = this.getClassGraphNode(implementer.type);
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, DexEncodedMethod method) {
        if (this.keptGraphConsumer != null) {
            MethodGraphNode source = this.getMethodGraphNode(method.method);
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportClassReferencedFrom(DexProgramClass clazz, DexEncodedField field) {
        if (this.keptGraphConsumer != null) {
            FieldGraphNode source = this.getFieldGraphNode(field.field);
            ClassGraphNode target = this.getClassGraphNode(clazz.type);
            return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReferencedFrom);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportReachableClassInitializer(DexProgramClass clazz, DexEncodedMethod initializer) {
        if (initializer != null) {
            assert (clazz.type == initializer.method.holder);
            assert (initializer.isClassInitializer());
            if (this.keptGraphConsumer != null) {
                ClassGraphNode source = this.getClassGraphNode(clazz.type);
                MethodGraphNode target = this.getMethodGraphNode(initializer.method);
                return this.reportEdge(source, target, GraphEdgeInfo.EdgeKind.ReachableFromLiveType);
            }
        } else assert (!clazz.hasClassInitializer());
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportReachableMethodAsLive(DexEncodedMethod encodedMethod, Enqueuer.MarkedResolutionTarget reason) {
        if (this.keptGraphConsumer != null) {
            return this.reportEdge(this.getMethodGraphNode(reason.method.method), this.getMethodGraphNode(encodedMethod.method), GraphEdgeInfo.EdgeKind.OverridingMethod);
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportReachableMethodAsLive(DexEncodedMethod encodedMethod, Set<Enqueuer.MarkedResolutionTarget> reasons) {
        assert (!reasons.isEmpty());
        if (this.keptGraphConsumer != null) {
            MethodGraphNode target = this.getMethodGraphNode(encodedMethod.method);
            for (Enqueuer.MarkedResolutionTarget reason : reasons) {
                this.reportEdge(this.getMethodGraphNode(reason.method.method), target, GraphEdgeInfo.EdgeKind.OverridingMethod);
            }
        }
        return KeepReasonWitness.INSTANCE;
    }

    public KeepReasonWitness reportCompanionClass(DexProgramClass iface, DexProgramClass companion) {
        assert (iface.isInterface());
        assert (InterfaceMethodRewriter.isCompanionClassType(companion.type));
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.reportEdge(this.getClassGraphNode(iface.type), this.getClassGraphNode(companion.type), GraphEdgeInfo.EdgeKind.CompanionClass);
    }

    public KeepReasonWitness reportCompanionMethod(DexEncodedMethod definition, DexEncodedMethod implementation) {
        assert (InterfaceMethodRewriter.isCompanionClassType(implementation.method.holder));
        if (this.keptGraphConsumer == null) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.reportEdge(this.getMethodGraphNode(definition.method), this.getMethodGraphNode(implementation.method), GraphEdgeInfo.EdgeKind.CompanionMethod);
    }

    private KeepReasonWitness reportEdge(GraphNode source, GraphNode target, GraphEdgeInfo.EdgeKind kind) {
        assert (this.keptGraphConsumer != null);
        this.keptGraphConsumer.acceptEdge(source, target, this.getEdgeInfo(kind));
        return KeepReasonWitness.INSTANCE;
    }

    private boolean skipReporting(KeepReason reason) {
        assert (reason != null);
        if (reason == KeepReasonWitness.INSTANCE) {
            return true;
        }
        assert (this.getSourceNode(reason) != null);
        return this.keptGraphConsumer == null;
    }

    public KeepReasonWitness registerInterface(DexProgramClass iface, KeepReason reason) {
        assert (iface.isInterface());
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getClassGraphNode(iface.type), reason);
    }

    public KeepReasonWitness registerClass(DexProgramClass clazz, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getClassGraphNode(clazz.type), reason);
    }

    public KeepReasonWitness registerAnnotation(DexAnnotation annotation, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getAnnotationGraphNode(annotation.annotation.type), reason);
    }

    public KeepReasonWitness registerMethod(DexEncodedMethod method, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        if (reason.edgeKind() == GraphEdgeInfo.EdgeKind.IsLibraryMethod && this.isNonProgramClass(method.method.holder)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getMethodGraphNode(method.method), reason);
    }

    public KeepReasonWitness registerField(DexEncodedField field, KeepReason reason) {
        if (this.skipReporting(reason)) {
            return KeepReasonWitness.INSTANCE;
        }
        return this.registerEdge(this.getFieldGraphNode(field.field), reason);
    }

    private KeepReasonWitness registerEdge(GraphNode target, KeepReason reason) {
        assert (!this.skipReporting(reason));
        GraphNode sourceNode = this.getSourceNode(reason);
        if (!sourceNode.isLibraryNode()) {
            GraphEdgeInfo edgeInfo = this.getEdgeInfo(reason);
            this.keptGraphConsumer.acceptEdge(sourceNode, target, edgeInfo);
        }
        return KeepReasonWitness.INSTANCE;
    }

    private boolean isNonProgramClass(DexType type) {
        DexClass clazz = this.appView.definitionFor(type);
        return clazz == null || clazz.isNotProgramClass();
    }

    private GraphNode getSourceNode(KeepReason reason) {
        return reason.getSourceNode(this);
    }

    public GraphNode getGraphNode(DexReference reference) {
        if (reference.isDexType()) {
            return this.getClassGraphNode(reference.asDexType());
        }
        if (reference.isDexMethod()) {
            return this.getMethodGraphNode(reference.asDexMethod());
        }
        if (reference.isDexField()) {
            return this.getFieldGraphNode(reference.asDexField());
        }
        throw new Unreachable();
    }

    GraphEdgeInfo getEdgeInfo(KeepReason reason) {
        return this.getEdgeInfo(reason.edgeKind());
    }

    GraphEdgeInfo getEdgeInfo(GraphEdgeInfo.EdgeKind kind) {
        return this.reasonInfo.computeIfAbsent(kind, k -> new GraphEdgeInfo((GraphEdgeInfo.EdgeKind)((Object)k)));
    }

    AnnotationGraphNode getAnnotationGraphNode(DexItem type) {
        return this.annotationNodes.computeIfAbsent(type, t -> {
            if (t instanceof DexType) {
                return new AnnotationGraphNode(this.getClassGraphNode((DexType)t));
            }
            throw new Unimplemented("Incomplete support for annotation node on item: " + type.getClass());
        });
    }

    ClassGraphNode getClassGraphNode(DexType type) {
        return this.classNodes.computeIfAbsent(type, t -> {
            DexClass definition = this.appView.definitionFor((DexType)t);
            return new ClassGraphNode(definition != null && definition.isNotProgramClass(), Reference.classFromDescriptor(t.toDescriptorString()));
        });
    }

    MethodGraphNode getMethodGraphNode(DexMethod context) {
        return this.methodNodes.computeIfAbsent(context, m -> {
            DexClass holderDefinition = this.appView.definitionFor(context.holder);
            ImmutableList.Builder builder = ImmutableList.builder();
            for (DexType param : m.proto.parameters.values) {
                builder.add(Reference.typeFromDescriptor(param.toDescriptorString()));
            }
            return new MethodGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.method(Reference.classFromDescriptor(m.holder.toDescriptorString()), m.name.toString(), (List<TypeReference>)((Object)builder.build()), m.proto.returnType.isVoidType() ? null : Reference.typeFromDescriptor(m.proto.returnType.toDescriptorString())));
        });
    }

    FieldGraphNode getFieldGraphNode(DexField context) {
        return this.fieldNodes.computeIfAbsent(context, f -> {
            DexClass holderDefinition = this.appView.definitionFor(context.holder);
            return new FieldGraphNode(holderDefinition != null && holderDefinition.isNotProgramClass(), Reference.field(Reference.classFromDescriptor(f.holder.toDescriptorString()), f.name.toString(), Reference.typeFromDescriptor(f.type.toDescriptorString())));
        });
    }

    KeepRuleGraphNode getKeepRuleGraphNode(DexDefinition precondition, ProguardKeepRuleBase rule) {
        if (rule instanceof ProguardKeepRule) {
            Set preconditions = precondition != null ? Collections.singleton(this.getGraphNode(precondition.toReference())) : Collections.emptySet();
            return this.ruleNodes.computeIfAbsent(rule, key -> new KeepRuleGraphNode(rule, preconditions));
        }
        if (rule instanceof ProguardIfRule) {
            ProguardIfRule ifRule = (ProguardIfRule)rule;
            assert (!ifRule.getPreconditions().isEmpty());
            return this.ruleNodes.computeIfAbsent(ifRule, key -> {
                HashSet<GraphNode> preconditions = new HashSet<GraphNode>(ifRule.getPreconditions().size());
                for (DexReference condition : ifRule.getPreconditions()) {
                    preconditions.add(this.getGraphNode(condition));
                }
                return new KeepRuleGraphNode(ifRule, preconditions);
            });
        }
        throw new Unreachable("Unexpected type of keep rule: " + rule);
    }

    public static class KeepReasonWitness
    extends KeepReason {
        private static KeepReasonWitness INSTANCE = new KeepReasonWitness();

        private KeepReasonWitness() {
        }

        @Override
        public GraphEdgeInfo.EdgeKind edgeKind() {
            throw new Unreachable();
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            throw new Unreachable();
        }
    }
}

