/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.ImmutableSet;
import shadow.bundletool.com.android.tools.r8.com.google.common.collect.Sets;
import shadow.bundletool.com.android.tools.r8.graph.AppInfo;
import shadow.bundletool.com.android.tools.r8.graph.DexClass;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.shaking.AppInfoWithLiveness;

public class MainDexClasses {
    public static MainDexClasses NONE = new MainDexClasses(ImmutableSet.of(), ImmutableSet.of());
    private final Set<DexType> roots;
    private final Set<DexType> dependencies;
    private final Set<DexType> classes;

    private MainDexClasses(Set<DexType> roots, Set<DexType> dependencies) {
        assert (Sets.intersection(roots, dependencies).isEmpty());
        this.roots = Collections.unmodifiableSet(roots);
        this.dependencies = Collections.unmodifiableSet(dependencies);
        this.classes = Sets.union(roots, dependencies);
    }

    public boolean isEmpty() {
        assert (!this.roots.isEmpty() || this.dependencies.isEmpty());
        return this.roots.isEmpty();
    }

    public Set<DexType> getRoots() {
        return this.roots;
    }

    public Set<DexType> getDependencies() {
        return this.dependencies;
    }

    public Set<DexType> getClasses() {
        return this.classes;
    }

    private void collectTypesMatching(Set<DexType> types, Predicate<DexType> predicate, Consumer<DexType> consumer) {
        types.forEach(type -> {
            if (predicate.test((DexType)type)) {
                consumer.accept((DexType)type);
            }
        });
    }

    public MainDexClasses prunedCopy(AppInfoWithLiveness appInfo) {
        Builder builder = MainDexClasses.builder(appInfo);
        Predicate<DexType> wasPruned = appInfo::wasPruned;
        this.collectTypesMatching(this.roots, wasPruned.negate(), builder::addRoot);
        this.collectTypesMatching(this.dependencies, wasPruned.negate(), builder::addDependency);
        return builder.build();
    }

    public static Builder builder(AppInfo appInfo) {
        return new Builder(appInfo);
    }

    public static class Builder {
        public final AppInfo appInfo;
        public final Set<DexType> roots = Sets.newIdentityHashSet();
        public final Set<DexType> dependencies = Sets.newIdentityHashSet();

        private Builder(AppInfo appInfo) {
            this.appInfo = appInfo;
        }

        public Builder addRoot(DexType type) {
            assert (this.isProgramClass(type)) : type.toSourceString();
            this.roots.add(type);
            return this;
        }

        public Builder addRoots(Collection<DexType> rootSet) {
            assert (rootSet.stream().allMatch(this::isProgramClass));
            this.roots.addAll(rootSet);
            return this;
        }

        public Builder addDependency(DexType type) {
            assert (this.isProgramClass(type));
            this.dependencies.add(type);
            return this;
        }

        public boolean contains(DexType type) {
            return this.roots.contains(type) || this.dependencies.contains(type);
        }

        public MainDexClasses build() {
            return new MainDexClasses(this.roots, this.dependencies);
        }

        private boolean isProgramClass(DexType dexType) {
            DexClass clazz = this.appInfo.definitionFor(dexType);
            return clazz != null && clazz.isProgramClass();
        }
    }
}

