/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.bundle.Devices;
import com.android.tools.build.bundletool.commands.AutoValue_InstallApksCommand;
import com.android.tools.build.bundletool.commands.CommandHelp;
import com.android.tools.build.bundletool.commands.ExtractApksCommand;
import com.android.tools.build.bundletool.device.AdbServer;
import com.android.tools.build.bundletool.device.ApksInstaller;
import com.android.tools.build.bundletool.device.DeviceAnalyzer;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.io.TempFiles;
import com.android.tools.build.bundletool.utils.EnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.SdkToolsLocator;
import com.android.tools.build.bundletool.utils.SystemEnvironmentVariableProvider;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;

@AutoValue
public abstract class InstallApksCommand {
    public static final String COMMAND_NAME = "install-apks";
    private static final Flag<Path> ADB_PATH_FLAG = Flag.path("adb");
    private static final Flag<Path> APKS_ARCHIVE_FILE_FLAG = Flag.path("apks");
    private static final Flag<String> DEVICE_ID_FLAG = Flag.string("device-id");
    private static final Flag<ImmutableSet<String>> MODULES_FLAG = Flag.stringSet("modules");
    private static final String ANDROID_HOME_VARIABLE = "ANDROID_HOME";
    private static final EnvironmentVariableProvider DEFAULT_PROVIDER = new SystemEnvironmentVariableProvider();

    public abstract Path getAdbPath();

    public abstract Path getApksArchivePath();

    public abstract Optional<String> getDeviceId();

    public abstract Optional<ImmutableSet<String>> getModules();

    abstract AdbServer getAdbServer();

    public static Builder builder() {
        return new AutoValue_InstallApksCommand.Builder();
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, AdbServer adbServer) {
        return InstallApksCommand.fromFlags(flags, DEFAULT_PROVIDER, adbServer);
    }

    public static InstallApksCommand fromFlags(ParsedFlags flags, EnvironmentVariableProvider environmentVariableProvider, AdbServer adbServer) {
        Path apksArchivePath = APKS_ARCHIVE_FILE_FLAG.getRequiredValue(flags);
        Path adbPath = ADB_PATH_FLAG.getValue(flags).orElseGet(() -> (Path)environmentVariableProvider.getVariable(ANDROID_HOME_VARIABLE).flatMap(path -> new SdkToolsLocator().locateAdb(Paths.get(path, new String[0]))).orElseThrow(() -> new CommandExecutionException("Unable to determine the location of ADB. Please set the --adb flag or define ANDROID_HOME environment variable.")));
        Optional<String> deviceSerialName = DEVICE_ID_FLAG.getValue(flags);
        Optional<ImmutableSet<String>> modules = MODULES_FLAG.getValue(flags);
        flags.checkNoUnknownFlags();
        Builder command = InstallApksCommand.builder().setAdbPath(adbPath).setAdbServer(adbServer).setApksArchivePath(apksArchivePath);
        deviceSerialName.ifPresent(command::setDeviceId);
        modules.ifPresent(command::setModules);
        return command.build();
    }

    public void execute() {
        FilePreconditions.checkFileExistsAndReadable(this.getApksArchivePath());
        FilePreconditions.checkFileExistsAndExecutable(this.getAdbPath());
        AdbServer adbServer = this.getAdbServer();
        adbServer.init(this.getAdbPath());
        TempFiles.withTempDirectory(tempDir -> {
            Devices.DeviceSpec deviceSpec = new DeviceAnalyzer(adbServer).getDeviceSpec(this.getDeviceId());
            ExtractApksCommand.Builder extractApksCommand = ExtractApksCommand.builder().setApksArchivePath(this.getApksArchivePath()).setDeviceSpec(deviceSpec).setOutputDirectory(tempDir);
            this.getModules().ifPresent(extractApksCommand::setModules);
            ImmutableList<Path> extractedApks = extractApksCommand.build().execute();
            ApksInstaller installer = new ApksInstaller(adbServer);
            if (this.getDeviceId().isPresent()) {
                installer.installApks(extractedApks, this.getDeviceId().get());
            } else {
                installer.installApks(extractedApks);
            }
        });
    }

    public static CommandHelp help() {
        return CommandHelp.builder().setCommandName(COMMAND_NAME).setCommandDescription(CommandHelp.CommandDescription.builder().setShortDescription("Installs APKs extracted from an APK Set to a connected device. Replaces already installed package.").addAdditionalParagraph("This will extract from the APK Set archive and install only the APKs that would be served to that device. If the app is not compatible with the device or if the APK Set archive was generated for a different type of device, this command will fail.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(ADB_PATH_FLAG.getName()).setExampleValue("path/to/adb").setOptional(true).setDescription("Path to the adb utility. If absent, an attempt will be made to locate it if the %s environment variable is set.", ANDROID_HOME_VARIABLE).build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(APKS_ARCHIVE_FILE_FLAG.getName()).setExampleValue("archive.apks").setDescription("Path to the archive file generated by the '%s' command.", "build-apks").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(DEVICE_ID_FLAG.getName()).setExampleValue("device-serial-name").setOptional(true).setDescription("Device serial name. Required when more than one device or emulator is connected.").build()).addFlag(CommandHelp.FlagDescription.builder().setFlagName(MODULES_FLAG.getName()).setExampleValue("base,module1,module2").setOptional(true).setDescription("When specified and the device matches split APKs, then only APKs of the specified modules will be installed. Cannot be used if the device matches a non-split APK.").build()).build();
    }

    public static abstract class Builder {
        public abstract Builder setAdbPath(Path var1);

        public abstract Builder setApksArchivePath(Path var1);

        public abstract Builder setDeviceId(String var1);

        public abstract Builder setModules(ImmutableSet<String> var1);

        public abstract Builder setAdbServer(AdbServer var1);

        public abstract InstallApksCommand build();
    }
}

