/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.build.apkzlib.zfile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import shadow.bundletool.com.android.tools.build.apkzlib.sign.ManifestGenerationExtension;
import shadow.bundletool.com.android.tools.build.apkzlib.sign.SigningExtension;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRule;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.AlignmentRules;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFile;
import shadow.bundletool.com.android.tools.build.apkzlib.zip.ZFileOptions;

public class ZFiles {
    private static final AlignmentRule APK_DEFAULT_RULE = AlignmentRules.constant(4);
    private static final String DEFAULT_BUILD_BY = "Generated-by-ADT";
    private static final String DEFAULT_CREATED_BY = "Generated-by-ADT";

    @Nonnull
    public static ZFile apk(@Nonnull File f, @Nonnull ZFileOptions options) throws IOException {
        options.setAlignmentRule(AlignmentRules.compose(options.getAlignmentRule(), APK_DEFAULT_RULE));
        return new ZFile(f, options);
    }

    @Nonnull
    public static ZFile apk(@Nonnull File f, @Nonnull ZFileOptions options, @Nullable PrivateKey key, @Nullable X509Certificate certificate, boolean v1SigningEnabled, boolean v2SigningEnabled, @Nullable String builtBy, @Nullable String createdBy, int minSdkVersion) throws IOException {
        return ZFiles.apk(f, options, key, (ImmutableList<X509Certificate>)(certificate == null ? ImmutableList.of() : ImmutableList.of((Object)certificate)), v1SigningEnabled, v2SigningEnabled, builtBy, createdBy, minSdkVersion);
    }

    @Nonnull
    public static ZFile apk(@Nonnull File f, @Nonnull ZFileOptions options, @Nullable PrivateKey key, @Nonnull ImmutableList<X509Certificate> certificates, boolean v1SigningEnabled, boolean v2SigningEnabled, @Nullable String builtBy, @Nullable String createdBy, int minSdkVersion) throws IOException {
        ZFile zfile = ZFiles.apk(f, options);
        if (builtBy == null) {
            builtBy = "Generated-by-ADT";
        }
        if (createdBy == null) {
            createdBy = "Generated-by-ADT";
        }
        ManifestGenerationExtension manifestExt = new ManifestGenerationExtension(builtBy, createdBy);
        manifestExt.register(zfile);
        if (key != null && !certificates.isEmpty()) {
            try {
                new SigningExtension(minSdkVersion, certificates, key, v1SigningEnabled, v2SigningEnabled).register(zfile);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new IOException("Failed to create signature extensions", e);
            }
        }
        return zfile;
    }
}

