/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedField;
import shadow.bundletool.com.android.tools.r8.graph.DexEncodedMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexField;
import shadow.bundletool.com.android.tools.r8.graph.DexMethod;
import shadow.bundletool.com.android.tools.r8.graph.DexProgramClass;
import shadow.bundletool.com.android.tools.r8.graph.DexString;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.naming.MemberNaming;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;

public class MinifiedNameMapPrinter {
    private static final String NEW_LINE = "\n";
    private final DexApplication application;
    private final NamingLens namingLens;
    private final Set<DexType> seenTypes = Sets.newIdentityHashSet();

    public MinifiedNameMapPrinter(DexApplication application, NamingLens namingLens) {
        this.application = application;
        this.namingLens = namingLens;
    }

    private <T> T[] sortedCopy(T[] source, Comparator<? super T> comparator) {
        T[] copy = Arrays.copyOf(source, source.length);
        Arrays.sort(copy, comparator);
        return copy;
    }

    private void writeClass(DexProgramClass clazz, StringBuilder out) {
        this.seenTypes.add(clazz.type);
        DexString descriptor = this.namingLens.lookupDescriptor(clazz.type);
        out.append(DescriptorUtils.descriptorToJavaType(clazz.type.descriptor.toSourceString()));
        out.append(" -> ");
        out.append(DescriptorUtils.descriptorToJavaType(descriptor.toSourceString()));
        out.append(":").append(NEW_LINE);
        this.writeFields(this.sortedCopy(clazz.instanceFields(), Comparator.comparing(DexEncodedField::toSourceString)), out);
        this.writeFields(this.sortedCopy(clazz.staticFields(), Comparator.comparing(DexEncodedField::toSourceString)), out);
        this.writeMethods(this.sortedCopy(clazz.directMethods(), Comparator.comparing(DexEncodedMethod::toSourceString)), out);
        this.writeMethods(this.sortedCopy(clazz.virtualMethods(), Comparator.comparing(DexEncodedMethod::toSourceString)), out);
    }

    private void writeType(DexType type, StringBuilder out) {
        if (type.isClassType() && this.seenTypes.add(type)) {
            DexString descriptor = this.namingLens.lookupDescriptor(type);
            out.append(DescriptorUtils.descriptorToJavaType(type.descriptor.toSourceString()));
            out.append(" -> ");
            out.append(DescriptorUtils.descriptorToJavaType(descriptor.toSourceString()));
            out.append(":").append(NEW_LINE);
        }
    }

    private void writeFields(DexEncodedField[] fields, StringBuilder out) {
        for (DexEncodedField encodedField : fields) {
            DexField field = encodedField.field;
            DexString renamed = this.namingLens.lookupName(field);
            if (renamed == field.name) continue;
            out.append("    ");
            out.append(field.type.toSourceString());
            out.append(" ");
            out.append(field.name.toSourceString());
            out.append(" -> ");
            out.append(renamed.toSourceString()).append(NEW_LINE);
        }
    }

    private void writeMethod(MemberNaming.MethodSignature signature, String renamed, StringBuilder out) {
        out.append("    ");
        out.append(signature.toString());
        out.append(" -> ");
        out.append(renamed).append(NEW_LINE);
    }

    private void writeMethods(DexEncodedMethod[] methods, StringBuilder out) {
        for (DexEncodedMethod encodedMethod : methods) {
            DexMethod method = encodedMethod.method;
            DexString renamed = this.namingLens.lookupName(method);
            if (renamed == method.name) continue;
            MemberNaming.MethodSignature signature = MemberNaming.MethodSignature.fromDexMethod(method);
            String renamedSourceString = renamed.toSourceString();
            this.writeMethod(signature, renamedSourceString, out);
        }
    }

    public void write(StringBuilder out) {
        ArrayList<DexProgramClass> classes = new ArrayList<DexProgramClass>(this.application.classes());
        classes.sort(Comparator.comparing(DexProgramClass::toSourceString));
        classes.forEach(clazz -> this.writeClass((DexProgramClass)clazz, out));
        this.namingLens.forAllRenamedTypes(type -> this.writeType((DexType)type, out));
    }
}

