/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.naming;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import shadow.bundletool.com.android.tools.r8.graph.DexApplication;
import shadow.bundletool.com.android.tools.r8.naming.ClassNameMapper;
import shadow.bundletool.com.android.tools.r8.naming.MinifiedNameMapPrinter;
import shadow.bundletool.com.android.tools.r8.naming.NamingLens;

public class ProguardMapSupplier {
    private final boolean useClassNameMapper;
    private final ClassNameMapper classNameMapper;
    private final NamingLens namingLens;
    private final DexApplication application;

    public static ProguardMapSupplier fromClassNameMapper(ClassNameMapper classNameMapper) {
        return new ProguardMapSupplier(classNameMapper);
    }

    public static ProguardMapSupplier fromNamingLens(NamingLens namingLens, DexApplication dexApplication) {
        return new ProguardMapSupplier(namingLens, dexApplication);
    }

    private ProguardMapSupplier(ClassNameMapper classNameMapper) {
        this.useClassNameMapper = true;
        this.classNameMapper = classNameMapper;
        this.namingLens = null;
        this.application = null;
    }

    private ProguardMapSupplier(NamingLens namingLens, DexApplication dexApplication) {
        this.useClassNameMapper = false;
        this.classNameMapper = null;
        this.namingLens = namingLens;
        this.application = dexApplication;
    }

    public String get() {
        if (this.useClassNameMapper) {
            assert (this.classNameMapper != null);
            return this.classNameMapper.toString();
        }
        assert (this.namingLens != null && this.application != null);
        if (!this.namingLens.isIdentityLens()) {
            StringBuilder map = new StringBuilder();
            new MinifiedNameMapPrinter(this.application, this.namingLens).write(map);
            return map.toString();
        }
        if (this.application.getProguardMap() != null) {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(bytes);
            try {
                this.application.getProguardMap().write(writer);
                ((Writer)writer).flush();
            }
            catch (IOException e) {
                throw new RuntimeException("IOException while creating Proguard-map output: " + e);
            }
            return bytes.toString();
        }
        return "# This Proguard-map is intentionally empty because no names or line numbers have been changed.\n";
    }
}

