/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.shaking;

public abstract class ProguardNameMatcher {
    private static final ProguardNameMatcher MATCH_ALL_NAMES = new MatchAllNames();

    private ProguardNameMatcher() {
    }

    public static ProguardNameMatcher create(String pattern) {
        if (pattern.equals("*")) {
            return MATCH_ALL_NAMES;
        }
        if (pattern.contains("*") || pattern.contains("?")) {
            return new MatchNamePattern(pattern);
        }
        return new MatchSpecificName(pattern);
    }

    public static boolean matchFieldOrMethodName(String pattern, String name) {
        return ProguardNameMatcher.matchFieldOrMethodNameImpl(pattern, 0, name, 0);
    }

    private static boolean matchFieldOrMethodNameImpl(String pattern, int patternIndex, String name, int nameIndex) {
        block4: for (int i = patternIndex; i < pattern.length(); ++i) {
            char patternChar = pattern.charAt(i);
            switch (patternChar) {
                case '*': {
                    for (int nextNameIndex = nameIndex; nextNameIndex <= name.length(); ++nextNameIndex) {
                        if (!ProguardNameMatcher.matchFieldOrMethodNameImpl(pattern, i + 1, name, nextNameIndex)) continue;
                        return true;
                    }
                    return false;
                }
                case '?': {
                    if (nameIndex == name.length()) {
                        return false;
                    }
                    ++nameIndex;
                    continue block4;
                }
                default: {
                    if (nameIndex != name.length() && patternChar == name.charAt(nameIndex++)) continue block4;
                    return false;
                }
            }
        }
        return nameIndex == name.length();
    }

    public abstract boolean matches(String var1);

    private static class MatchSpecificName
    extends ProguardNameMatcher {
        private final String name;

        MatchSpecificName(String name) {
            this.name = name;
        }

        @Override
        public boolean matches(String name) {
            return this.name.equals(name);
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            return o instanceof MatchSpecificName && this.name.equals(((MatchSpecificName)o).name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }

    private static class MatchNamePattern
    extends ProguardNameMatcher {
        private final String pattern;

        MatchNamePattern(String pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(String name) {
            return MatchNamePattern.matchFieldOrMethodName(this.pattern, name);
        }

        public String toString() {
            return this.pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof MatchNamePattern && this.pattern.equals(((MatchNamePattern)o).pattern);
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }
    }

    private static class MatchAllNames
    extends ProguardNameMatcher {
        private MatchAllNames() {
        }

        @Override
        public boolean matches(String name) {
            return true;
        }

        public String toString() {
            return "*";
        }
    }
}

