/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import com.google.common.collect.Sets;
import java.util.Set;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.StringResource;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.graph.DexItemFactory;
import shadow.bundletool.com.android.tools.r8.graph.DexType;
import shadow.bundletool.com.android.tools.r8.position.TextPosition;

public class MainDexList {
    public static DexType parseEntry(String clazz, DexItemFactory itemFactory) {
        if (!clazz.endsWith(".class")) {
            throw new CompilationError("Illegal main-dex-list entry '" + clazz + "'.");
        }
        String name = clazz.substring(0, clazz.length() - ".class".length());
        if (name.contains(".")) {
            throw new CompilationError("Illegal main-dex-list entry '" + clazz + "'.");
        }
        String descriptor = "L" + name + ";";
        return itemFactory.createType(descriptor);
    }

    public static Set<DexType> parseList(StringResource resource, DexItemFactory itemFactory) {
        String lines;
        try {
            lines = resource.getString();
        }
        catch (ResourceException e) {
            throw new CompilationError("Failed to parse main-dex resource", e, resource.getOrigin());
        }
        Set result = Sets.newIdentityHashSet();
        int lineNumber = 0;
        int offset = 0;
        while (offset < lines.length()) {
            ++lineNumber;
            int newLineIndex = lines.indexOf(10, offset);
            int lineEnd = newLineIndex == -1 ? lines.length() : newLineIndex;
            String line = lines.substring(offset, lineEnd).trim();
            if (!line.isEmpty()) {
                try {
                    result.add(MainDexList.parseEntry(line, itemFactory));
                }
                catch (CompilationError e) {
                    throw new CompilationError(e.getMessage(), (Throwable)e, resource.getOrigin(), new TextPosition(offset, lineNumber, -1));
                }
            }
            offset = lineEnd + 1;
        }
        return result;
    }
}

