/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoAttributeBuilder;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoElementBuilder;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.utils.xmlproto.XmlProtoNodeBuilder;
import com.google.common.collect.ImmutableList;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;

public class ManifestEditor {
    private static final int OPEN_GL_VERSION_MULTIPLIER = 65536;
    private static final ImmutableList<String> SPLIT_NAME_ELEMENT_NAMES = ImmutableList.of((Object)"activity", (Object)"service", (Object)"provider");
    private final XmlProtoNodeBuilder rootNode;
    private final XmlProtoElementBuilder manifestElement;

    public ManifestEditor(XmlProtoNode rootNode) {
        this.rootNode = rootNode.toBuilder();
        this.manifestElement = (XmlProtoElementBuilder)this.rootNode.getElement();
    }

    public XmlProtoElementBuilder getRawProto() {
        return this.manifestElement;
    }

    public ManifestEditor setMinSdkVersion(int minSdkVersion) {
        return this.setUsesSdkAttribute("minSdkVersion", 16843276, minSdkVersion);
    }

    public ManifestEditor setMaxSdkVersion(int maxSdkVersion) {
        return this.setUsesSdkAttribute("maxSdkVersion", 16843377, maxSdkVersion);
    }

    public ManifestEditor setSplitIdForFeatureSplit(String splitId) {
        if (ManifestEditor.isBaseSplit(splitId)) {
            this.manifestElement.removeAttribute("", "split");
            this.manifestElement.removeAttribute("http://schemas.android.com/apk/res/android", "isFeatureSplit");
        } else {
            this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
            this.manifestElement.getOrCreateAndroidAttribute("isFeatureSplit", 16844123).setValueAsBoolean(true);
        }
        this.manifestElement.removeAttribute("", "configForSplit");
        return this;
    }

    public ManifestEditor setHasCode(boolean value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute("hasCode", 0x101000C).setValueAsBoolean(value);
        return this;
    }

    public ManifestEditor setPackage(String packageName) {
        this.manifestElement.getOrCreateAttribute("package").setValueAsString(packageName);
        return this;
    }

    public ManifestEditor setVersionCode(int versionCode) {
        this.manifestElement.getOrCreateAndroidAttribute("versionCode", 16843291).setValueAsDecimalInteger(versionCode);
        return this;
    }

    public ManifestEditor setConfigForSplit(String featureSplitId) {
        this.manifestElement.getOrCreateAttribute("configForSplit").setValueAsString(featureSplitId);
        return this;
    }

    public ManifestEditor setSplitId(String splitId) {
        this.manifestElement.getOrCreateAttribute("split").setValueAsString(splitId);
        return this;
    }

    public ManifestEditor setTargetSandboxVersion(int version) {
        this.manifestElement.getOrCreateAndroidAttribute("targetSandboxVersion", 16844108).setValueAsDecimalInteger(version);
        return this;
    }

    public ManifestEditor addMetaDataString(String key, String value) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(key)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(value)));
        return this;
    }

    public ManifestEditor addMetaDataInteger(String key, int value) {
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString(key)).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsDecimalInteger(value)));
        return this;
    }

    public ManifestEditor setExtractNativeLibsValue(boolean value) {
        this.manifestElement.getOrCreateChildElement("application").getOrCreateAndroidAttribute("extractNativeLibs", 16844010).setValueAsBoolean(value);
        return this;
    }

    public ManifestEditor setFusedModuleNames(ImmutableList<String> moduleNames) {
        String moduleNamesString = moduleNames.stream().sorted().distinct().collect(Collectors.joining(","));
        this.manifestElement.getOrCreateChildElement("application").addChildElement(XmlProtoElementBuilder.create("meta-data").addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("name", 0x1010003).setValueAsString("shadow.bundletool.com.android.dynamic.apk.fused.modules")).addAttribute(XmlProtoAttributeBuilder.createAndroidAttribute("value", 16842788).setValueAsString(moduleNamesString)));
        return this;
    }

    public ManifestEditor removeSplitName() {
        this.manifestElement.getOrCreateChildElement("application").getChildrenElements(el -> SPLIT_NAME_ELEMENT_NAMES.contains((Object)el.getName())).forEach(element -> element.removeAndroidAttribute(16844105));
        return this;
    }

    @CheckReturnValue
    public AndroidManifest save() {
        return AndroidManifest.create(this.rootNode.build());
    }

    private ManifestEditor setUsesSdkAttribute(String attributeName, int attributeResId, int value) {
        this.manifestElement.getOrCreateChildElement("uses-sdk").getOrCreateAndroidAttribute(attributeName, attributeResId).setValueAsDecimalInteger(value);
        return this;
    }

    private static boolean isBaseSplit(String splitId) {
        return splitId.isEmpty();
    }
}

