/*
 * Decompiled with CFR 0.152.
 */
package shadow.bundletool.com.android.tools.r8.utils;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import shadow.bundletool.com.android.tools.r8.ProgramResource;
import shadow.bundletool.com.android.tools.r8.ProgramResourceProvider;
import shadow.bundletool.com.android.tools.r8.ResourceException;
import shadow.bundletool.com.android.tools.r8.errors.CompilationError;
import shadow.bundletool.com.android.tools.r8.origin.ArchiveEntryOrigin;
import shadow.bundletool.com.android.tools.r8.origin.Origin;
import shadow.bundletool.com.android.tools.r8.origin.PathOrigin;
import shadow.bundletool.com.android.tools.r8.shaking.FilteredClassPath;
import shadow.bundletool.com.android.tools.r8.utils.DescriptorUtils;
import shadow.bundletool.com.android.tools.r8.utils.FileUtils;
import shadow.bundletool.com.android.tools.r8.utils.OneShotByteResource;
import shadow.bundletool.com.android.tools.r8.utils.ZipUtils;

public class FilteredArchiveProgramResourceProvider
implements ProgramResourceProvider {
    private final Origin origin;
    private final FilteredClassPath archive;
    private final boolean ignoreDexInArchive;

    FilteredArchiveProgramResourceProvider(FilteredClassPath archive, boolean ignoreDexInArchive) {
        this.origin = new PathOrigin(archive.getPath());
        this.archive = archive;
        this.ignoreDexInArchive = ignoreDexInArchive;
    }

    private List<ProgramResource> readArchive() throws IOException {
        assert (FileUtils.isArchive(this.archive.getPath()));
        ArrayList<ProgramResource> dexResources = new ArrayList<ProgramResource>();
        ArrayList<ProgramResource> classResources = new ArrayList<ProgramResource>();
        try (ZipFile zipFile = new ZipFile(this.archive.getPath().toFile(), StandardCharsets.UTF_8);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                Throwable throwable = null;
                try {
                    String name = entry.getName();
                    ArchiveEntryOrigin entryOrigin = new ArchiveEntryOrigin(name, this.origin);
                    if (!this.archive.matchesFile(name)) continue;
                    if (ZipUtils.isDexFile(name)) {
                        if (this.ignoreDexInArchive) continue;
                        ProgramResource resource = OneShotByteResource.create(ProgramResource.Kind.DEX, entryOrigin, ByteStreams.toByteArray((InputStream)stream), null);
                        dexResources.add(resource);
                        continue;
                    }
                    if (!ZipUtils.isClassFile(name)) continue;
                    String descriptor = DescriptorUtils.guessTypeDescriptor(name);
                    ProgramResource resource = OneShotByteResource.create(ProgramResource.Kind.CF, entryOrigin, ByteStreams.toByteArray((InputStream)stream), Collections.singleton(descriptor));
                    classResources.add(resource);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stream == null) continue;
                    FilteredArchiveProgramResourceProvider.$closeResource(throwable, stream);
                }
            }
        }
        catch (ZipException e) {
            throw new CompilationError("Zip error while reading '" + this.archive + "': " + e.getMessage(), e);
        }
        if (!dexResources.isEmpty() && !classResources.isEmpty()) {
            throw new CompilationError("Cannot create android app from an archive '" + this.archive + "' containing both DEX and Java-bytecode content");
        }
        return !dexResources.isEmpty() ? dexResources : classResources;
    }

    @Override
    public Collection<ProgramResource> getProgramResources() throws ResourceException {
        try {
            return this.readArchive();
        }
        catch (IOException e) {
            throw new ResourceException(this.origin, (Throwable)e);
        }
    }
}

