/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.optimizations;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.AutoValue_ApkOptimizations;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;
import java.util.Map;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ApkOptimizations {
    private static final ImmutableSortedMap<Version, ApkOptimizations> DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION = ImmutableSortedMap.naturalOrder().put((Object)Version.of("0.0.0-dev"), (Object)ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY), (Object)((Object)OptimizationDimension.LANGUAGE))).setStandaloneDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY))).build()).put((Object)Version.of("0.6.0"), (Object)ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY), (Object)((Object)OptimizationDimension.LANGUAGE))).setUncompressNativeLibraries(true).setStandaloneDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY))).build()).put((Object)Version.of("0.10.2"), (Object)ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY), (Object)((Object)OptimizationDimension.TEXTURE_COMPRESSION_FORMAT), (Object)((Object)OptimizationDimension.LANGUAGE))).setUncompressNativeLibraries(true).setStandaloneDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of((Object)((Object)OptimizationDimension.ABI), (Object)((Object)OptimizationDimension.SCREEN_DENSITY))).build()).build();
    private static final ImmutableSet<OptimizationDimension> DIMENSIONS_SUPPORTED_BY_ASSET_MODULES = ImmutableSet.of((Object)((Object)OptimizationDimension.LANGUAGE), (Object)((Object)OptimizationDimension.TEXTURE_COMPRESSION_FORMAT), (Object)((Object)OptimizationDimension.DEVICE_TIER));

    public abstract ImmutableSet<OptimizationDimension> getSplitDimensions();

    public ImmutableSet<OptimizationDimension> getSplitDimensionsForAssetModules() {
        return Sets.intersection(this.getSplitDimensions(), DIMENSIONS_SUPPORTED_BY_ASSET_MODULES).immutableCopy();
    }

    public abstract boolean getUncompressNativeLibraries();

    public abstract boolean getUncompressDexFiles();

    public abstract Config.UncompressDexFiles.UncompressedDexTargetSdk getUncompressedDexTargetSdk();

    public abstract ImmutableSet<OptimizationDimension> getStandaloneDimensions();

    public abstract ImmutableMap<OptimizationDimension, Config.SuffixStripping> getSuffixStrippings();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ApkOptimizations.Builder().setUncompressNativeLibraries(false).setUncompressDexFiles(false).setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk.UNSPECIFIED).setSuffixStrippings((ImmutableMap<OptimizationDimension, Config.SuffixStripping>)ImmutableMap.of());
    }

    public static ApkOptimizations getDefaultOptimizationsForVersion(Version bundleToolVersion) {
        return (ApkOptimizations)((Map.Entry)Preconditions.checkNotNull((Object)DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION.floorEntry((Object)bundleToolVersion), (String)"No default optimizations found for BundleTool version %s.", (Object)bundleToolVersion)).getValue();
    }

    public static ApkOptimizations getOptimizationsForUniversalApk() {
        return ApkOptimizations.builder().setSplitDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of()).setStandaloneDimensions((ImmutableSet<OptimizationDimension>)ImmutableSet.of()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSplitDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setUncompressNativeLibraries(boolean var1);

        public abstract Builder setUncompressDexFiles(boolean var1);

        public abstract Builder setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk var1);

        public abstract Builder setStandaloneDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setSuffixStrippings(ImmutableMap<OptimizationDimension, Config.SuffixStripping> var1);

        public abstract ApkOptimizations build();
    }
}

